<?php
/*
 * $Horde: imp/view.php,v 2.101.2.25 2005/04/05 16:56:22 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('IMP_BASE', dirname(__FILE__));

$session_control = 'cache_ssl_downloads';
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Browser.php';
require_once HORDE_BASE . '/lib/MIME.php';
require_once HORDE_BASE . '/lib/SessionCache.php';
require_once HORDE_BASE . '/lib/MIME/Part.php';
require_once HORDE_BASE . '/lib/MIME/Viewer.php';
require_once HORDE_BASE . '/config/mime_drivers.php';
require_once HORDE_BASE . '/config/mime_mapping.php';
require_once IMP_BASE .   '/config/mime_drivers.php';

IMP::checkAuthentication();

$actionID = Horde::getFormData('actionID');
$index = Horde::getFormData('index');
$id = Horde::getFormData('id');
if (empty($index) || is_null($id)) {
    // Prevent blind fetching of attachments without knowing both id
    // and index. Index must be non-empty; id can be part 0 (whole
    // message) so just make sure that it's specified.
    exit;
}

if (($actionID != SAVE_MESSAGE) && ($actionID != VIEW_SOURCE)) {
    $mime = SessionCache::getObject(Horde::getFormData('mime'));
    if (empty($mime)) {
        include_once HORDE_BASE . '/lib/MIME/Structure.php';
        $structure = imap_fetchstructure($imp['stream'], $index, FT_UID);
        $attachments = MIME_Structure::parse($structure, $index, $MimeID);
        $mime = $attachments[$id];
    }

    $body = imap_fetchbody($imp['stream'], $index, $id, FT_UID);

    if ($mime->encoding == ENCBASE64) {
        $body = imap_base64($body);
    } elseif ($mime->encoding == ENCQUOTEDPRINTABLE && ($qprint_msg = imap_qprint($body))) {
        $body = $qprint_msg;
    }
}

/* Start to compress pages if requested. */
if ($conf['compress_pages'] && ($actionID != SAVE_MESSAGE) &&
    ($actionID != DOWNLOAD_ATTACH)) {
    ob_start('ob_gzhandler');
}

/* Run through action handlers */
switch ($actionID) {
 case DOWNLOAD_ATTACH:
     IMP_Browser::downloadHeaders(MIME::decode($mime->name), $mime_types[$mime->type] . '-' . $mime->subtype, false, strlen($body));
     echo $body;
     exit;

 case VIEW_ATTACH:
     $mime_type = $mime->TYPE . '/' . $mime->subtype;

     /* If this is a text/html part, then we need to scan for CIDs
      * embedded in it in order to display images that might be
      * inlined in other parts of the message. */
     if ($mime_type == 'text/html' ) {
         include_once HORDE_BASE . '/lib/MIME/Structure.php';
         MIME_Structure::parse(imap_fetchstructure($imp['stream'], $index, FT_UID), $index, $MimeID);
     }

     $ob = new MIME_Part($mime_type, IMP::getDecodedPart($mime), $mime->charset);
     if (isset($mime->filename)) {
         $ob->setName($mime->filename);
     }
     $viewer = &MIME_Viewer::factory($ob);

     $mime_type = $viewer->getType();
     if (substr($mime_type, 0, 4) == 'text') {
         $mime_type .= '; charset=' . $viewer->getCharset($ob);
     }
     IMP_Browser::downloadHeaders(MIME::decode($mime->name), $mime_type, true, strlen($body));
     echo $viewer->render($mime);
     exit;

 case VIEW_SOURCE:
     $msg = imap_fetchheader($imp['stream'], $index, FT_UID) . "\n" . imap_body($imp['stream'], $index, FT_UID);
     IMP_Browser::downloadHeaders('Message Source', 'text/plain', true, strlen($msg));
     echo $msg;
     exit;

 case SAVE_MESSAGE:
     $h = imap_header($imp['stream'], imap_msgno($imp['stream'], $index));

     if (!empty($h->subject)) {
         $name = preg_replace('|\W|', '_', MIME::decode($h->subject));
     } else {
         $name = 'message';
     }

     $from = '<>';
     if (isset($h->from[0])) {
         if (isset($h->from[0]->mailbox) && isset($h->from[0]->host)) {
             $from = $h->from[0]->mailbox . '@' . $h->from[0]->host;
         }
     }
     $date  = strftime('%a %b %d %H:%M:%S %Y', $h->udate);
     $body  = 'From ' . $from . ' ' . $date. "\n";
     $body .= imap_fetchheader($imp['stream'], $index, FT_UID);
     $body .= imap_body($imp['stream'], $index, FT_UID);
     $body  = str_replace("\r\n", "\n", $body);

     IMP_Browser::downloadHeaders($name, null, false, strlen($body));
     echo $body;
     exit;
}
