/* multiloadindicator.c generated by valac 0.12.0, the Vala compiler
 * generated from multiloadindicator.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <libappindicator/app-indicator.h>
#include <glib/gstdio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ICON_MENU (icon_menu_get_type ())
#define ICON_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_MENU, IconMenu))
#define ICON_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_MENU, IconMenuClass))
#define IS_ICON_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_MENU))
#define IS_ICON_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_MENU))
#define ICON_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_MENU, IconMenuClass))

typedef struct _IconMenu IconMenu;
typedef struct _IconMenuClass IconMenuClass;
typedef struct _IconMenuPrivate IconMenuPrivate;
typedef struct _ParamSpecIconMenu ParamSpecIconMenu;

#define TYPE_MULTI_LOAD_INDICATOR (multi_load_indicator_get_type ())
#define MULTI_LOAD_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_LOAD_INDICATOR, MultiLoadIndicator))
#define MULTI_LOAD_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_LOAD_INDICATOR, MultiLoadIndicatorClass))
#define IS_MULTI_LOAD_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_LOAD_INDICATOR))
#define IS_MULTI_LOAD_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_LOAD_INDICATOR))
#define MULTI_LOAD_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_LOAD_INDICATOR, MultiLoadIndicatorClass))

typedef struct _MultiLoadIndicator MultiLoadIndicator;
typedef struct _MultiLoadIndicatorClass MultiLoadIndicatorClass;
typedef struct _MultiLoadIndicatorPrivate MultiLoadIndicatorPrivate;

#define TYPE_ICON_DATA (icon_data_get_type ())
#define ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_DATA, IconData))
#define ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_DATA, IconDataClass))
#define IS_ICON_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_DATA))
#define IS_ICON_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_DATA))
#define ICON_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_DATA, IconDataClass))

typedef struct _IconData IconData;
typedef struct _IconDataClass IconDataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ICON_TRACE_DATA (icon_trace_data_get_type ())
#define ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_TRACE_DATA, IconTraceData))
#define ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_TRACE_DATA, IconTraceDataClass))
#define IS_ICON_TRACE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_TRACE_DATA))
#define IS_ICON_TRACE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_TRACE_DATA))
#define ICON_TRACE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_TRACE_DATA, IconTraceDataClass))

typedef struct _IconTraceData IconTraceData;
typedef struct _IconTraceDataClass IconTraceDataClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _icon_menu_unref0(var) ((var == NULL) ? NULL : (var = (icon_menu_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _IconMenu {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IconMenuPrivate * priv;
	GtkMenuItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _IconMenuClass {
	GTypeClass parent_class;
	void (*finalize) (IconMenu *self);
};

struct _ParamSpecIconMenu {
	GParamSpec parent_instance;
};

struct _MultiLoadIndicator {
	GObject parent_instance;
	MultiLoadIndicatorPrivate * priv;
};

struct _MultiLoadIndicatorClass {
	GObjectClass parent_class;
};

struct _MultiLoadIndicatorPrivate {
	guint currenticonindex;
	guint lastwidth;
	gchar* icondirectory;
	GSource* timeout;
	AppIndicator* indicator;
	IconMenu** icon_menus;
	gint icon_menus_length1;
	gint _icon_menus_size_;
	guint _size;
	guint _speed;
	IconData** _icon_datas;
	gint _icon_datas_length1;
	gint __icon_datas_size_;
	GtkMenu* _menu;
	guint _height;
};


static gpointer icon_menu_parent_class = NULL;
static gpointer multi_load_indicator_parent_class = NULL;

gpointer icon_menu_ref (gpointer instance);
void icon_menu_unref (gpointer instance);
GParamSpec* param_spec_icon_menu (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_icon_menu (GValue* value, gpointer v_object);
void value_take_icon_menu (GValue* value, gpointer v_object);
gpointer value_get_icon_menu (const GValue* value);
GType icon_menu_get_type (void) G_GNUC_CONST;
enum  {
	ICON_MENU_DUMMY_PROPERTY
};
IconMenu* icon_menu_new (void);
IconMenu* icon_menu_construct (GType object_type);
static void icon_menu_finalize (IconMenu* obj);
GType multi_load_indicator_get_type (void) G_GNUC_CONST;
GType icon_data_get_type (void) G_GNUC_CONST;
#define MULTI_LOAD_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MULTI_LOAD_INDICATOR, MultiLoadIndicatorPrivate))
enum  {
	MULTI_LOAD_INDICATOR_DUMMY_PROPERTY,
	MULTI_LOAD_INDICATOR_HEIGHT,
	MULTI_LOAD_INDICATOR_SIZE,
	MULTI_LOAD_INDICATOR_SPEED,
	MULTI_LOAD_INDICATOR_MENU
};
static gchar* multi_load_indicator_iconpath (MultiLoadIndicator* self, guint index);
void multi_load_indicator_destroy (MultiLoadIndicator* self);
MultiLoadIndicator* multi_load_indicator_new (const gchar* datadirectory);
MultiLoadIndicator* multi_load_indicator_construct (GType object_type, const gchar* datadirectory);
void multi_load_indicator_set_size (MultiLoadIndicator* self, guint value);
void multi_load_indicator_set_speed (MultiLoadIndicator* self, guint value);
void multi_load_indicator_add_icon_data (MultiLoadIndicator* self, IconData* data);
void icon_data_set_trace_length (IconData* self, guint value);
static void _vala_array_add3 (IconData*** array, int* length, int* size, IconData* value);
static void _vala_array_add4 (IconMenu*** array, int* length, int* size, IconMenu* value);
static gchar* multi_load_indicator_iconname (MultiLoadIndicator* self, guint index);
static gchar* multi_load_indicator_write (MultiLoadIndicator* self, guint index);
gboolean icon_data_get_enabled (IconData* self);
guint multi_load_indicator_get_height (MultiLoadIndicator* self);
void icon_data_set_source_color (IconData* self, cairo_t* ctx);
GType icon_trace_data_get_type (void) G_GNUC_CONST;
IconTraceData** icon_data_get_traces (IconData* self, int* result_length1);
gdouble icon_data_get_scale (IconData* self);
gdouble* icon_trace_data_get_values (IconTraceData* self, int* result_length1);
void icon_trace_data_get_color (IconTraceData* self, GdkColor* result);
void multi_load_indicator_set_height (MultiLoadIndicator* self, guint value);
guint multi_load_indicator_get_size (MultiLoadIndicator* self);
guint multi_load_indicator_get_speed (MultiLoadIndicator* self);
static gboolean _lambda0_ (MultiLoadIndicator* self);
void icon_data_update (IconData* self);
gchar** icon_data_get_menuitems (IconData* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
GtkMenu* multi_load_indicator_get_menu (MultiLoadIndicator* self);
static void _vala_array_add5 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value);
static GtkMenuItem** _vala_array_dup8 (GtkMenuItem** self, int length);
static void _lambda1_ (GtkWindow* w, MultiLoadIndicator* self);
static void _lambda2_ (GtkWidget* w, MultiLoadIndicator* self);
static void __lambda2__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda1__gfunc (gconstpointer data, gpointer self);
static gboolean __lambda0__gsource_func (gpointer self);
IconData** multi_load_indicator_get_icon_datas (MultiLoadIndicator* self, int* result_length1);
void multi_load_indicator_set_menu (MultiLoadIndicator* self, GtkMenu* value);
static void multi_load_indicator_finalize (GObject* obj);
static void _vala_multi_load_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_multi_load_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


IconMenu* icon_menu_construct (GType object_type) {
	IconMenu* self = NULL;
	self = (IconMenu*) g_type_create_instance (object_type);
	return self;
}


IconMenu* icon_menu_new (void) {
	return icon_menu_construct (TYPE_ICON_MENU);
}


static void value_icon_menu_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_icon_menu_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		icon_menu_unref (value->data[0].v_pointer);
	}
}


static void value_icon_menu_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = icon_menu_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_icon_menu_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_icon_menu_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		IconMenu* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = icon_menu_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_icon_menu_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IconMenu** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = icon_menu_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_icon_menu (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecIconMenu* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ICON_MENU), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_icon_menu (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_MENU), NULL);
	return value->data[0].v_pointer;
}


void value_set_icon_menu (GValue* value, gpointer v_object) {
	IconMenu* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_MENU));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ICON_MENU));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		icon_menu_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		icon_menu_unref (old);
	}
}


void value_take_icon_menu (GValue* value, gpointer v_object) {
	IconMenu* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_MENU));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ICON_MENU));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		icon_menu_unref (old);
	}
}


static void icon_menu_class_init (IconMenuClass * klass) {
	icon_menu_parent_class = g_type_class_peek_parent (klass);
	ICON_MENU_CLASS (klass)->finalize = icon_menu_finalize;
}


static void icon_menu_instance_init (IconMenu * self) {
	self->ref_count = 1;
}


static void icon_menu_finalize (IconMenu* obj) {
	IconMenu * self;
	self = ICON_MENU (obj);
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
}


/******************************************************************************
 * Copyright (C) 2011  Michael Hofmann <mh21@piware.de>                       *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType icon_menu_get_type (void) {
	static volatile gsize icon_menu_type_id__volatile = 0;
	if (g_once_init_enter (&icon_menu_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_icon_menu_init, value_icon_menu_free_value, value_icon_menu_copy_value, value_icon_menu_peek_pointer, "p", value_icon_menu_collect_value, "p", value_icon_menu_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IconMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconMenu), 0, (GInstanceInitFunc) icon_menu_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType icon_menu_type_id;
		icon_menu_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IconMenu", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&icon_menu_type_id__volatile, icon_menu_type_id);
	}
	return icon_menu_type_id__volatile;
}


gpointer icon_menu_ref (gpointer instance) {
	IconMenu* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void icon_menu_unref (gpointer instance) {
	IconMenu* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ICON_MENU_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void multi_load_indicator_destroy (MultiLoadIndicator* self) {
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	if (self->priv->timeout == NULL) {
		return;
	}
	g_source_destroy (self->priv->timeout);
	_g_source_unref0 (self->priv->timeout);
	self->priv->timeout = NULL;
}


MultiLoadIndicator* multi_load_indicator_construct (GType object_type, const gchar* datadirectory) {
	MultiLoadIndicator * self = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (datadirectory != NULL, NULL);
	self = (MultiLoadIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = g_build_filename (datadirectory, "icons", NULL);
	_g_free0 (self->priv->icondirectory);
	self->priv->icondirectory = _tmp0_;
	g_mkdir (self->priv->icondirectory, 0777);
	self->priv->currenticonindex = (guint) 0;
	multi_load_indicator_set_size (self, (guint) 40);
	multi_load_indicator_set_speed (self, (guint) 1000);
	return self;
}


MultiLoadIndicator* multi_load_indicator_new (const gchar* datadirectory) {
	return multi_load_indicator_construct (TYPE_MULTI_LOAD_INDICATOR, datadirectory);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add3 (IconData*** array, int* length, int* size, IconData* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IconData*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (IconMenu*** array, int* length, int* size, IconMenu* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IconMenu*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void multi_load_indicator_add_icon_data (MultiLoadIndicator* self, IconData* data) {
	IconData* _tmp0_;
	IconMenu* _tmp1_ = NULL;
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	g_return_if_fail (IS_ICON_DATA (data));
	icon_data_set_trace_length (data, self->priv->_size);
	_tmp0_ = _g_object_ref0 (data);
	_vala_array_add3 (&self->priv->_icon_datas, &self->priv->_icon_datas_length1, &self->priv->__icon_datas_size_, _tmp0_);
	_tmp1_ = icon_menu_new ();
	_vala_array_add4 (&self->priv->icon_menus, &self->priv->icon_menus_length1, &self->priv->_icon_menus_size_, _tmp1_);
}


static gchar* multi_load_indicator_iconname (MultiLoadIndicator* self, guint index) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), NULL);
	_tmp0_ = g_strdup_printf ("%u", index);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("indicator-multiload-graphs-", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gchar* multi_load_indicator_iconpath (MultiLoadIndicator* self, guint index) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), NULL);
	_tmp0_ = multi_load_indicator_iconname (self, index);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".png", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (self->priv->icondirectory, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static gchar* multi_load_indicator_write (MultiLoadIndicator* self, guint index) {
	gchar* result = NULL;
	guint count;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* surface;
	cairo_t* _tmp3_ = NULL;
	cairo_t* ctx;
	guint offset;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), NULL);
	count = (guint) 0;
	{
		IconData** icon_data_collection;
		int icon_data_collection_length1;
		int icon_data_it;
		icon_data_collection = self->priv->_icon_datas;
		icon_data_collection_length1 = self->priv->_icon_datas_length1;
		for (icon_data_it = 0; icon_data_it < self->priv->_icon_datas_length1; icon_data_it = icon_data_it + 1) {
			IconData* _tmp0_;
			IconData* icon_data;
			_tmp0_ = _g_object_ref0 (icon_data_collection[icon_data_it]);
			icon_data = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = icon_data_get_enabled (icon_data);
				if (_tmp1_) {
					count = count + 1;
				}
				_g_object_unref0 (icon_data);
			}
		}
	}
	self->priv->lastwidth = (guint) (((gint) (count * (self->priv->_size + 2))) - 2);
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) self->priv->lastwidth, (gint) self->priv->_height);
	surface = _tmp2_;
	_tmp3_ = cairo_create (surface);
	ctx = _tmp3_;
	cairo_set_antialias (ctx, CAIRO_ANTIALIAS_NONE);
	cairo_set_line_width (ctx, (gdouble) 1);
	offset = (guint) 0;
	{
		IconData** icon_data_collection;
		int icon_data_collection_length1;
		int icon_data_it;
		icon_data_collection = self->priv->_icon_datas;
		icon_data_collection_length1 = self->priv->_icon_datas_length1;
		for (icon_data_it = 0; icon_data_it < self->priv->_icon_datas_length1; icon_data_it = icon_data_it + 1) {
			IconData* _tmp4_;
			IconData* icon_data;
			_tmp4_ = _g_object_ref0 (icon_data_collection[icon_data_it]);
			icon_data = _tmp4_;
			{
				gboolean _tmp5_;
				IconTraceData** _tmp6_ = NULL;
				gint _tmp7_;
				gdouble* _tmp8_ = NULL;
				gdouble* values;
				gint values_length1;
				gint values_length2;
				gdouble _tmp9_;
				gdouble scale;
				_tmp5_ = icon_data_get_enabled (icon_data);
				if (!_tmp5_) {
					_g_object_unref0 (icon_data);
					continue;
				}
				icon_data_set_source_color (icon_data, ctx);
				cairo_rectangle (ctx, (gdouble) offset, (gdouble) 0, (gdouble) self->priv->_size, (gdouble) self->priv->_height);
				cairo_fill (ctx);
				_tmp6_ = icon_data_get_traces (icon_data, &_tmp7_);
				_tmp8_ = g_new0 (gdouble, _tmp7_ * self->priv->_size);
				values = _tmp8_;
				values_length1 = _tmp7_;
				values_length2 = self->priv->_size;
				_tmp9_ = icon_data_get_scale (icon_data);
				scale = _tmp9_;
				{
					guint j;
					guint jsize;
					j = (guint) 0;
					jsize = (guint) values_length1;
					{
						gboolean _tmp10_;
						_tmp10_ = TRUE;
						while (TRUE) {
							IconTraceData** _tmp11_ = NULL;
							gint _tmp12_;
							gdouble* _tmp13_ = NULL;
							gint _tmp14_;
							gdouble* trace_data;
							gint trace_data_length1;
							gint _trace_data_size_;
							if (!_tmp10_) {
								j = j + 1;
							}
							_tmp10_ = FALSE;
							if (!(j < jsize)) {
								break;
							}
							_tmp11_ = icon_data_get_traces (icon_data, &_tmp12_);
							_tmp13_ = icon_trace_data_get_values (_tmp11_[j], &_tmp14_);
							trace_data = _tmp13_;
							trace_data_length1 = _tmp14_;
							_trace_data_size_ = _tmp14_;
							{
								guint i;
								guint isize;
								i = (guint) 0;
								isize = (guint) values_length2;
								{
									gboolean _tmp15_;
									_tmp15_ = TRUE;
									while (TRUE) {
										gdouble _tmp16_ = 0.0;
										if (!_tmp15_) {
											i = i + 1;
										}
										_tmp15_ = FALSE;
										if (!(i < isize)) {
											break;
										}
										if (j > 0) {
											_tmp16_ = values[((j - 1) * values_length2) + i];
										} else {
											_tmp16_ = (gdouble) 0;
										}
										values[(j * values_length2) + i] = _tmp16_ + (trace_data[i] / scale);
									}
								}
							}
						}
					}
				}
				{
					gint j;
					j = values_length1 - 1;
					{
						gboolean _tmp17_;
						_tmp17_ = TRUE;
						while (TRUE) {
							IconTraceData** _tmp18_ = NULL;
							gint _tmp19_;
							GdkColor _tmp20_ = {0};
							if (!_tmp17_) {
								j = j - 1;
							}
							_tmp17_ = FALSE;
							if (!(j >= 0)) {
								break;
							}
							_tmp18_ = icon_data_get_traces (icon_data, &_tmp19_);
							icon_trace_data_get_color (_tmp18_[j], &_tmp20_);
							gdk_cairo_set_source_color (ctx, &_tmp20_);
							{
								guint i;
								guint isize;
								i = (guint) 0;
								isize = (guint) values_length2;
								{
									gboolean _tmp21_;
									_tmp21_ = TRUE;
									while (TRUE) {
										if (!_tmp21_) {
											i = i + 1;
										}
										_tmp21_ = FALSE;
										if (!(i < isize)) {
											break;
										}
										cairo_move_to (ctx, (0.5 + offset) + i, self->priv->_height + 0.5);
										cairo_line_to (ctx, (0.5 + offset) + i, (self->priv->_height + 0.5) - (self->priv->_height * values[(j * values_length2) + i]));
									}
								}
							}
							cairo_stroke (ctx);
						}
					}
				}
				offset = offset + (self->priv->_size + 2);
				values = (g_free (values), NULL);
				_g_object_unref0 (icon_data);
			}
		}
	}
	_tmp22_ = multi_load_indicator_iconpath (self, index);
	_tmp23_ = _tmp22_;
	cairo_surface_write_to_png (surface, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = multi_load_indicator_iconname (self, index);
	result = _tmp24_;
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (surface);
	return result;
}


guint multi_load_indicator_get_height (MultiLoadIndicator* self) {
	guint result;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), 0U);
	result = self->priv->_height;
	return result;
}


void multi_load_indicator_set_height (MultiLoadIndicator* self, guint value) {
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


guint multi_load_indicator_get_size (MultiLoadIndicator* self) {
	guint result;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), 0U);
	result = self->priv->_size;
	return result;
}


void multi_load_indicator_set_size (MultiLoadIndicator* self, guint value) {
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	self->priv->_size = value;
	{
		IconData** icon_data_collection;
		int icon_data_collection_length1;
		int icon_data_it;
		icon_data_collection = self->priv->_icon_datas;
		icon_data_collection_length1 = self->priv->_icon_datas_length1;
		for (icon_data_it = 0; icon_data_it < self->priv->_icon_datas_length1; icon_data_it = icon_data_it + 1) {
			IconData* _tmp0_;
			IconData* icon_data;
			_tmp0_ = _g_object_ref0 (icon_data_collection[icon_data_it]);
			icon_data = _tmp0_;
			{
				icon_data_set_trace_length (icon_data, value);
				_g_object_unref0 (icon_data);
			}
		}
	}
	g_object_notify ((GObject *) self, "size");
}


guint multi_load_indicator_get_speed (MultiLoadIndicator* self) {
	guint result;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), 0U);
	result = self->priv->_speed;
	return result;
}


static gpointer _icon_menu_ref0 (gpointer self) {
	return self ? icon_menu_ref (self) : NULL;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add5 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkMenuItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GtkMenuItem** _vala_array_dup8 (GtkMenuItem** self, int length) {
	GtkMenuItem** result;
	int i;
	result = g_new0 (GtkMenuItem*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


static void _lambda2_ (GtkWidget* w, MultiLoadIndicator* self) {
	guint _tmp0_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	if (!GTK_IS_IMAGE (w)) {
		return;
	}
	_tmp0_ = MAX (self->priv->lastwidth, self->priv->_height);
	gtk_image_set_pixel_size (GTK_IMAGE (w), (gint) _tmp0_);
}


static void __lambda2__gtk_callback (GtkWidget* widget, gpointer self) {
	_lambda2_ (widget, self);
}


static void _lambda1_ (GtkWindow* w, MultiLoadIndicator* self) {
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (GTK_IS_WINDOW (w));
	_tmp1_ = G_TYPE_FROM_INSTANCE (G_OBJECT (w));
	_tmp2_ = g_type_name (_tmp1_);
	if (g_strcmp0 (_tmp2_, "GtkTrayIcon") != 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !GTK_IS_CONTAINER (w);
	}
	if (_tmp0_) {
		return;
	}
	gtk_container_foreach (GTK_CONTAINER (w), __lambda2__gtk_callback, self);
}


static void __lambda1__gfunc (gconstpointer data, gpointer self) {
	_lambda1_ (data, self);
}


static gboolean _lambda0_ (MultiLoadIndicator* self) {
	gboolean result = FALSE;
	guint menu_position;
	menu_position = (guint) 0;
	{
		guint i;
		guint isize;
		i = (guint) 0;
		isize = (guint) self->priv->_icon_datas_length1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				IconMenu* _tmp1_;
				IconMenu* icon_menu;
				IconData* _tmp2_;
				IconData* icon_data;
				gchar** _tmp3_ = NULL;
				gint _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gchar** menuitems;
				gint menuitems_length1;
				gint _menuitems_size_;
				gint length;
				if (!_tmp0_) {
					i = i + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < isize)) {
					break;
				}
				_tmp1_ = _icon_menu_ref0 (self->priv->icon_menus[i]);
				icon_menu = _tmp1_;
				_tmp2_ = _g_object_ref0 (self->priv->_icon_datas[i]);
				icon_data = _tmp2_;
				icon_data_update (icon_data);
				_tmp3_ = icon_data_get_menuitems (icon_data, &_tmp4_);
				_tmp5_ = (_tmp6_ = _tmp3_, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup7 (_tmp6_, _tmp4_));
				menuitems = _tmp5_;
				menuitems_length1 = _tmp4_;
				_menuitems_size_ = _tmp4_;
				length = menuitems_length1;
				{
					guint j;
					guint jsize;
					j = (guint) 0;
					jsize = (guint) length;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							GtkMenuItem* item = NULL;
							if (!_tmp7_) {
								j = j + 1;
							}
							_tmp7_ = FALSE;
							if (!(j < jsize)) {
								break;
							}
							if (j < icon_menu->items_length1) {
								GtkMenuItem* _tmp8_;
								_tmp8_ = _g_object_ref0 (icon_menu->items[j]);
								_g_object_unref0 (item);
								item = _tmp8_;
							} else {
								GtkMenuItem* _tmp9_ = NULL;
								GtkMenu* _tmp10_ = NULL;
								GtkMenuItem* _tmp11_;
								_tmp9_ = (GtkMenuItem*) gtk_menu_item_new ();
								_g_object_unref0 (item);
								item = g_object_ref_sink (_tmp9_);
								gtk_widget_set_visible (GTK_WIDGET (item), TRUE);
								_tmp10_ = multi_load_indicator_get_menu (self);
								gtk_menu_shell_insert (GTK_MENU_SHELL (_tmp10_), GTK_WIDGET (item), (gint) menu_position);
								_tmp11_ = _g_object_ref0 (item);
								_vala_array_add5 (&icon_menu->items, &icon_menu->items_length1, &icon_menu->_items_size_, _tmp11_);
							}
							gtk_menu_item_set_label (item, menuitems[j]);
							menu_position = menu_position + 1;
							_g_object_unref0 (item);
						}
					}
				}
				if (length != icon_menu->items_length1) {
					GtkMenuItem** _tmp13_;
					GtkMenuItem** _tmp14_;
					{
						guint j;
						guint jsize;
						j = (guint) length;
						jsize = (guint) icon_menu->items_length1;
						{
							gboolean _tmp12_;
							_tmp12_ = TRUE;
							while (TRUE) {
								if (!_tmp12_) {
									j = j + 1;
								}
								_tmp12_ = FALSE;
								if (!(j < jsize)) {
									break;
								}
								gtk_widget_destroy (GTK_WIDGET (icon_menu->items[j]));
							}
						}
					}
					_tmp13_ = (_tmp14_ = icon_menu->items + 0, (_tmp14_ == NULL) ? ((gpointer) _tmp14_) : _vala_array_dup8 (_tmp14_, length - 0));
					icon_menu->items = (_vala_array_free (icon_menu->items, icon_menu->items_length1, (GDestroyNotify) g_object_unref), NULL);
					icon_menu->items = _tmp13_;
					icon_menu->items_length1 = length - 0;
					icon_menu->_items_size_ = length - 0;
				}
				menuitems = (_vala_array_free (menuitems, menuitems_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (icon_data);
				_icon_menu_unref0 (icon_menu);
			}
		}
	}
	if (self->priv->indicator != NULL) {
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GList* _tmp17_ = NULL;
		GList* _tmp18_;
		_tmp15_ = multi_load_indicator_write (self, self->priv->currenticonindex);
		_tmp16_ = _tmp15_;
		app_indicator_set_icon (self->priv->indicator, _tmp16_);
		_g_free0 (_tmp16_);
		self->priv->currenticonindex = 1 - self->priv->currenticonindex;
		_tmp17_ = gtk_window_list_toplevels ();
		_tmp18_ = _tmp17_;
		g_list_foreach (_tmp18_, __lambda1__gfunc, self);
		_g_list_free0 (_tmp18_);
	}
	result = TRUE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void multi_load_indicator_set_speed (MultiLoadIndicator* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	self->priv->_speed = value;
	if (self->priv->timeout != NULL) {
		g_source_destroy (self->priv->timeout);
	}
	_tmp0_ = multi_load_indicator_get_speed (self);
	if ((_tmp0_ % 1000) == 0) {
		guint _tmp1_;
		GSource* _tmp2_ = NULL;
		_tmp1_ = multi_load_indicator_get_speed (self);
		_tmp2_ = g_timeout_source_new_seconds (_tmp1_ / 1000);
		_g_source_unref0 (self->priv->timeout);
		self->priv->timeout = _tmp2_;
	} else {
		guint _tmp3_;
		GSource* _tmp4_ = NULL;
		_tmp3_ = multi_load_indicator_get_speed (self);
		_tmp4_ = g_timeout_source_new (_tmp3_);
		_g_source_unref0 (self->priv->timeout);
		self->priv->timeout = _tmp4_;
	}
	g_source_attach (self->priv->timeout, NULL);
	g_source_set_callback (self->priv->timeout, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_object_notify ((GObject *) self, "speed");
}


IconData** multi_load_indicator_get_icon_datas (MultiLoadIndicator* self, int* result_length1) {
	IconData** result;
	IconData** _tmp0_;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), NULL);
	_tmp0_ = self->priv->_icon_datas;
	*result_length1 = self->priv->_icon_datas_length1;
	result = _tmp0_;
	return result;
}


GtkMenu* multi_load_indicator_get_menu (MultiLoadIndicator* self) {
	GtkMenu* result;
	g_return_val_if_fail (IS_MULTI_LOAD_INDICATOR (self), NULL);
	result = self->priv->_menu;
	return result;
}


void multi_load_indicator_set_menu (MultiLoadIndicator* self, GtkMenu* value) {
	GtkMenu* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_MULTI_LOAD_INDICATOR (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_menu);
	self->priv->_menu = _tmp0_;
	if (value == NULL) {
		_g_object_unref0 (self->priv->indicator);
		self->priv->indicator = NULL;
	}
	if (value != NULL) {
		_tmp1_ = self->priv->indicator == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		AppIndicator* _tmp8_ = NULL;
		_tmp2_ = multi_load_indicator_write (self, (guint) 0);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		_tmp4_ = multi_load_indicator_write (self, (guint) 1);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_tmp6_ = multi_load_indicator_iconname (self, (guint) 0);
		_tmp7_ = _tmp6_;
		_tmp8_ = app_indicator_new_with_path ("multiload", _tmp7_, APP_INDICATOR_CATEGORY_SYSTEM_SERVICES, self->priv->icondirectory);
		_g_object_unref0 (self->priv->indicator);
		self->priv->indicator = _tmp8_;
		_g_free0 (_tmp7_);
		app_indicator_set_status (self->priv->indicator, APP_INDICATOR_STATUS_ACTIVE);
	}
	if (value != NULL) {
		app_indicator_set_menu (self->priv->indicator, value);
	}
	g_object_notify ((GObject *) self, "menu");
}


static void multi_load_indicator_class_init (MultiLoadIndicatorClass * klass) {
	multi_load_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MultiLoadIndicatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_multi_load_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_multi_load_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = multi_load_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_LOAD_INDICATOR_HEIGHT, g_param_spec_uint ("height", "height", "height", 0, G_MAXUINT, (guint) 22, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_LOAD_INDICATOR_SIZE, g_param_spec_uint ("size", "size", "size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_LOAD_INDICATOR_SPEED, g_param_spec_uint ("speed", "speed", "speed", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_LOAD_INDICATOR_MENU, g_param_spec_object ("menu", "menu", "menu", GTK_TYPE_MENU, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void multi_load_indicator_instance_init (MultiLoadIndicator * self) {
	self->priv = MULTI_LOAD_INDICATOR_GET_PRIVATE (self);
	self->priv->_height = (guint) 22;
}


static void multi_load_indicator_finalize (GObject* obj) {
	MultiLoadIndicator * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = MULTI_LOAD_INDICATOR (obj);
	_tmp0_ = multi_load_indicator_iconpath (self, (guint) 0);
	_tmp1_ = _tmp0_;
	g_remove (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = multi_load_indicator_iconpath (self, (guint) 1);
	_tmp3_ = _tmp2_;
	g_remove (_tmp3_);
	_g_free0 (_tmp3_);
	g_rmdir (self->priv->icondirectory);
	_g_free0 (self->priv->icondirectory);
	_g_source_unref0 (self->priv->timeout);
	_g_object_unref0 (self->priv->indicator);
	self->priv->icon_menus = (_vala_array_free (self->priv->icon_menus, self->priv->icon_menus_length1, (GDestroyNotify) icon_menu_unref), NULL);
	self->priv->_icon_datas = (_vala_array_free (self->priv->_icon_datas, self->priv->_icon_datas_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_menu);
	G_OBJECT_CLASS (multi_load_indicator_parent_class)->finalize (obj);
}


GType multi_load_indicator_get_type (void) {
	static volatile gsize multi_load_indicator_type_id__volatile = 0;
	if (g_once_init_enter (&multi_load_indicator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiLoadIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multi_load_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiLoadIndicator), 0, (GInstanceInitFunc) multi_load_indicator_instance_init, NULL };
		GType multi_load_indicator_type_id;
		multi_load_indicator_type_id = g_type_register_static (G_TYPE_OBJECT, "MultiLoadIndicator", &g_define_type_info, 0);
		g_once_init_leave (&multi_load_indicator_type_id__volatile, multi_load_indicator_type_id);
	}
	return multi_load_indicator_type_id__volatile;
}


static void _vala_multi_load_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MultiLoadIndicator * self;
	self = MULTI_LOAD_INDICATOR (object);
	switch (property_id) {
		case MULTI_LOAD_INDICATOR_HEIGHT:
		g_value_set_uint (value, multi_load_indicator_get_height (self));
		break;
		case MULTI_LOAD_INDICATOR_SIZE:
		g_value_set_uint (value, multi_load_indicator_get_size (self));
		break;
		case MULTI_LOAD_INDICATOR_SPEED:
		g_value_set_uint (value, multi_load_indicator_get_speed (self));
		break;
		case MULTI_LOAD_INDICATOR_MENU:
		g_value_set_object (value, multi_load_indicator_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_multi_load_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MultiLoadIndicator * self;
	self = MULTI_LOAD_INDICATOR (object);
	switch (property_id) {
		case MULTI_LOAD_INDICATOR_HEIGHT:
		multi_load_indicator_set_height (self, g_value_get_uint (value));
		break;
		case MULTI_LOAD_INDICATOR_SIZE:
		multi_load_indicator_set_size (self, g_value_get_uint (value));
		break;
		case MULTI_LOAD_INDICATOR_SPEED:
		multi_load_indicator_set_speed (self, g_value_get_uint (value));
		break;
		case MULTI_LOAD_INDICATOR_MENU:
		multi_load_indicator_set_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



