/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INDICATOR_NETWORK_SERVICE_DBUS_H_
#define _INDICATOR_NETWORK_SERVICE_DBUS_H_

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define NETWORK_SERVICE_DBUS_TYPE         (network_service_dbus_get_type ())
#define NETWORK_SERVICE_DBUS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), NETWORK_SERVICE_DBUS_TYPE, NetworkServiceDbus))
#define NETWORK_SERVICE_DBUS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), NETWORK_SERVICE_DBUS_TYPE, NetworkServiceDbusClass))
#define IS_NETWORK_SERVICE_DBUS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), NETWORK_SERVICE_DBUS_TYPE))
#define IS_NETWORK_SERVICE_DBUS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), NETWORK_SERVICE_DBUS_TYPE))
#define NETWORK_SERVICE_DBUS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), NETWORK_SERVICE_DBUS_TYPE, NetworkServiceDbusClass))


typedef struct _NetworkServiceDbus      NetworkServiceDbus;
typedef struct _NetworkServiceDbusClass NetworkServiceDbusClass;
typedef struct _NetworkData             NetworkData;

struct _NetworkData
{
  NetworkServiceDbus *service;
};

struct _NetworkServiceDbus
{
  GObject parent;
};

struct _NetworkServiceDbusClass
{
  GObjectClass parent_class;
};

GType network_service_dbus_get_type(void) G_GNUC_CONST;

void network_service_dbus_set_icon(NetworkServiceDbus* self,
				   const gchar *icon_name);
void network_service_dbus_get_icon(NetworkServiceDbus* self,
				   gchar **icon_name);
void network_service_dbus_request_scan (NetworkServiceDbus* self);
gboolean network_service_dbus_set_debug(NetworkServiceDbus* self, gint level,
					GError **error);

G_END_DECLS

#endif
