/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INDICATOR_NETWORK_SERVICE_H_
#define _INDICATOR_NETWORK_SERVICE_H_

#include <glib.h>
#include <dbus/dbus-glib-bindings.h>
#include <libnotify/notify.h>
#include <libindicator/indicator-service.h>

#include "indicator-network-service-dbus.h"

#define ICON_CONNECTED_WIRED		"nm-device-wired"
#define ICON_CONNECTED_WIFI_0		"nm-signal-0"
#define ICON_CONNECTED_WIFI_25		"nm-signal-25"
#define ICON_CONNECTED_WIFI_50		"nm-signal-50"
#define ICON_CONNECTED_WIFI_75		"nm-signal-75"
#define ICON_CONNECTED_WIFI_100		"nm-signal-100"
#define ICON_CONNECTED_WIFI		ICON_CONNECTED_WIFI_100
#define ICON_CONNECTED_CELLULAR		"nm-device-wwan"
#define ICON_CONNECTED_BLUETOOTH	ICON_CONNECTED_CELLULAR
#define ICON_CONNECTED_DEFAULT		ICON_CONNECTED_WIRED
#define ICON_DISCONNECTED		"nm-no-connection"

#define ICON_NOTIFICATION_WIFI_FULL		"notification-network-wireless-full"
#define ICON_NOTIFICATION_WIFI_DISCONNECTED	"notification-network-wireless-disconnected"
#define ICON_NOTIFICATION_WIRED_CONNECTED	"notification-network-ethernet-connected"
#define ICON_NOTIFICATION_WIRED_DISCONNECTED	"notification-network-ethernet-disconnected"
#define ICON_NOTIFICATION_CELLULAR_CONNECTED	"notification-gsm-high"
#define ICON_NOTIFICATION_CELLULAR_DISCONNECTED	"notification-gsm-disconnected"

#define CONNECTING_ICON_STAGES 3
#define CONNECTING_ICON_STATES 11
#define MAX_ICON_NAME_LEN 30

typedef enum {
  MANAGER_STATE_UNKNOWN,
  MANAGER_STATE_OFFLINE,
  MANAGER_STATE_ONLINE,
} ManagerState;

struct network_service {
  NetworkServiceDbus *ns_dbus;
  struct services *services;
  DBusGProxy *connman_proxy;
  DBusGProxy *dbus_proxy;
  DBusGProxy *agent_proxy;
  DBusGConnection *system_bus;
  DBusGConnection *session_bus;
  NotifyNotification *notification;
  guint animation_timer;
  gint animation_counter;
  gint connecting_stage;
  gint connecting_state;
  gchar *connecting_icons[CONNECTING_ICON_STAGES][CONNECTING_ICON_STATES];
  gchar *default_service_path;
  gint signal_strength;
  ManagerState manager_state;
  struct network_menu *network_menu;
};

struct service;

const gchar *network_service_icon_name(const gchar *technology, gint signal);
void network_service_notify(struct network_service *self,
			    const gchar *summary, const gchar *body,
			    const gchar *icon);
void network_service_state_changed(struct network_service *self,
				   const struct service *service);
void network_service_default_service_changed(struct network_service *self,
					     const struct service *service);
void network_service_update_service_strength(struct network_service *self,
					     const struct service *service);
void network_service_set_system_bus(struct network_service *self,
									DBusGConnection *bus);
void network_service_init(struct network_service *self);
void stop_agent(struct network_service *self);
void network_service_dispose (struct network_service *self);


#endif

