#!/usr/bin/env python

# WebframeScreenlet

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Author: Akira Ohgaki <akiraohgaki@gmail.com>

import screenlets
from screenlets.options import StringOption
import cairo
import gtk
import gtkmozembed
import sys
import os
from os import system

# use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc
class WebframeScreenlet (screenlets.Screenlet):
    """A Screenlet that browse the Web. Best for browsing of mobile sites, and using of a Web-based gadgets like Google Gadgets."""

    __name__    = 'WebframeScreenlet'
    __version__ = '20090507v.0.1'
    __author__  = 'Akira Ohgaki'
    __desc__    = __doc__

    base_dir    = sys.argv[0][:sys.argv[0].find('WebframeScreenlet.py')].strip()
    box         = False
    box         = gtk.VBox(False, 0)
    box_width   = 330
    box_height  = 370
    box_border  = 15
    moz         = False
    moz_width   = box_width - box_border * 2 #300
    moz_height  = box_height - box_border * 2 #340
    url_home    = ''
    url_search  = 'http://www.google.com/m'
    url_about   = 'http://akiraohgaki.com/goodies/widgets/webframe'

    def __init__ (self, **keyword_args):
        screenlets.Screenlet.__init__(self, width=self.box_width, height=self.box_height, uses_theme=True, is_widget=False, is_sticky=True, **keyword_args)
        self.theme_name = 'Black'
        self.add_menuitem('nav_goback', _('Back'))
        self.add_menuitem('nav_goforward', _('Forward'))
        self.add_menuitem('nav_reload', _('Reload'))
        self.add_menuitem('url_home', _('Home'))
        self.add_menuitem('url_search', _('Search'))
        self.add_menuitem('open_browser', _('View in Browser'))
        self.add_default_menuitems()
        self.add_menuitem('url_about', _('About Webframe'))
        self.add_options_group('Webframe', _('Webframe can start with your favorite Web pages.'))
        self.add_option(StringOption('Webframe', 'url_home', str(self.url_home), _('Home page'), _('Home page')), realtime=False)
        if hasattr(gtkmozembed, 'set_profile_path'):
            gtkmozembed.set_profile_path(self.base_dir, 'mozilla')
        else:
            gtkmozembed.gtk_moz_embed_set_profile_path(self.base_dir, 'mozilla')
        if self.box:
            self.box.set_border_width(self.box_border)
            #self.box.set_uposition(0, 0)
            self.box.set_size_request(self.moz_width, self.moz_height)
            self.moz = gtkmozembed.MozEmbed()
            self.moz.set_size_request(self.moz_width, self.moz_height)
            self.box.pack_start(self.moz, False, False, 0)
            self.window.add(self.box)
            self.window.show_all()
            if self.url_home:
                self.moz.load_url(self.url_home)
            else:
                self.moz.load_url(self.url_search)
            self.box = False

    def __setattr__ (self, name, value):
        screenlets.Screenlet.__setattr__(self, name, value)
        if name == 'url_home':
            self.__dict__[name] = value
            self.moz.load_url(value)
            self.redraw_canvas()

    def on_menuitem_select (self, id):
        if id == 'nav_goback':
            self.moz.go_back()
        elif id == 'nav_goforward':
            self.moz.go_forward()
        elif id == 'nav_reload':
            self.moz.reload(True)
        elif id == 'url_home':
            self.moz.load_url(self.url_home)
        elif id == 'url_search':
            self.moz.load_url(self.url_search)
        elif id == 'url_about':
            system("gnome-open '" + self.url_about + "'")
        elif id == 'open_browser':
            system("gnome-open '" + self.moz.get_location() + "'")

    def on_draw (self, ctx):
        ctx.scale(self.scale, self.scale)
        if self.theme:
            self.theme['bg.svg'].render_cairo(ctx)
        else:
            ctx.set_source_rgba(0, 0, 0, 0.7)
            ctx.rectangle(0, 0, self.box_width, self.box_height)
            ctx.fill()

    def on_draw_shape (self, ctx):
        if self.theme:
            self.on_draw(ctx)

if __name__ == '__main__':
    import screenlets.session
    screenlets.session.create_session(WebframeScreenlet)
