#!/usr/bin/env python
#; -*- coding: utf-8 -*-
# get from PidginScreenlet/ThemeParser.py

from ConfigParser import SafeConfigParser
import re

def parseBoolean(value):
    if value.__class__.__name__ == "str":
	    value = (value.lower()=="true")
    return value

class Color:
    def __init__(self, color="(0.1,0.1,0.1,0.7)"):
        if color and color != "None":
            if type(color) is tuple:
                self.color = color
            elif type(color) is str:
                try:
                    val = tuple(map(float, re.match("^\((.*)\)$", color).group(1).split(",")))
                    if type(val) is tuple and len(val) == 4:
                        self.color = val
                    else:
                        raise ValueError("Badly Formatted Color value")
                except:
                    raise ValueError("Badly Formatted Color value")
            else:
                self.color = None
					
    def get(self):
        return self.color
					
    def get_str(self):
        return "#%02X%02X%02X" % (self.color[0] * 255, self.color[1] * 255, self.color[2] * 255)

class WindowOptions:
    def __init__(self, width=180, round_style=True, radius=5,
                 shadowed=True, shadow_size=16, shadow_color=(0.1,0.1,0.1,0.9)):

        self.width, self.round_style, self.radius = width, round_style, radius
        self.shadowed, self.shadow_size = shadowed, shadow_size
        self.shadow_color = shadow_color

    def __setattr__(self, name, value):
        if name == 'shadow_color':
            self.__dict__[name] = Color(value).get()
        elif name in ('width', 'shadow_size', 'radius'):
            self.__dict__[name] = int(value)
        elif name in ('round_style', 'shadowed'):
            self.__dict__[name] = parseBoolean(value)
        else:
            self.__dict__[name] = value

class StatusOptions:
    def __init__(self, odd_line_color = (0,0,0,0.5), even_line_color = (0,0,0,0.7),
		 odd_line_hl_color = (0,0,0,0.9), even_line_hl_color = (0,0,0,0.9),
		 odd_line_hl_text_color = (1,1,1,1), even_line_hl_text_color = (1,1,1,1),
                 name_color = (1,1,1,1), text_color = (1,1,1,1),
                 enable_border = False, border_color = (0,0,0,1), border_width = 0.1):
        self.odd_line_color, self.even_line_color = odd_line_color, even_line_color
	self.odd_line_hl_color, self.even_line_hl_color = odd_line_hl_color, even_line_hl_color
        self.name_color, self.text_color = name_color, text_color
        self.enable_border, self.border_color, self.border_width = enable_border, border_color, border_width
	self.odd_line_hl_text_color = odd_line_hl_text_color
	self.even_line_hl_text_color = even_line_hl_text_color

    def __setattr__(self, name, value):
        if name in ('odd_line_color', 'even_line_color', 'name_color', 'text_color', 'border_color', 'odd_line_hl_color', 'even_line_hl_color', 'even_line_hl_text_color', 'odd_line_hl_text_color'):
            self.__dict__[name] = Color(value)
        elif name in ('border_width'):
            self.__dict__[name] = int(value)
        elif name in ('enable_border'):
            self.__dict__[name] = parseBoolean(value)
        else:
            self.__dict__[name] = value

class HeaderOptions:
    def __init__(self, title_color = (0.9,0.9,0.9,1), start_color = (0.3,0.3,0.3,1), end_color = (0.1,0.1,0.1,1), hommage_to_twitter = False):
        self.title_color, self.start_color, self.end_color  = title_color, start_color, end_color
	self.hommage_to_twitter = hommage_to_twitter
    def __setattr__(self, name, value):
        if name in ('title_color', 'start_color', 'end_color'):
            self.__dict__[name] = Color(value)
        elif name == 'hommage_to_twitter':
            self.__dict__[name] = parseBoolean(value)
        else:
            self.__dict__[name] = value

class FooterOptions:
    def __init__(self, start_color = (0.2,0.2,0.2,1), end_color = (0.1,0.1,0.1,1)):
            self.start_color, self.end_color  = start_color, end_color
    def __setattr__(self, name, value):
        if name in ('start_color', 'end_color'):
            self.__dict__[name] = Color(value)
        else:
            self.__dict__[name] = value
                        
class ThemeParser:
    def __init__(self, filename):
        
        section_dict = {"window": WindowOptions(), "status":StatusOptions(),
                        "header": HeaderOptions(), "footer":FooterOptions()}

        parser = SafeConfigParser()
        parser.read(filename)

        for section in section_dict.keys():
            obj = section_dict[section]
            self.__dict__[section] = obj
            
            if section in parser.sections():
                for option in parser.options(section):
                    obj.__setattr__(option, parser.get(section, option))                

if __name__ == "__main__":
    pass
