"""
Inguma Penetration Testing Toolkit
Copyright (c) 2006, 2007 Joxean Koret, joxeankoret [at] yahoo.es

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""
import sys
import urllib
import urllib2
import socket

VULNERABLE_PAGES = [
    "/_pages/",
    "/_pages/_demo/_ojspext/_events/_index.java",
    "/admin/",
    "/admin_/",
    "/adminoc4j",
    "/assistants/",
    "/backup_restore/",
    "/bc4j.html",
    "/BC4J/",
    "/bc4jdoc/setup.html",
    "/bmp/",
    "/bmp/global-web-application.xml",
    "/bmp/JSPClient.java",
    "/bmp/mime.types",
    "/bmp/README.txt",
    "/bmp/setconn.jsp",
    "/bmp/SqljConnBeanDemo.jsp",
    "/bmp/SqljConnBeanDemo.jsp.txt",
    "/bmp/SqljConnCacheBeanDemo.jsp ",
    "/bmp/SqljConnCacheBeanDemo.jsp.txt",
    "/bmp/SqljCursorBeanDemo.jsp",
    "/bmp/SqljCursorBeanDemo.jsp.txt",
    "/bmp/sqljdemo.jsp",
    "/bmp/SqljIterator.sqljsp",
    "/bmp/SqljIterator.sqljsp.txt",
    "/bmp/SqljSelectInto.sqljsp",
    "/bmp/SqljSelectInto.sqljsp.txt",
    "/bmp/SqljSerialize.sqljsp",
    "/bmp/SqljSerialize.sqljsp.txt",
    "/callerInfo/",
    "/callerInfo/callerInfo/",
    "/callerInfo/callerInfoA",
    "/callerInfo/callerInfoB",
    "/callerInfo/README.txt",
    "/cartx/owa",
    "/cgi-bin/",
    "/cgi-bin/printenv",
    "/cgi-bin/printenv.tmp",
    "/cgi-bin/test-cgi",
    "/config.xml",
    "/Consumer",
    "/Consumer/HotelAdmin.jsp",
    "/content/index.jspx",
    "/dav",
    "/dav_portal/portal/",
    "/dav_public",
    "/demo",
    "/demo/",
    "/demo/basic/hellouser/hellouser.jsp",
    "/demo/basic/hellouser/synopsis.htm",
    "/demo/basic/index.html",
    "/demo/basic/info/info.jsp",
    "/demo/basic/info/synopsis.htm",
    "/demo/basic/jspstore/index.jsp",
    "/demo/basic/jspstore/synopsis.htm",
    "/demo/basic/lottery/lotto.jsp",
    "/demo/basic/lottery/synopsis.htm",
    "/demo/basic/simple/index.html",
    "/demo/corba/CallCORBA.jsp",
    "/demo/corba/index.html",
    "/demo/corba/viewsrc/CallCORBA.jsp.txt",
    "/demo/corba/viewsrc/HelloCorbaWrapperBean.java.txt",
    "/demo/customtag/exampletag.jsp",
    "/demo/customtag/index.htm",
    "/demo/customtag/viewsrc/ExampleLoopTag.java.txt",
    "/demo/customtag/viewsrc/ExampleLoopTagTEI.java.txt",
    "/demo/customtag/viewsrc/exampletag.jsp.txt",
    "/demo/customtag/viewsrc/exampletag.tld.txt",
    "/demo/ejb/CallEJB.jsp",
    "/demo/ejb/index.html",
    "/demo/ejb/viewsrc/CallEJB.jsp.txt",
    "/demo/ejb/viewsrc/EmployeeEJBWrapper.java.txt",
    "/demo/ojspext/events/index.jsp",
    "/demo/ojspext/events/synopsis.htm",
    "/demo/ojspext/index.html",
    "/demo/ojspext/jmltype/index.jsp",
    "/demo/ojspext/jmltype/synopsis.htm",
    "/demo/ojspext/jspscope/scope.jsp",
    "/demo/ojspext/jspscope/synopsis.htm",
    "/demo/sql/bean/ConnBeanDemo.jsp",
    "/demo/sql/bean/ConnCacheBeanDemo.jsp",
    "/demo/sql/bean/CursorBeanDemo.jsp",
    "/demo/sql/bean/DBBeanDemo.jsp",
    "/demo/sql/bean/viewsrc/ConnBeanDemo.jsp.txt",
    "/demo/sql/bean/viewsrc/ConnCacheBeanDemo.jsp.txt",
    "/demo/sql/bean/viewsrc/CursorBeanDemo.jsp.txt",
    "/demo/sql/bean/viewsrc/DBBeanDemo.jsp.txt",
    "/demo/sql/index.jsp",
    "/demo/sql/jdbc/ConnCache1.jsp",
    "/demo/sql/jdbc/ConnCache2.jsp",
    "/demo/sql/jdbc/ConnCache3.jsp",
    "/demo/sql/jdbc/JDBCQuery.jsp",
    "/demo/sql/jdbc/SimpleQuery.jsp",
    "/demo/sql/jdbc/UseHtmlQueryBean.jsp",
    "/demo/sql/jdbc/viewsrc/ConnCache1.jsp.txt",
    "/demo/sql/jdbc/viewsrc/ConnCache2.jsp.txt",
    "/demo/sql/jdbc/viewsrc/ConnCache3.jsp.txt",
    "/demo/sql/jdbc/viewsrc/JDBCQuery.jsp.txt",
    "/demo/sql/jdbc/viewsrc/setupcache.jsp.txt",
    "/demo/sql/jdbc/viewsrc/SimpleQuery.jsp.txt",
    "/demo/sql/jdbc/viewsrc/UseHtmlQueryBean.jsp.txt",
    "/demo/sql/sqlj/SQLJIterator.sqljsp",
    "/demo/sql/sqlj/SQLJSelectInto.sqljsp",
    "/demo/sql/sqlj/viewsrc/SQLJIterator.sqljsp.txt",
    "/demo/sql/sqlj/viewsrc/SQLJSelectInto.sqljsp.txt",
    "/demo/sql/tag/sample1.jsp",
    "/demo/sql/tag/sample2.jsp",
    "/demo/sql/tag/sample3.jsp",
    "/demo/sql/tag/sample4.jsp",
    "/demo/sql/tag/sample5.jsp",
    "/demo/sql/tag/taglib.html",
    "/demo/sql/tag/viewsrc/index.html",
    "/demo/sql/tag/viewsrc/sample1.jsp.txt",
    "/demo/sql/tag/viewsrc/sample2.jsp.txt",
    "/demo/sql/tag/viewsrc/sample4.jsp.txt",
    "/demo/sql/tag/viewsrc/sample5.jsp.txt",
    "/demo/xml/helloxml/hello.jsp",
    "/demo/xml/helloxml/index.html",
    "/demo/xml/index.html",
    "/demo/xml/xmlquery/index.html",
    "/demo/xml/xmlquery/XMLQuery.jsp",
    "/diagnostics/",
    "/dms/AggreSpy",
    "/dms/DMSDump",
    "/dms0",
    "/dsa/",
    "/em",
    "/em/dynamicImage/emSDK/chart/EmChartBean",
    "/em/dynamicImage/emSDK/chart/EmChartBean?beanId=\..\..\..\..\..\..\..\..\..\..\..\..\test.txt",
    "/FAQApp",
    "/fastcgi/",
    "/fcgi-bin/",
    "/fcgi-bin/echo",
    "/fcgi-bin/echo.exe",
    "/fcgi-bin/echo2",
    "/fcgi-bin/echo2.exe",
    "/fcgi-bin/printenv",
    "/file.xsql?name=foobar",
    "/g11n/imap.html",
    "/g11n/suppA/html/frame.html",
    "/g11n/suppA/jsp/newBook.jsp",
    "/g11n/suppB/html/frame.html",
    "/g11n/suppB/jsp/newBook.jsp",
    "/g11n/wob/jsp/welcome.jsp",
    "/has/",
    "/hdemo",
    "/help/index.htm",
    "/HotelService",
    "/iaspt/",
    "/install.platform/",
    "/install/",
    "/inventory/",
    "/isqlplus",
    "/j2ee/examples/jsp/",
    "/j2ee/examples/jsp/cal/calendar.html",
    "/j2ee/examples/jsp/cal/login.html",
    "/j2ee/examples/jsp/checkbox/check.html",
    "/j2ee/examples/jsp/checkbox/cresult.html",
    "/j2ee/examples/jsp/colors/clr.html",
    "/j2ee/examples/jsp/colors/colors.html",
    "/j2ee/examples/jsp/colors/cresult.html",
    "/j2ee/examples/jsp/dates/date.html",
    "/j2ee/examples/jsp/dates/date.jsp",
    "/j2ee/examples/jsp/error/er.html",
    "/j2ee/examples/jsp/error/error.html",
    "/j2ee/examples/jsp/forward/forward.jsp",
    "/j2ee/examples/jsp/forward/fwd.html",
    "/j2ee/examples/jsp/include/inc.html",
    "/j2ee/examples/jsp/jsptoserv/jsptoservlet.jsp",
    "/j2ee/examples/jsp/jsptoserv/jts.html",
    "/j2ee/examples/jsp/num/numguess.html",
    "/j2ee/examples/jsp/num/numguess.jsp",
    "/j2ee/examples/jsp/plugin/plugin.html",
    "/j2ee/examples/jsp/plugin/plugin.jsp",
    "/j2ee/examples/jsp/sessions/carts.html",
    "/j2ee/examples/jsp/sessions/crt.html",
    "/j2ee/examples/jsp/snp/snoop.html",
    "/j2ee/examples/jsp/snp/snoop.jsp",
    "/j2ee/examples/servlets/cookies.html",
    "/j2ee/examples/servlets/helloworld.html",
    "/j2ee/examples/servlets/index.html ",
    "/j2ee/examples/servlets/reqheaders.html",
    "/j2ee/examples/servlets/reqinfo.html",
    "/j2ee/examples/servlets/reqparams.html",
    "/j2ee/examples/servlets/sessions.html",
    "/j2ee/examples/servlets/snoop.txt",
    "/j2ee/examples/servlets/tojsp.html",
    "/j2ee/OC4J_Demos",
    "/j2ee/oc4jfeatures.html",
    "/j2ee/servlet/CookieExample",
    "/j2ee/servlet/HelloWorldExample",
    "/j2ee/servlet/RequestHeaderExample",
    "/j2ee/servlet/RequestInfoExample",
    "/j2ee/servlet/RequestParamExample",
    "/j2ee/servlet/SessionExample",
    "/j2ee/servlet/SnoopServlet",
    "/j2ee/servlet/ToJSPServlet",
    "/javacache/",
    "/javavm/",
    "/jdbc/",
    "/jmsws1",
    "/jmsws2",
    "/jocdemo/servlet/IsCacheWorking ",
    "/jre/",
    "/jserv/status?module=127.0.0.1",
    "/jsp/",
    "/lbs/",
    "/ldap/",
    "/mesg/",
    "/myapp",
    "/mydad",
    "/nls/",
    "/ojspdemos/",
    "/ojspdemos/basic/hellouser/hellouser.jsp",
    "/ojspdemos/basic/hellouser/hellouser_jml.jsp",
    "/ojspdemos/basic/hellouser/synopsis.htm",
    "/ojspdemos/basic/index.html",
    "/ojspdemos/basic/info/info.jsp",
    "/ojspdemos/basic/info/synopsis.htm",
    "/ojspdemos/basic/jspstore/basic/addtobkt.gif",
    "/ojspdemos/basic/jspstore/basic/bg.gif",
    "/ojspdemos/basic/jspstore/basic/shop_again.gif",
    "/ojspdemos/basic/jspstore/index.jsp",
    "/ojspdemos/basic/jspstore/synopsis.htm",
    "/ojspdemos/basic/lottery/lotto.jsp",
    "/ojspdemos/basic/lottery/lotto.jsp ",
    "/ojspdemos/basic/lottery/synopsis.htm",
    "/ojspdemos/basic/simple/index.html",
    "/ojspdemos/basic/simple/usebean.jsp",
    "/ojspdemos/basic/simple/welcome.jsp",
    "/ojspdemos/basic/simple/welcomeuser.jsp",
    "/ojspdemos/cache/codenotes.html",
    "/ojspdemos/cache/data_in_html_and_email.jsp",
    "/ojspdemos/cache/ecSynopsis.html",
    "/ojspdemos/cache/fs/added.jsp",
    "/ojspdemos/cache/fs/additem.html",
    "/ojspdemos/cache/fs/fsSynopsis.html",
    "/ojspdemos/cache/index.html",
    "/ojspdemos/cache/objcache/objcache.jsp?testing4=101",
    "/ojspdemos/cache/objcache/synopsis.html",
    "/ojspdemos/cache/ocs/additem.html",
    "/ojspdemos/cache/ocs/ocsSynopsis.html",
    "/ojspdemos/cache/servletcode.jsp",
    "/ojspdemos/cache/servletSynopsis.html",
    "/ojspdemos/cache/setup.html",
    "/ojspdemos/cache/tagcode.jsp",
    "/ojspdemos/cache/xmldomcache.html",
    "/ojspdemos/cache/xmldomcache.jsp",
    "/ojspdemos/customtag/basic.html",
    "/ojspdemos/customtag/index.html",
    "/ojspdemos/customtag/looptag.html",
    "/ojspdemos/customtag/xmlview.html",
    "/ojspdemos/ejbtags/index.html",
    "/ojspdemos/ejbtags/iterate.jsp",
    "/ojspdemos/ejbtags/usebean.jsp",
    "/ojspdemos/ejbtags/usebeanlocal.jsp",
    "/ojspdemos/email/index.html",
    "/ojspdemos/email/sendmail.jsp",
    "/ojspdemos/fileaccess/beanDownloadExample.jsp",
    "/ojspdemos/fileaccess/beanUploadExample.jsp",
    "/ojspdemos/fileaccess/dbBeanDownloadExample.jsp",
    "/ojspdemos/fileaccess/dbDownloadIndx.html",
    "/ojspdemos/fileaccess/dbTagDownloadExample.jsp",
    "/ojspdemos/fileaccess/dbTagUploadExample.jsp",
    "/ojspdemos/fileaccess/dbUploadIndex.html",
    "/ojspdemos/fileaccess/fileDownloadIndex.html",
    "/ojspdemos/fileaccess/fileindex.html",
    "/ojspdemos/fileaccess/fileUploadIndex.html",
    "/ojspdemos/fileaccess/index.html",
    "/ojspdemos/fileaccess/maxfiles.jsp?action=uploadForm.html",
    "/ojspdemos/fileaccess/maxfiles.jsp?action=uploadForm.jsp&nextaction=dbBeanUploadExample.jsp",
    "/ojspdemos/fileaccess/maxfiles.jsp?action=uploadForm.jsp&nextaction=dbTagUploadExample.jsp",
    "/ojspdemos/fileaccess/maxfiles.jsp?action=uploadForm.jsp&nextaction=tagUploadExample.jsp",
    "/ojspdemos/fileaccess/tagDownloadExample.jsp",
    "/ojspdemos/fileaccess/tagUploadExample.jsp",
    "/ojspdemos/fileaccess/uploadForm.html?nextaction=null&MaxFiles=1&Submit=OK",
    "/ojspdemos/fileaccess/uploadForm.jsp?nextaction=dbBeanUploadExample.jsp&MaxFiles=1&Submit=OK",
    "/ojspdemos/fileaccess/uploadForm.jsp?nextaction=dbTagUploadExample.jsp&MaxFiles=5&Submit=OK",
    "/ojspdemos/fileaccess/uploadForm.jsp?nextaction=tagUploadExample.jsp&MaxFiles=1&Submit=OK",
    "/ojspdemos/iterate/index.html",
    "/ojspdemos/iterate/iterateSample.jsp",
    "/ojspdemos/jesi/fragment.jsp",
    "/ojspdemos/jesi/include.jsp",
    "/ojspdemos/jesi/index.html",
    "/ojspdemos/jesi/invalidation.jsp",
    "/ojspdemos/jesi/invalidation2.jsp",
    "/ojspdemos/jesi/personalize.jsp",
    "/ojspdemos/jesi/setup.html",
    "/ojspdemos/jspdynamicws/dynamicws.jsp",
    "/ojspdemos/jspdynamicws/index.html",
    "/ojspdemos/jspdynamicws/index.html ",
    "/ojspdemos/jspwsdemo/index.html",
    "/ojspdemos/jspwsdemo/Readme.html",
    "/ojspdemos/jspwsdemo/wsclient.jsp",
    "/ojspdemos/jspxmlview/index.html",
    "/ojspdemos/jspxmlview/lottoXml.jsp",
    "/ojspdemos/jstl_instructions.html",
    "/ojspdemos/misc/index.html",
    "/ojspdemos/misc/jsptld_11_2_12.xsl",
    "/ojspdemos/ojspext/index.html",
    "/ojspdemos/ojspext/jmltype/index.jsp",
    "/ojspdemos/ojspext/jmltype/synopsis.htm",
    "/ojspdemos/ojspext/jspscope/scope.jsp",
    "/ojspdemos/ojspext/jspscope/synopsis.htm",
    "/ojspdemos/oracle-standard.ear",
    "/ojspdemos/personalization/index.html",
    "/ojspdemos/personalization/recommend.jsp",
    "/ojspdemos/personalization/record.jsp",
    "/ojspdemos/personalization/setup.html",
    "/ojspdemos/personalization/stateless.jsp",
    "/ojspdemos/personalization/tagdemodriver.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/hellouser/hellouser.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/hellouser/hellouser_jml.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/info/info.jsp ",
    "/ojspdemos/servlet/ViewSrc/basic/jspstore/cart.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/jspstore/index.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/lottery/lotto.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/simple/usebean.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/simple/welcome.jsp",
    "/ojspdemos/servlet/ViewSrc/basic/simple/welcomeuser.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/fs/added.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/fs/listitem.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/fs/seeitems.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/objcache/objcache.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/ocs/added.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/ocs/listitem.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/ocs/seeitems.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/servletcode.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/tagcode.jsp",
    "/ojspdemos/servlet/ViewSrc/cache/xmldomcache.jsp",
    "/ojspdemos/servlet/ViewSrc/demoUtil.jsp",
    "/ojspdemos/servlet/ViewSrc/ejbtags/iterate.jsp",
    "/ojspdemos/servlet/ViewSrc/ejbtags/usebean.jsp",
    "/ojspdemos/servlet/ViewSrc/ejbtags/usebeanlocal.jsp",
    "/ojspdemos/servlet/ViewSrc/email/sendmail.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/beanDownloadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/beanDownloadExample.jsp ",
    "/ojspdemos/servlet/ViewSrc/fileaccess/beanUploadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/dbBeanDownloadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/dbBeanUploadExample.jsp ",
    "/ojspdemos/servlet/ViewSrc/fileaccess/dbTagDownloadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/dbTagUploadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/maxfiles.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/tagDownloadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/tagUploadExample.jsp",
    "/ojspdemos/servlet/ViewSrc/fileaccess/uploadForm.html",
    "/ojspdemos/servlet/ViewSrc/fileaccess/uploadForm.jsp",
    "/ojspdemos/servlet/ViewSrc/iterate/iterateSample.jsp",
    "/ojspdemos/servlet/ViewSrc/jesi/fragment.jsp",
    "/ojspdemos/servlet/ViewSrc/jesi/include.jsp",
    "/ojspdemos/servlet/ViewSrc/jesi/invalidation.jsp",
    "/ojspdemos/servlet/ViewSrc/jesi/invalidation2.jsp",
    "/ojspdemos/servlet/ViewSrc/jesi/personalize.jsp",
    "/ojspdemos/servlet/ViewSrc/jspdynamicws/dynamicws.jsp",
    "/ojspdemos/servlet/ViewSrc/jspwsdemo/wsclient.jsp",
    "/ojspdemos/servlet/ViewSrc/jspxmlview/lottoXml.jsp",
    "/ojspdemos/servlet/ViewSrc/ojspext/jmltype/index.jsp",
    "/ojspdemos/servlet/ViewSrc/ojspext/jspscope/scope.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/endsession.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/evaluateitem.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/getcrosssellrecommendations.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/getrecsasnext.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/getrecsinlist.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/recommend.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/record.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/recorddemographic.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/recordnavigation.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/recordpurchase.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/recordrating.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/removedemographicrecord.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/removenavigationrecord.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/removepurchaserecord.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/removeratingrecord.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/selectfromhpasnext.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/selectfromhpinlist.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/setvisitortocustomer.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/stateless.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/stateless_close.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/stateless_get.jsp",
    "/ojspdemos/servlet/ViewSrc/personalization/tagdemodriver.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/bean/ConnBeanDemo.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/bean/ConnCacheBeanDemo.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/bean/CursorBeanDemo.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/bean/DBBeanDemo.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/ConnCache1.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/ConnCache2.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/JDBCQuery.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/setupcache.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/SimpleQuery.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/jdbc/UseHtmlQueryBean.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/sqlj/SQLJIterator.sqljsp",
    "/ojspdemos/servlet/ViewSrc/sql/sqlj/SQLJSelectInto.sqljsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample1.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample10.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample11.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample2.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample3.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample4.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample5.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample6.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample7.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample8.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/sample9.jsp",
    "/ojspdemos/servlet/ViewSrc/sql/tag/style/rowset.xsl",
    "/ojspdemos/servlet/ViewSrc/src/caTraffic/bean/CATrafficServiceProxy.java",
    "/ojspdemos/servlet/ViewSrc/src/caTraffic/bean/CATrafficServiceProxy.java ",
    "/ojspdemos/servlet/ViewSrc/src/demoPkg/DemoCacheServlet.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoEntity.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoEntityEJB.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoEntityHome.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSession.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSessionEJB.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSessionHome.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSessionLocal.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSessionLocalEJB.java",
    "/ojspdemos/servlet/ViewSrc/src/ejbdemo/DemoSessionLocalHome.java",
    "/ojspdemos/servlet/ViewSrc/src/examples/ExampleLoopTag.java",
    "/ojspdemos/servlet/ViewSrc/src/examples/ExampleLoopTagTEI.java",
    "/ojspdemos/servlet/ViewSrc/src/examples/RStrArray.java",
    "/ojspdemos/servlet/ViewSrc/src/examples/StrArray.java",
    "/ojspdemos/servlet/ViewSrc/src/examples/WStrArray.java",
    "/ojspdemos/servlet/ViewSrc/src/exampletag.tld",
    "/ojspdemos/servlet/ViewSrc/src/oracle/j2ee/ws/client/impl/WSClientBean.java",
    "/ojspdemos/servlet/ViewSrc/src/Oracle/j2ee/ws/client/impl/WSClientBean.java ",
    "/ojspdemos/servlet/ViewSrc/src/Oracle/jsp/sample/event/PageEventDispatcher.java",
    "/ojspdemos/servlet/ViewSrc/src/oracle/taglib/IterateTag.java",
    "/ojspdemos/servlet/ViewSrc/src/test-policy.cpd",
    "/ojspdemos/servlet/ViewSrc/trafficCA/CATraffic.jsp",
    "/ojspdemos/servlet/ViewSrc/WEB-INF/iteratetag.tld",
    "/ojspdemos/servlet/ViewSrc/wstags/desc.html",
    "/ojspdemos/servlet/ViewSrc/wstags/dynamicws.jsp",
    "/ojspdemos/servlet/ViewSrc/xml/helloxml/hello.jsp",
    "/ojspdemos/servlet/ViewSrc/xml/helloxml/style/hello.xsl",
    "/ojspdemos/servlet/ViewSrc/xml/xmldom/xmldom.jsp",
    "/ojspdemos/servlet/ViewSrc/xml/xmlquery/XMLQuery.jsp",
    "/ojspdemos/setup.html",
    "/ojspdemos/sql/bean/ConnBeanDemo.jsp",
    "/ojspdemos/sql/bean/ConnCacheBeanDemo.jsp",
    "/ojspdemos/sql/bean/CursorBeanDemo.jsp",
    "/ojspdemos/sql/bean/DBBeanDemo.jsp",
    "/ojspdemos/sql/bean/index.html",
    "/ojspdemos/sql/index.jsp",
    "/ojspdemos/sql/jdbc/ConnCache1.jsp",
    "/ojspdemos/sql/jdbc/ConnCache2.jsp",
    "/ojspdemos/sql/jdbc/index.html",
    "/ojspdemos/sql/jdbc/JDBCQuery.jsp",
    "/ojspdemos/sql/jdbc/SimpleQuery.jsp",
    "/ojspdemos/sql/jdbc/UseHtmlQueryBean.jsp",
    "/ojspdemos/sql/sqlj/index.html",
    "/ojspdemos/sql/sqlj/SQLJIterator.sqljsp",
    "/ojspdemos/sql/sqlj/SQLJSelectInto.sqljsp",
    "/ojspdemos/sql/tag/index.html",
    "/ojspdemos/sql/tag/indx3.html",
    "/ojspdemos/sql/tag/sample1.jsp",
    "/ojspdemos/sql/tag/sample10.jsp",
    "/ojspdemos/sql/tag/sample11.jsp",
    "/ojspdemos/sql/tag/sample2.jsp",
    "/ojspdemos/sql/tag/sample3.jsp",
    "/ojspdemos/sql/tag/sample4.jsp",
    "/ojspdemos/sql/tag/sample5.jsp",
    "/ojspdemos/sql/tag/sample6.jsp",
    "/ojspdemos/sql/tag/sample7.jsp",
    "/ojspdemos/sql/tag/sample8.jsp",
    "/ojspdemos/sql/tag/sample9.jsp",
    "/ojspdemos/sql/tag/taglib.html",
    "/ojspdemos/trafficCA/CATraffic.jsp",
    "/ojspdemos/trafficCA/index.html",
    "/ojspdemos/wstags/dynamicws.jsp",
    "/ojspdemos/wstags/index.html",
    "/ojspdemos/xml/helloxml/hello.jsp",
    "/ojspdemos/xml/helloxml/index.html",
    "/ojspdemos/xml/index.html",
    "/ojspdemos/xml/xmldom/index.html",
    "/ojspdemos/xml/xmldom/xmldom.jsp",
    "/ojspdemos/xml/xmlquery/index.html",
    "/ojspdemos/xml/xmlquery/XMLQuery.jsp",
    "/ojspdemos/xss.html",
    "/onlineorders/main.jsp",
    "/onlineorders/signon.jsp",
    "/oprocmgr-service",
    "/oprocmgr-status",
    "/orasso",
    "/ord/",
    "/oui/",
    "/owa_util.cellsprint?p_theQuery=select",
    "/owa_util.listprint?p_theQuery=select",
    "/owa_util.show_query_columns?ctable=sys.dba_users",
    "/owa_util.showsoucre?cname=books",
    "/owm/",
    "/ows-bin/",
    "/ows-bin/simpledad/sample.home",
    "/perl/",
    "/perl/printenv",
    "/perl-status",
    "/pls/admin_/gateway.htm",
    "/pls/admin_/globalsettings.htm",
    "/pls/banking/account.welcome",
    "/pls/bookstore/books.search?cname=War+and+Peace",
    "/pls/cartx/owa",
    "/pls/cartx/owa/admin_/",
    "/pls/myapp",
    "/pls/myapp/admin_/",
    "/pls/mydad ",
    "/pls/mydad/admin_/ ",
    "/pls/orasso",
    "/pls/orasso/admin_/",
    "/pls/plsqlapp",
    "/pls/plsqlapp/admin_/",
    "/pls/portal",
    "/pls/portal/admin_/",
    "/pls/portal/null",
    "/pls/portal/\"SYS\".owa_util.cellsprint?p_theQuery=select",
    "/pls/portal/\"SYS\".owa_util.listprint?p_theQuery=select",
    "/pls/portal/\"SYS\".owa_util.show_query_columns?ctable=sys.dba_users",
    "/pls/portal/\"SYS\".owa_util.showsoucre?cname=books",
    "/pls/portal/\"SYS\".owa_util.signature",
    "/pls/portal/owa_util.cellsprint?p_theQuery=select",
    "/pls/portal/owa_util.listprint?p_theQuery=select",
    "/pls/portal/owa_util.show_query_columns?ctable=sys.dba_users",
    "/pls/portal/owa_util.showsoucre?cname=books",
    "/pls/portal/owa_util.signature",
    "/pls/portal30",
    "/pls/portal30/admin_/",
    "/pls/portal30_sso",
    "/pls/portal30_sso/admin_/",
    "/pls/portal306",
    "/pls/portal306/admin_/",
    "/pls/portal309",
    "/pls/portal309/admin_/",
    "/pls/qa",
    "/pls/qa/admin_/",
    "/pls/real",
    "/pls/real/admin_/",
    "/pls/register/account.welcome",
    "/pls/register/reg.signup",
    "/pls/sample",
    "/pls/sample/admin_/",
    "/pls/simpledad",
    "/pls/simpledad/admin_/",
    "/pls/ssodad",
    "/pls/ssodad/admin_/",
    "/pls/test",
    "/pls/test/admin_/",
    "/plsql/",
    "/plsqlapp",
    "/portal",
    "/portal/page",
    "/portal/page?_pageid=6,1,6_13&_dad=portal&_schema=PORTAL",
    "/portal30",
    "/portal30_sso",
    "/portal306",
    "/portal309",
    "/precomp/",
    "/ptg_upgrade_pkg.log",
    "/qa",
    "/rdbms/",
    "/real",
    "/recomp_exit.dyn",
    "/relnotes",
    "/reports/examples/Tools/test.jsp",
    "/reports/examples/Tools/test.jsp?repprod\"<script>alert( document.cookie );</script>",
    "/reports/examples/Tools/test.jsp?repprod&desname='<script>alert( document.cookie );</script>",
    "/root.sh",
    "/sample",
    "/sejb_webservices",
    "/sejb_webservices/HelloService?proxy_jar",
    "/sejb_webservices/HelloService?WSDL",
    "/server-info",
    "/server-status",
    "/servlet",
    "/servlet/DMSDump",
    "/servlet/IsCacheWorking",
    "/servlet/IsItWorking/",
    "/servlet/oracle.xml.xsql.XSQLServlet/soapdocs/webapps/soap/WEB-INF/config/soapConfig.xml",
    "/servlet/Oracle.xml.xsql.XSQLServlet/xsql/lib/XSQLConfig.xml",
    "/servlet/Spy",
    "/simpledad",
    "/slax/",
    "/soap/",
    "/soap/servlet/soaprouter",
    "/soap/servlet/Spy",
    "/soapbuilder/",
    "/soapbuilder/r2/InteropTest",
    "/soapdocs/webapps/soap/WEB-INF/config/soapConfig.xml",
    "/sqlj/",
    "/sqlnet.log",
    "/sqlplus/",
    "/srvm/",
    "/sso/",
    "/ssodad",
    "/statefuldocws",
    "/statelessdocws",
    "/syndication/",
    "/sysman/",
    "/test",
    "/uddi/",
    "/uix/",
    "/ultrasearch/",
    "/upgrade/",
    "/wcs/",
    "/web_services",
    "/webapp/",
    "/webapp/jsp/",
    "/webapp/jsp/calendar.jsp",
    "/webapp/jsp/container_tabs.jsp",
    "/webcache/",
    "/webcalendar/",
    "/webservices/",
    "/webservices/beanTest?proxy_jar",
    "/webservices/beanTest?wsdl",
    "/webservices/statefulTest?proxy_jar",
    "/webservices/statefulTest?wsdl",
    "/webservices/statelessTest?proxy_jar",
    "/webservices/statelessTest?wsdl",
    "/webservices1/",
    "/webservices1/javacallin?invoke=to_string",
    "/webservices1/sqlstatement?getEmpBySalBeans&param0=500",
    "/wireless/",
    "/xdk/",
    "/xsql/java/xsql/demo/adhocsql/query.xsql?xml-stylesheet=none.xsl&sql=select+*+from+sys.dba_users",
    "/xsql/lib/XSQLConfig.xml",
    "/tictactoe",
    "/forms/frmservlet?form=test.fmx",
    "/forms90/f90servlet?form=test.fmx",
    "/dev60cgi/f60cgi?form=test.fmx",
    "/pls/admin_/help/..%255Cplsql.conf",
    "/webcacheadmin?SCREEN_ID=CGA.CacheDump&ACTION=Submit&index=1&cache_dump_file=log.txt"
    ]

COMMON_DADS = [
    "/pls/portal30/",
    "/pls/portal/",
    "/pls/orasso/",
    "/pls/prod/"
    ]

COMMON_METHODS = [
    '"SYS".owa_util.signature',
    '<<a>>owa_util.signature',
    '"S\xFFS".owa_util.signature',
    '%0dsys.owa_util.signature',
    '%0asys.owa_util.signature',
    '%08sys.owa_util.signature'
    ]

def tryDadMethod(base, dad, method):
    res = None

    try:
        data = urllib.urlopen(base + dad + urllib.quote(method)).read()

        if data.lower().find("pl/sql") > -1:
            return True
        else:
            return False

    except KeyboardInterrupt:
        print "Aborted."
        raise
    except:
        print "Exception:", sys.exc_info()[0], sys.exc_info()[1]
        raise

def getVulnerableDad(target, port, timeout, ssl, returnType = 0, dad = None):

    socket.setdefaulttimeout(timeout)

    if ssl == True:
        baseUrl = "https://" + target + ":" + str(port)
    else:
        baseUrl = "http://" + target + ":" + str(port)

    if dad != None:
        dadList = [dad,]
    else:
        dadList = COMMON_DADS

    for element in dadList:
        for method in COMMON_METHODS:
            if tryDadMethod(baseUrl, element, method):
                if returnType == 0: # Return the relative URL
                    return baseUrl + element + method.replace(".signature", "")
                else:
                    return element, method.replace(".signature", "")

    return False

