/***************************************************************************
                         ac3dfile.h  -  description
                            -------------------
   begin                : Sun Aug 20 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AC3DFILE_H
#define AC3DFILE_H

#include <Plugins/fileplugin.h>

/**
  *@author Jon Anderson
  */

class AC3DFile : public FilePlugin
{
   public:
      AC3DFile();
      ~AC3DFile();

      void importData( ifstream & );
      void exportData( ofstream & );

   protected:
      void getToken( char *, ifstream & );

      void readMaterial( ifstream & );
      void writeMaterials( ofstream & );

      void readObject( ifstream & );
      void readObjectName( Object *, ifstream & );
      void readObjectData( Object *, ifstream & );
      void readObjectTexture( Object *, ifstream & );
      void readObjectTextureRep( Object *, ifstream & );
      void readObjectTextureOff( Object *, ifstream & );
      void readObjectRotation( Object *, ifstream & );
      void readObjectLocation( Object *, ifstream & );
      void readObjectURL( Object *, ifstream & );
      void readObjectVerts( Object *, ifstream & );
      void readObjectSurfaces( Object *, ifstream & );
      void readObjectKids( Object *, ifstream & );
      void readObjectSurfaceRefs( Object *o, ifstream &in );

      void writeObject( Object *, ofstream & );
      void writeObjectVerts( Object *, ofstream & );
      void writeObjectSurfaces( Object *, ofstream & );
      void writeObjectSurfaceRefs( Face *, ofstream & );
      void writeObjectLocation( Object *, ofstream & );
      void writeObjectRotation( Object *, ofstream & );
      void writeObjectTexture( Object *, ofstream & );
      void writeObjectTextureRep( Object *, ofstream & );
      void writeObjectKids( Object *, ofstream & );
      void writeObjectName( Object *, ofstream & );
      void writeObjectData( Object *, ofstream & );
      void writeObjectURL( Object *, ofstream & );

      float m_texOffsetU;
      float m_texOffsetV;
      float m_texRepeatU;
      float m_texRepeatV;


};

#endif
