/***************************************************************************
                         csf.cpp  -  description
                            -------------------
   begin                : Sat Jan 25, 2002
   copyright            : (C) 2000 by Jon Anderson
   email                : janders@users.sf.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csf.h"
#include <vector>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
   FilePlugin * i3d_createInstance()
   {
      return new CSF();
   }
}

CSF::CSF() : FilePlugin( "Cal3D Skeleton", "csf" )
{
   setImportable( true );
   setExportable( true );

   setBinary( true );

}

CSF::~CSF()
{}

void CSF::importData( ifstream &in )
{
	csf_file file;
	
	//read in the header.
  in.read( &file.header, sizeof(csf_header) );

  file.bones = new csf_bone[file.header.num_bones];
	float tmp;
	
  for(int i=0; i< file.header.num_bones; i++ )
  {
		in.read( &file.bones[i].name_length, sizeof(int));
    file.bones[i].name = new char[file.bones[i].name_length];
    in.read( file.bones[i].name, sizeof(char)*file.bones[i].name_length );
    in.read( &file.bones[i].info, sizeof(csf_bone_info) );

    file.bones[i].children = new int[file.bones[i].info.num_children];

    in.read( file.bones[i].children, sizeof(int)*file.bones[i].info.num_children );
  }

  //successfully read in the bones
	printFile( file );
	convertBones( file );

}

void CSF::printFile( csf_file &file )
{
  printf( "Header - \n" );
  printf( "\t%s-%d.\n", file.header.token, file.header.file_version );
  printf( "\tNumber of Bones : %d\n", file.header.num_bones );

  for(int i=0; i<file.header.num_bones; i++ )
  {
		printf( "Bone : %d\n", i );
    printf( "\tName '%s'\n", file.bones[i].name );
    printf( "\tTrans : %f,%f,%f\n", file.bones[i].info.trans_x, file.bones[i].info.trans_y, file.bones[i].info.trans_z  );
		printf( "\tLTrans : %f,%f,%f\n", file.bones[i].info.ltrans_x, file.bones[i].info.ltrans_y, file.bones[i].info.ltrans_z  );
		printf( "\tRot: %f,%f,%f,%f\n", file.bones[i].info.rot_x, file.bones[i].info.rot_y, file.bones[i].info.rot_z, file.bones[i].info.rot_w );
		printf( "\tLRot: %f,%f,%f,%f\n", file.bones[i].info.lrot_x, file.bones[i].info.lrot_y, file.bones[i].info.lrot_z, file.bones[i].info.lrot_w );
		printf( "\tParent Id: %d\n", file.bones[i].info.parent_id );
    printf( "\tNumber of Children: %d\n", file.bones[i].info.num_children );
		printf( "\t\t" );

    for(int j=0; j<file.bones[i].info.num_children; j++ )
    {
			printf("%d, ", file.bones[i].children[j] );
    }

    printf( "\n" );
  }

}
			
void CSF::convertBones( csf_file & file )
{
	Bone *i3d_bones[ file.header.num_bones ];
	
	for(int i=0; i<file.header.num_bones; i++ )
	{
		i3d_bones[i] = new Bone( 0, 1 );
		Quat q( file.bones[i].info.rot_x,
					  file.bones[i].info.rot_y,
					  file.bones[i].info.rot_z,
					  file.bones[i].info.rot_w );
		q.Normalize();
		i3d_bones[i] -> setOrientation( q );
		i3d_bones[i] -> setPosition( file.bones[i].info.trans_x/SCALE, file.bones[i].info.trans_y/SCALE, file.bones[i].info.trans_z/SCALE );		
		i3d_bones[i] -> setName( file.bones[i].name );
		i3d_bones[i] -> setLength( 0.1 );
		addEntity( i3d_bones[i] );
	}

	Quat q;
	//set up the parent hierarchy
	for(int i=0; i<file.header.num_bones; i++ )
	{
		int parent_id = file.bones[i].info.parent_id;
		if(parent_id > -1 )
		{
			i3d_bones[i] -> setParent( i3d_bones[file.bones[i].info.parent_id] );
			
		/*			
			float length = file.bones[i].info.trans_x * file.bones[i].info.trans_x/SCALE
									 + file.bones[i].info.trans_y * file.bones[i].info.trans_y/SCALE
									 + file.bones[i].info.trans_z * file.bones[i].info.trans_z/SCALE;
			length = sqrt( length );
			i3d_bones[parent_id] -> setLength( length );
			
			i3d_bones[parent_id] -> setOrientation( i3d_bones[i] -> getOrientation() );
			i3d_bones[i] -> setOrientation( q );
			*/
		
		}
	}	
	
}


void CSF::exportData( ofstream &out )
{
	printf( "Not implemented yet...\n" );
}

