/***************************************************************************
                         csf.h  -  description
                            -------------------
   begin                : Sat Jan 25, 2002
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSF_H
#define CSF_H

#include <Plugins/fileplugin.h>

/**
  *@author Jon Anderson
  */

typedef struct
{
	char token[4];
  int file_version;
  int num_bones;

} csf_header;

/* Note the order.
 * I3D = y is up, CSF = Z is up, so I swapped order...
 */
typedef struct
{
  float trans_x;
  float trans_y;
  float trans_z;

  float rot_x;
  float rot_y;
  float rot_z;
  float rot_w;

  float ltrans_x;
  float ltrans_z;
  float ltrans_y;

  float lrot_x;
  float lrot_y;
  float lrot_z;
  float lrot_w;

  int parent_id;
  int num_children;

} csf_bone_info;

typedef struct
{
	int name_length;
  char * name;
  csf_bone_info info;
  int * children;

} csf_bone;

typedef struct
{
	csf_header header;
	csf_bone *bones;
} csf_file;


/**
  * Imports a skeleton structure from CSF
  *
  * Notes:
  * - Uses +z is up notation.
  * - Each bone is actually what I3D would consider an effector.
  * - Scale is pretty big, like 50 units.  I divided/multiplied by
  *   50.
  */
#define SCALE 40
class CSF : public FilePlugin
{
   public:
      CSF();
      ~CSF();

      void importData( ifstream & );
      void exportData( ofstream & );

			void printFile( csf_file & );
			
			void convertBones( csf_file & );
			
};

#endif
