/***************************************************************************
                         ribfile.cpp  -  description
                            -------------------
   begin                : Sun Aug 20 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ribfile.h"
#include <vector>
#include <iostream.h> 
/*
extern "C" {
FilePlugin * i3d_createInstance(){
 return new RIBFile();
}
}
*/
RIBFile::RIBFile() : FilePlugin( "Renderman", "rib" )
{
   setImportable( false );
   setExportable( true );

}

RIBFile::~RIBFile()
{}

void RIBFile::exportData( ofstream &out )
{
   out << "##RenderMan RIB-Structure 10\n";
   out << "version 3.03\n\n";
   out << "Option \"searchpath\" \"shader\" [\".:/usr/local/BMRT2.5/shaders:&\"]\n";
   out << "Display \"test.tif\" \"file\" \"rgba\"\n";
   out << "Format 800 600 -1\n";
   out << "PixelSamples 1 1\n";
   out << "Projection \"perspective\" \"fov\" 60\n";

   //set up the camera
   out << "Translate 0 -1 8\n";


   out << "WorldBegin\n\n";

   out << "LightSource \"ambientlight\" 1 \"intensity\" 0.5\n\n";


   out << "Declare \"shadows\" \"string\"\n";
   out << "Attribute \"light\" \"shadows\" \"on\"\n";
   out << "LightSource \"distantlight\" 1 \"from\" [0 -1 -4] \"to\" [0 0 0] \"intensity\" 0.8\n\n";

   vector<Entity *> list;
   list = * getMeshes();

   for ( uint i = 0; i < list.size(); i++ )
      writeMeshAsPolygons( ( Mesh * ) list[ i ], out );

   //list = * getSurfaces();
   //for(uint i=0; i<list.size(); i++)
   // writeSurface( (NurbsSurface *) list[i], out);

   out << "\nWorldEnd\n";

}


void RIBFile::writeMeshAsPointsPolygons( Mesh *m, ofstream &out )
{
   Vector4 p;

   p = m -> getPosition();

   out << "AttributeBegin\n";
   out << "Surface \"plastic\"\n";
   out << "Color [1 1 1 ]\n";
   out << "Translate " << p.x << " " << p.y << " " << - p.z << "\n";
   // out << "Rotate 20, 0, 0, 1\n";

   //write out the loop array.
   out << "PointsPolygons [";
   int num_faces = m -> numFaces();

   for ( int i = 0; i < num_faces; i++ )
   {
      Face *f = m -> getFace( i );
      out << f -> getNumVerts() << " ";
   }

   out << "]\n";

   //write out the faces
   out << "[";

   for ( int i = 0; i < num_faces; i++ )
   {
      Face *f = m -> getFace( i );
      int num_verts = f -> getNumVerts();

      for ( int j = 0; j < num_verts; j++ )
      {
         int v = f -> getVertPtr( j ) -> getParentIndex();
         out << v << " ";
      }

      out << " ";
   }

   out << "]\n";

   //write out the vertices
   out << "\"P\" [";
   int num_verts = m -> numVerts();

   for ( int i = 0; i < num_verts; i++ )
   {
      Vertex *v = m -> getVertex( i );
      Vector4 p = v -> getPosition( );
      out << p.x << " " << p.y << " " << -p.z << " ";
   }

   out << "]\n";

   //write out the normals
   out << "\"N\" [";

   for ( int i = 0; i < num_verts; i++ )
   {
      Vertex *v = m -> getVertex( i );
      Vector4 p = v -> getNormal( );
      out << p.x << " " << p.y << " " << p.z << " ";
   }

   out << "]\n\n";



   out << "AttributeEnd\n\n";

}

void RIBFile::writeMeshAsPolygons( Mesh *m, ofstream &out )
{
   Vector4 p;

   p = m -> getPosition();

   out << "AttributeBegin\n";
   out << "Surface \"supertexmap\"\n";
   out << "Color [1 1 1 ]\n";
   out << "Translate " << p.x << " " << p.y << " " << - p.z << "\n";
   // out << "Rotate 20, 0, 0, 1\n";

   int num_faces = m -> numFaces();

   for ( int i = 0; i < num_faces; i++ )
   {
      out << "Polygon ";

      Face *f = m -> getFace( i );
      int num_verts = f -> getNumVerts();
      //write out the points.
      out << "\"P\" [";

      for ( int j = 0; j < num_verts; j++ )
      {
         Vertex *v = f -> getVertPtr( j ) ;
         Vector4 p = v -> getPosition();
         out << p.x << " " << p.y << " " << -p.z << " ";
      }

      out << "]\n";

      //write out the normals.
      out << "\"N\" [";

      for ( int j = 0; j < num_verts; j++ )
      {
         Vertex *v = f -> getVertPtr( j ) ;
         Vector4 p = v -> getNormal();
         out << p.x << " " << p.y << " " << p.z << " ";
      }

      out << "]\n";

      //write out the UVs.
      out << "\"st\" [";

      for ( int j = 0; j < num_verts; j++ )
      {
         UVCoord *v = f -> getUVPtr( j ) ;
         Vector4 p = v -> getPosition();
         out << p.x << " " << 1 - p.y << " ";
      }

      out << "]\n";




   }

   out << "AttributeEnd\n\n";

}


void RIBFile::writeSurface( NurbsSurface *s, ofstream &out )
{
   Vector4 p;

   p = s -> getPosition();

   out << "AttributeBegin\n";
   out << "Surface \"plastic\"\n";
   out << "Color [1 1 1 ]\n";
   out << "Translate " << p.x << " " << p.y << " " << - p.z << "\n";
   // out << "Rotate 0, 0, 0, 1\n";

   int nu, nv;
   int udegree, vdegree;
   int uorder, vorder;
   vector<float> uknots, vknots;

   nu = s -> getNumUPoints();
   nv = s -> getNumVPoints();

   udegree = s -> getUDegree();
   vdegree = s -> getVDegree();

   uknots = s -> getUKnots();
   vknots = s -> getVKnots();

   uorder = udegree + 1;
   vorder = vdegree + 1;
   //write out u information
   out << "NuPatch " << nu << " " << uorder << "[";

   for ( uint i = 0; i < uknots.size(); i++ )
      out << uknots[ i ] << " ";

   out << "] 0 1\n" ;

   //write out v information
   out << nv << " " << vorder << "[";

   for ( uint i = 0; i < vknots.size(); i++ )
      out << vknots[ i ] << " ";

   out << "] 0 1\n";

   //write out control points;
   out << "\"Pw\" [";

   for ( int i = 0; i < nu; i++ )
   {
      for ( int j = 0; j < nv; j++ )
      {
         Vertex *v = s -> getVertex( i * nu + j );
         Vector4 p = v -> getPosition();
         out << p.x << " " << p.y << " " << -p.z << " ";
      }

      out << "\n";
   }

   out << "]\n";

   out << "AttributeEnd\n\n";

}

void RIBFile::writeCamera( Camera *, ofstream & )
{
}
