/***************************************************************************
                       edge.cpp  -  description                              
                          -------------------                                         
 begin                : Wed Dec 15 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "edge.h"
#include "vertex.h"
#include "face.h"
#include "mesh.h"
#include <stdlib.h>
#include <stdio.h>

int Edge::TYPE = Typed::getUID();

Edge::Edge( Object *p ) : SubObject( p )
{
  addType( TYPE );
  m_hard = false;
}

Edge::Edge( int _v1, int _v2, Object *p ) : SubObject( p )
{

  addType( TYPE );

  t_v1 = _v1;
  t_v2 = _v2;

  m_hard = false;

}

void Edge::init()
{

  addVert( t_v1 );
  addVert( t_v2 );

  VERT( vlist[ 0 ] ) ->addEdge( index );
  VERT( vlist[ 1 ] ) ->addEdge( index );

}

Edge::~Edge()
{}

Vector4 Edge::getNormal()
{
  Vector4 a, b;

  a = VERT( vlist[ 0 ] ) -> getNormal();
  b = VERT( vlist[ 1 ] ) -> getNormal();

  a += b;

  a.x /= 2;
  a.y /= 2;
  a.z /= 2;
  a.w = 1;

  return a;


}

/**Divides this edge
  */
int Edge::divideEdge()
{
  //get the midpoint;
  int v3 = getMidpoint();

  int ne1 = getParentObject() ->getEdge( vlist[ 0 ], v3 );
  int ne2 = getParentObject() ->getEdge( v3, vlist[ 1 ] );

  EDGE( ne1 ) -> setHard( m_hard );
  EDGE( ne2 ) -> setHard( m_hard );

  for ( int i = 0; i < ( int ) flist.size(); i++ )
  {
    Face *f = FACE( flist[ i ] );
    f->addVertex( vlist[ 0 ], vlist[ 1 ], v3 );
    f->addEdge( ne1 );
    f->addEdge( ne2 );
    EDGE( ne1 ) -> addFace( flist[ i ] );
    EDGE( ne2 ) -> addFace( flist[ i ] );

  }

  //cleanup this edge.
  detach();

  return v3;
}


int Edge::draw( int d_options )
{
  Vector4 p1;
  Vector4 p2;
  VERT( vlist[ 0 ] ) ->getPosition( &p1 );
  VERT( vlist[ 1 ] ) ->getPosition( &p2 );

  if ( isSelected() )
  {
    drawBoundingBox();
    glColor4f( 1, 0, 0, 1 );
  }

  else
  {
    if ( m_hard )
      glColor4f( 0, 0, 0, 1 );
    else
      glColor4f( 0, 0, .7, 1 );
  }

  glBegin( GL_LINES );
  glVertex3f( p1.x, p1.y, p1.z );
  glVertex3f( p2.x, p2.y, p2.z );
  glEnd();
  return 0;
}

int Edge::getMidpoint()
{
  int v3 = 0;

  if ( v3 == 0 )
  {
    Vector4 & ep1 = VERT( vlist[ 0 ] ) ->getPosition();
    Vector4 &ep2 = VERT( vlist[ 1 ] ) ->getPosition();

    Vertex *v = m_parent -> createVertex( ( ep1.x + ep2.x ) / 2,
                                          ( ep1.y + ep2.y ) / 2,
                                          ( ep1.z + ep2.z ) / 2 );

    v3 = v -> getParentIndex();
  }


  return v3;
}


Vector4 Edge::getUVCenter()
{
  return Vector4( 0, 0, 0, 1 );
  /*
  Vector4 c(0, 0, 0, 0);
  int n = (int)uvlist.size();
  for(int i=0; i<n; i++){
   c += UV(uvlist[i]) -> getPosition();
}
  c.x /= n;
  c.y /= n;
  c.z /= n;

  return c;
  */
}

bool Edge::operator==( Edge &rhs )
{
  printf( "This Edge: %d, %d; 2nd edge: %d, %d\n", vlist[ 0 ], vlist[ 2 ], rhs.vlist[ 0 ], rhs.vlist[ 1 ] );

  if ( ( ( vlist[ 0 ] == rhs.vlist[ 0 ] ) && ( vlist[ 1 ] == rhs.vlist[ 1 ] ) ) ||
       ( ( vlist[ 1 ] == rhs.vlist[ 0 ] ) && ( vlist[ 0 ] == rhs.vlist[ 1 ] ) ) )
    return true;
  else
    return false;

}

Edge & Edge::operator=( Edge &rhs )
{
  SubObject::operator=( rhs );
  m_hard = rhs.m_hard;
  return *this;
}

Edge * Edge::clone()
{
  Edge * e = m_parent -> createEdge();
  *e = *this;
  return e;
}

void Edge::copyFrom( SubObject * s )
{
  *this = * static_cast < Edge * > ( s );
}
