/***************************************************************************
                       grid.cpp  -  description
                          -------------------
 begin                : Sun Mar 4 2001
 copyright            : (C) 2001 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "grid.h"
#include <GL/gl.h>

int Grid::m_size = 10;
int Grid::m_spacing = 10;

Grid::Grid( Matrix44 &m ) :
    m_light( 0.7, 0.7, 0.7, 1 ),
    m_dark( 0.6, 0.6, 0.6, 1 )
{
  m_matrix = m;
}

Grid::~Grid()
{}

void Grid::draw( int d_options )
{
  glPushMatrix();
  glMultMatrixf( ( GLfloat* ) m_matrix.m );

  glPushAttrib( GL_LIGHTING_BIT );
  glDisable( GL_LIGHTING );

  int i = 0;

  glBegin( GL_LINES );

  float j = -m_size;

  float sp = ( float ) m_spacing / 10;

  while ( j < m_size + sp )
  {

    if ( fabs( i % 5 ) == 0 )
      glColor4f( m_dark.x, m_dark.y, m_dark.z, 1 );
    else
      glColor4f( m_light.x, m_light.y, m_light.y, 1 );

    //draw two lines mirroring the z axis.
    glVertex3f( j, 0, -m_size );

    glVertex3f( j, 0, m_size );

    glVertex3f( -j, 0, -m_size );

    glVertex3f( -j, 0, m_size );

    //draw two lines mirroring the x axis.
    glVertex3f( -m_size, 0, j );

    glVertex3f( m_size, 0, j );

    glVertex3f( -m_size, 0, -j );

    glVertex3f( m_size, 0, -j );

    j += sp;

    i++;

  }

  glEnd();

  glPopAttrib();
  glPopMatrix();

}
