/***************************************************************************
                         meshparser.cpp  -  description
                            -------------------
   begin                : Sun Jun 9 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "meshparser.h"
#include "mesh.h"
#include "uvcoord.h"
#include "face.h"
#include <objectdb.h>
#include <stdio.h>



MeshParser::MeshParser()
{
}

MeshParser::~MeshParser()
{}

void MeshParser::write( QDomElement &parent, Typed * t )
{
  Mesh * m = ( Mesh * ) t ;
  QDomDocument doc = parent.ownerDocument();

  QDomElement mesh;
  QDomElement e;

  mesh = doc.createElement( "mesh" );
  parent.appendChild( mesh );

  writeMeta( mesh, m );

  e = doc.createElement( "material" );
  e.setAttribute( "id", ObjectDB::getInstance() -> getMaterialIndex( m -> getTextureMaterial() ) );
  mesh.appendChild( e );

  e = doc.createElement( "vertices" );
  mesh.appendChild( e );

  writeVertices( e, m );

  e = doc.createElement( "uvs" );
  mesh.appendChild( e );

  writeUVs( e, m );

  e = doc.createElement( "faces" );
  mesh.appendChild( e );

  writeFaces( e, m );

}

void MeshParser::writeFaces( QDomElement &faces, Mesh * mesh )
{
  QDomElement e;
  QDomElement ve;

  QDomDocument doc = faces.ownerDocument();

  Face *f;

  for ( int i = 0; i < mesh->numFaces(); i++ )
  {
    e = doc.createElement( "face" );
    faces.appendChild( e );
    f = mesh -> getFace( i );

    for ( int j = 0; j < f->getNumVerts(); j++ )
    {
      ve = doc.createElement( "fv" );
      e.appendChild( ve );
      ve.setAttribute( "vt", f->getVert( j ) );
      ve.setAttribute( "uv", f->getUV( j ) );

    }
  }
}

void MeshParser::writeUVs( QDomElement &uvs, Mesh *mesh )
{
  QDomElement e;
  QDomElement ve;

  QDomDocument doc = uvs.ownerDocument();

  UVCoord *uv;
  Vector4 v;

  for ( int i = 0; i < mesh->numUVs(); i++ )
  {
    ve = doc.createElement( "uv" );
    uvs.appendChild( ve );
    uv = mesh -> getUVCoord( i );
    v = uv -> getPosition( );

    ve.setAttribute( "id", Parser::getUID() );

    ve.setAttribute( "u", v.x );
    ve.setAttribute( "v", v.y );

  }

}

Typed * MeshParser::read( QDomElement &mesh )
{
  QDomElement e;

  Mesh *m = new Mesh();

  readMeta( mesh, m );

  e = mesh.namedItem( "material" ).toElement();
  int id = atoi( e.attributeNode( "id" ).value() );

  if ( id >= 0 )
    m -> setTextureMaterial( ObjectDB::getInstance() -> getMaterial( id ) );

  e = mesh.namedItem( "vertices" ).toElement();

  readVertices( e, m );

  e = mesh.namedItem( "uvs" ).toElement();

  readUVs( e, m );

  e = mesh.namedItem( "faces" ).toElement();

  readFaces( e, m );

  return m;
}

void MeshParser::readFaces( QDomElement &faces, Mesh *mesh )
{
  QDomElement e;
  QDomElement ve;
  QDomNodeList fnl;
  QDomNodeList vnl;
  fnl = faces.elementsByTagName( "face" );

  for ( int i = 0; i < ( int ) fnl.length(); i++ )
  {
    vector < int > vlist;
    vector < int > uvlist;

    vnl = fnl.item( i ).toElement().elementsByTagName( "fv" );

    for ( int j = 0; j < ( int ) vnl.length(); j++ )
    {
      e = vnl.item( j ).toElement();
      vlist.push_back( atoi( e.attributeNode( "vt" ).value() ) );
      uvlist.push_back( atoi( e.attributeNode( "uv" ).value() ) );
    }

    mesh -> createFace( vlist, uvlist );

  }

}

void MeshParser::readUVs( QDomElement &uvs, Mesh *mesh )
{
  QDomElement e;

  QDomNodeList nl;

  Vector4 v;

  nl = uvs.elementsByTagName( "uv" );

  for ( int i = 0; i < ( int ) nl.length(); i++ )
  {
    UVCoord *uv;
    e = nl.item( i ).toElement();

    v.x = atof( e.attributeNode( "u" ).value() );
    v.y = atof( e.attributeNode( "v" ).value() );

    uv = mesh -> createUVCoord( v.x, v.y );

  }

}


