/***************************************************************************
                       object.h  -  description                              
                          -------------------                                         
 begin                : Sat Aug 14 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef OBJECT_H
#define OBJECT_H

//STL includes
#include <vector>
#include <list>
#include <algorithm>

//QT includes
#include <qgl.h>

//local includes
#include "entity.h"
#include "subobject.h"

class Vertex;

class UVCoord;

class Material;

class Texture;

class Edge;

class TextureMaterial;

class SubObject;

class VertSeg;

class Face;

/**
 *
 *
 * @author Jonathan E. Anderson
 */


class Object : public Entity
{

public:
   Object( float x, float y, float z, Entity *parent = 0 );
   Object( Vector4 &p, Entity *parent = 0 );
   Object( Entity *parent = 0 );
   virtual ~Object();

   virtual void copyFrom( Entity * );

   virtual void copyVertsPosTo( Object * );
   virtual void copyVertsTo( Object * );
   virtual void copyFacesTo( Object * );
   virtual void copyEdgesTo( Object * );
   virtual void copyUVsTo( Object * );
   virtual void copyMaterialsTo( Object * );
   virtual void copySubObjectsTo( int type, Object * o );

   void merge( vector<Object *> &objs )
   {}

   ;

   //drawing functions
   virtual int render( int d_options = 0 );
   virtual int draw( int d_options = 0 );
   void drawVerts();
   void drawEdges();
   void drawPivotPoint();

   //overloaded transforming functions
   virtual void scale( float x, float y, float z, float ox = 0, float oy = 0, float oz = 0 );
   virtual void rotate( float amount, float x, float y, float z, float px, float py, float pz );
   virtual void setSize( float w, float h, float d );

   //Material functions
   virtual void setTextureMaterial( TextureMaterial *t )
   {
      tmlayer[ 0 ] = t;
   };

   TextureMaterial * getTextureMaterial( int i = 0 );


   //Bounding functions
   void setBoundingBox( Vector4 &min, Vector4 &max )
   {
      bounding_min = min;
      bounding_max = max;
   };

   virtual void getBoundingMin( Vector4 * );
   virtual void getBoundingMax( Vector4 * );
   void normalize();
   void center();
   void calcBoundingBox();

   static void dumpVerts( vector<Vertex *> &list );
   virtual void dump();
   void dumpVector( vector<int> & );

   //copying functions
   virtual Object &operator=( Object &rhs );
   virtual Entity * clone() = 0;

   //maintenance functions
   vector<SubObject *> * getEdges()
   {
      return & edges;
   };

   vector<SubObject *> * getVerts()
   {
      return & verts;
   };

   vector<SubObject *> * getUVs()
   {
      return & uvs;
   };

   vector<SubObject *> * getFaces()
   {
      return & faces;
   };

   vector<SubObject *> * getSubObjectList( int type );

   virtual SubObject * getSubObject( int mode, int index );

   virtual void addVert( Vertex *v );
   virtual void addFace( Face *v );
   virtual void addEdge( Edge *v );
   virtual void addSubObject( SubObject * );

   void removeVert( int i );
   void removeFace( int i );
   void removeEdge( int i );
   void removeSubObject( SubObject * );


   void deleteVert( int i );
   void deleteEdge( int i );
   void deleteFace( int i );
   void deleteSubObject( int type, int i );

   Vertex * createVertex( );
   Vertex * createVertex( Vector4 &p );
   Vertex * createVertex( float, float, float );
   Edge * createEdge ( );
   Edge * createEdge ( int, int );

   Face * createFace ( );
   Face * createFace ( int, int , int );
   Face * createFace ( int, int, int, int );
   Face * createFace ( vector<int> & );
   Face * createFace ( vector<int> &, vector<int> & );

   UVCoord* createUVCoord ( float, float );
   UVCoord* createUVCoord ( );

   SubObject * createSubObject( int type );


   Face * getFace( int i );
   Vertex * getVertex( int i );
   Edge * getEdge( int i );
   UVCoord * getUVCoord( int i );

   int numFaces()
   {
      return ( int ) faces.size();
   };

   int numEdges()
   {
      return ( int ) edges.size();
   };

   virtual int numVerts()
   {
      return ( int ) verts.size();
   };

   int numUVs()
   {
      return ( int ) uvs.size();
   };

   int findFace( Face *f );
   int findEdge( Edge *f );
   int findVertex( Vertex *f );
   int findUV( UVCoord *f );
   int findSubObject( int, SubObject * );


   vector<int> getSubObjectFaces( int stype, vector<int> &solist );
   vector<int> getSubObjectEdges( int stype, vector<int> &solist );
   vector<int> getSubObjectVerts( int stype, vector<int> &solist );
   vector<int> getSubObjectSubObjects( int type, int stype, vector<int> &solist );

   void markForDeletion( SubObject * );
   void cleanSubObjects();

   void cleanEdges();
   void cleanEdges( vector<int> &elist );
   void cleanVerts();

   float getFaceOrientation( vector<int> & );

   vector<int> getFaceOrderedEdges( vector<int> & );

   int getMidPoint( int, int );
   int getEdge( int, int );



   static int TYPE;
   static bool show_axis;
   static TextureMaterial *m_default_material;

protected:
   Vector4 bounding_min;
   Vector4 bounding_max;

   vector<SubObject *> verts;
   vector<VertSeg *> segs;
   vector<SubObject *> uvs;
   vector<SubObject *> edges;
   vector<SubObject *> faces;

   list<SubObject *> defunct;

   TextureMaterial *tmlayer[ 5 ];

   int glID;

};

/**Temp class used instead of edges in some operations */

class VertSeg
{

public:
   int v1;
   int v2;
   Vertex *mid;
};

#endif
























