/***************************************************************************
                         parser.cpp  -  description
                            -------------------
   begin                : Sat Jun 8 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "parser.h"

#include "stdio.h"

//keep 2 maps arount, one keyed on the Type, the other on the tag.
ParserTypeMap Parser::m_type_parsers;
ParserTagMap Parser::m_tag_parsers;


int Parser::UID = 0;

int Parser::setParser( int type, string tag, Parser * p )
{
  printf( "Parser type %s -> %d\n", tag.c_str(), type );
  m_type_parsers[ type ] = p;
  m_tag_parsers[ tag ] = p;
  return type;
}

Parser * Parser::getParser( int type )
{
  printf( "Getting parser for '%d'...", type );
  ParserTypeMap::iterator it = m_type_parsers.find( type );

  if ( it == m_type_parsers.end() )
  {
    printf( "Parser not found\n" );
    return 0;
  }

  printf( "\n" );
  return m_type_parsers[ type ];
}

Parser * Parser::getParser( string tag )
{
  printf( "Getting parser for '%s'...", tag.c_str() );
  ParserTagMap::iterator it = m_tag_parsers.find( tag );

  if ( it == m_tag_parsers.end() )
  {
    printf( "Parser not found\n" );
    return 0;
  }

  printf( "\n" );
  return m_tag_parsers[ tag ];
}


