/***************************************************************************
                       polyskin.cpp  -  description
                          -------------------
 begin                : Wed May 10 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "polyskin.h"
#include "vertex.h"
#include "nurbscurve.h"
#include "nurbssurface.h"
#include "face.h"
#include "mesh.h"


PolySkin::PolySkin()
{
  quads = false;
}

PolySkin::~PolySkin()
{}

Mesh * PolySkin::getMesh( vector < Spline* > &splines )
{
  //first loop through, copying verts into a mesh, and organizing them into vectors rather than splines.
  int segments = ( int ) splines.size();

  Mesh *m = new Mesh();
  sverts = new VertexList[ segments ];

  for ( int i = 0; i < segments; i++ )
  {
    Spline *s = splines[ i ];
    VertexList *sv = s->getVerts();
    //  int n = sv->size();
    for ( int j = 0; j < ( int ) sv->size(); j++ )
    {
      Vector4 v;
      ( *sv ) [ j ] ->getTransformedPosition( &v );
      Vertex *nv = m -> createVertex( v );
      sverts[ i ].push_back( nv );
    }
  }

  //now the verts are organized into nice lists, go ahead and skin them. algorithm is
  //the same as revolving, only the left overs are just made into triangles using the 'short'
  //vertex.
  for ( int i = 0; i < segments - 1; i++ )
  {
    int min = sverts[ i ].size();
    int max = sverts[ i + 1 ].size();

    if ( ( int ) sverts[ i + 1 ].size() < min )
    {
      min = sverts[ i + 1 ].size();
      max = sverts[ i ].size();
    }

    for ( int j = 0; j < min - 1; j++ )
    {
      if ( quads )
      {
        m -> createFace( sverts[ i + 1 ][ j ] ->getParentIndex(),
                         sverts[ i ][ j ] ->getParentIndex(),
                         sverts[ i ][ j + 1 ] ->getParentIndex(),
                         sverts[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }

      else
      {
        m -> createFace( sverts[ i + 1 ][ j ] ->getParentIndex(),
                         sverts[ i ][ j ] ->getParentIndex(),
                         sverts[ i ][ j + 1 ] ->getParentIndex() );

        m -> createFace( sverts[ i + 1 ][ j ] ->getParentIndex(),
                         sverts[ i ][ j + 1 ] ->getParentIndex(),
                         sverts[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }
    }

    //create triangles with the leftovers
    if ( sverts[ i ].size() != sverts[ i + 1 ].size() )
    {
      if ( min == ( int ) sverts[ i ].size() )
      {
        for ( int k = min - 1; k < max - 1; k++ )
        {
          m -> createFace( sverts[ i + 1 ][ k ] ->getParentIndex(),
                           sverts[ i ][ min - 1 ] ->getParentIndex(),
                           sverts[ i + 1 ][ k + 1 ] ->getParentIndex() );
        }
      }

      else
      {
        for ( int k = min - 1; k < max - 1; k++ )
        {
          m -> createFace( sverts[ i + 1 ][ min - 1 ] ->getParentIndex(),
                           sverts[ i ][ k ] ->getParentIndex(),
                           sverts[ i ][ k + 1 ] ->getParentIndex() );
        }
      } //else
    } //if

  } //for i

  //m->center();




  m->normalize();

  return m;
}

NurbsSurface * PolySkin::getSurface( vector < Spline* > &splines )
{

  int segments = ( int ) splines.size();

  int degree = 0;

  if ( segments == 2 )
    degree = 1;

  if ( segments == 3 )
    degree = 2;

  if ( segments > 3 )
    degree = 3;

  //create a NurbsCurve Array
  PLib::NurbsCurvef pns[ segments ];

  for ( int i = 0; i < segments; i++ )
    pns[ i ] = ( ( NurbsCurve * ) splines[ i ] ) ->getWorldSpaceCurve();

  PLib::NurbsCurveArrayf pnca;

  pnca.init( pns, segments );

  NurbsSurface *s = new NurbsSurface();

  s->skinU( pnca, degree );


  return s;


}

