/***************************************************************************
                        primitive.h  -  description
                           -------------------
  begin                : Fri Apr 20 2001
  copyright            : (C) 2001 by Jon Anderson
  email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PRIMITIVE_H
#define PRIMITIVE_H

#include "mesh.h"

/**
  *@author Jon Anderson
  */

class Primitive
{

public:

   enum { POINTS, TRIANGLES, QUADS, TRISTRIP, QUADSTRIP };

   Primitive( int which );

   ~Primitive();

   void terminate();
   void extend( Vector4 &pt );

   void setMesh( Mesh * m );
   Mesh * getMesh( )
   {
      return m_mesh;
   };

protected:

   void addTriangle();
   void addQuad();
   void addTStrip();

   void cleanupTriangle();
   void cleanupQuad();
   void cleanupQuadStrip();

   void addQStrip();

   int m_type;

   int m_verts_added;
   int m_num_verts;
   Mesh * m_mesh;

};

#endif
