/***************************************************************************
                        spline.h  -  description                              
                           -------------------                                         
  begin                : Wed Dec 15 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SPLINE_H
#define SPLINE_H

#include "object.h"

/**A spline is the base object for all objects that are extrudable or revolvable.
  *Splines are created from a list of user inputable points.
  *Splines can be rendered in variety of ways.  The points can be vertices in a (closed?)Line,
  *Vertices in a polygon, control points in a (closed?)NurbsCurve, or surface points in a (closed?)
  *NurbsCurve.
  *@author Jon Anderson
  */

class Spline : public Object
{

public:
   Spline( Entity *parent = 0 );
   Spline( vector<Vector4> &v, Entity *parent = 0 );
   Spline( Vector4 &p, Entity *parent = 0 );

   virtual int draw( int d_options = 0 )
   {
      return 0;
   };

   virtual void copyFrom( Entity * );

   virtual ~Spline();
   virtual void reverse();
   virtual void extend( Vector4 & )
   {}

   ;

   virtual void breakSpline()
   {}

   ;

   virtual void closeSpline()
   {}

   ;

   virtual Entity * sweep( Spline &s )
   {
      return 0;
   };

   virtual Entity * revolve( Spline &s, int, int )
   {
      return 0;
   };

   virtual Spline & operator=( Spline&rhs );

   virtual Entity * clone();

   virtual void weld( int, int, int )
   {}

   ;

   virtual Object * slice( int type, vector<int> &solist )
   {
      return 0;
   };

   virtual void connect( int type, vector<int> & )
   {}

   ;

   static int TYPE;

protected:
   bool closed;
};

#endif
