#include "pythonconsole.h"

#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <fstream>
#include <qfiledialog.h>
#include <qmessagebox.h>

#include <iostream>
#include <fstream>

using namespace std;

#ifdef HAVE_CONFIG_H
#include <autoconfig.h>
#endif

#ifdef USE_PYTHON
#include "Python.h"
#endif

/*
 *  Constructs a PythonConsole which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
PythonConsole::PythonConsole( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : IPythonConsole( parent, name, modal, fl )
{

}

/*  
 *  Destroys the object and frees any allocated resources
 */
PythonConsole::~PythonConsole()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void PythonConsole::slotClear()
{
   txtConsole -> setText( "" );
}
/* 
 * public slot
 */
void PythonConsole::slotExecute()
{

#ifdef USE_PYTHON
   QString code_line;
   for(int i=0; i<txtConsole -> numLines(); i++ )
   {
      code_line = txtConsole->textLine(i) + "\n";
			PyRun_SimpleString( const_cast<char *>(code_line.ascii()) );
     // if ( !PyRun_SimpleString( const_cast<char *>(code_line.ascii()) ) )
			//{
			//	QMessageBox::warning( this, "I3D Python Script", "There was an error" );
			//	break;
		//	}
   }
#endif

}
/* 
 * public slot
 */
void PythonConsole::slotLoad()
{
   ifstream in;

   static QString path = QDir::home().path();

   QString fileToOpen = QFileDialog::getOpenFileName( path, "*.py", this, "Open Script..." );


   path = QString::null;

   if ( !fileToOpen.isEmpty() )
   {
      in.open(fileToOpen.ascii(), ios::in);

       if(!in)
           return;

       char buffer[1024];

       while( !in.eof() )
       {
          in.getline( buffer, 1024 );
          txtConsole -> append( buffer );
       }

       in.close();
   }
}

/* 
 * public slot
 */
void PythonConsole::slotSave()
{
   ofstream out;

   QString fileToSave = QFileDialog::getSaveFileName( QDir::home().path(), "*.py", this, "Save Script..." );

   if ( !fileToSave.isEmpty() )
   {
      if(fileToSave.right(3) != ".py" )
         fileToSave += ".py";

      out.open(fileToSave.ascii(), ios::out);

       if(!out)
           return;

      for(int i=0; i< txtConsole->numLines(); i++ )
      {
         out << txtConsole->textLine(i).ascii() << endl;
      }
       out.close();
   }
}

