/***************************************************************************
                         animtoolbar.h  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ANIMTOOLBAR_H
#define ANIMTOOLBAR_H

#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <Math/vector4.h>
#include <qslider.h>

#include "i3d.h"     // For getting settings
#include <config.h>

/**
  *@author Jon Anderson
  */

class AnimToolbar : public QObject
{
      Q_OBJECT

   public:

      ~AnimToolbar();

      void init( QToolBar * );

      static AnimToolbar * getInstance();

      int getTime();
      void setTime( int );
      void setMax( int );

      QToolBar *m_toolbar;
      QToolButton *btnPlay;
      QToolButton *btnReverse;
      QToolButton *btnSave;
      QToolButton *btnDelete;
      QToolButton *btnEnd;
      QToolButton *btnStart;
      QToolButton *btnStop;
			QSlider * sldrKeyframe;
			
      QLineEdit * fldKeyframe;

      static AnimToolbar *m_instance;


   public slots:

			void slotPlay();
			void slotReverse();			
			void slotStop();
			void slotEnd();
			void slotStart();
			void slotSave();
			void slotDelete();
			
			void slotSlider(int);


   protected:
      AnimToolbar();

};

#endif

