/***************************************************************************
                         meshmodifier.h  -  description
                            -------------------
   begin                : Sat Apr 21 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MESHMODIFIER_H
#define MESHMODIFIER_H

#include "objectmodifier.h"

class UVWrap;

/**
  *@author Jon Anderson
  */

class MeshModifier : public ObjectModifier
{

      Q_OBJECT

   public:
      MeshModifier();
      ~MeshModifier();
      virtual void activate();
      virtual void deactivate();

      virtual void startTransform();
      virtual void endTransform();
      virtual void transform ( Vector4 &, Vector4 & );

      virtual void draw();

      virtual void keyEvent ( QKeyEvent * );

      virtual void addPrimitive( int );

      static int TYPE;

   public slots:
      void slotMirrorX();
      void slotMirrorY();
      void slotMirrorZ();

      void slotMerge();
      void slotExplode();
      void slotTriangulate();
      void slotSubdivide();
      void slotSmooth();
      void slotTighten();
      void slotReverse();

      void slotToggleEdges();
      void slotToggleCullFaces();
      void slotToggleVertexTicks();

      void slotCenter();



      void slotResetPosition();
      void slotResetOrientation();

      void slotXYPlaneGizmo();
			void slotXZPlaneGizmo();
			void slotYZPlaneGizmo();

      void slotCubeGizmo();
      void slotCylinderGizmo();
      void slotSphereGizmo();

      void slotEditUVs();

      void slotApplyGizmo();
      void slotQuitGizmo();

      void slotMatEditor();

      void slotProperties();

      void slotAddPoints();
			void slotAddTris();
			void slotAddQuads();
			void slotAddTriStrip();
			void slotAddQuadStrip();


   protected:
      int menu_edge;
      int menu_face;
      int menu_ticks;

      UVWrap * m_gizmo;
      bool m_using_gizmo;
};

#endif
