/***************************************************************************
                         view3D.cpp  -  description          
                            -------------------                       
   begin                : Thu Apr 8 1999                        
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : ande1514@tc.umn.edu                  
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "view3D.h"
#include <Entities/texture.h>
#include <qpopupmenu.h>
#include <i3d.h>

View3D::View3D( QWidget *parent, const char *name, QGLWidget *sharer )
      : GLView( parent, name, sharer )
{
   m_plane.assign( 0, 1, 0, 1 );

   camera = new Entity( 0, -1 * zoom, -4 * zoom, 0 );
   x_rotate = 0;
   y_rotate = 0;
   x_look = 0;
   y_look = 0;


   QPopupMenu *mmenu = new QPopupMenu();
   mmenu->insertItem( "XY Plane", this, SLOT( slotPlaneXY() ) );
   mmenu->insertItem( "XZ Plane", this, SLOT( slotPlaneXZ() ) );
   mmenu->insertItem( "YZ Plane", this, SLOT( slotPlaneYZ() ) );

   options->insertSeparator();
   options->insertItem( "Working Plane", mmenu );

   Matrix44 m;

   m_grid = new Grid( m );


   //   options->insertItem( "Print image", this, SLOT(printImage()));

}

View3D::~View3D()
{
}

bool View3D::updateCamera()
{
   if ( cmode == LOCK )
      return false;

   switch ( cmode )
   {
      case PAN:
         break;
      case ORBIT:
         rotateCamera( mouse_move_x - prev_mouse_move_x, mouse_move_y - prev_mouse_move_y );
         return true;
         break;
      case ZOOM:
         zoomCamera( mouse_move_x - prev_mouse_move_x, mouse_move_y - prev_mouse_move_y );
         return true;
         break;
      case TRUCK:
         break;
      case SLIDE:
         moveCamera( mouse_move_x - prev_mouse_move_x, mouse_move_y - prev_mouse_move_y );
         return true;
         break;
      default:
         return false;
         break;
   }

   return false;
}

void View3D::display()
{

   if ( moving && wireframe_move )
      glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );

   I3D::getDB()->draw();

   if ( moving && wireframe_move )
      if ( wireframe_3d )
         glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
      else
         glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );

}

void View3D::setCamera()
{
   Vector4 p = camera->getPosition();

   GLfloat lpos[] = {0, 1, 1, 0};

   glLightfv( GL_LIGHT0, GL_POSITION, lpos );

   glRotatef( x_look, 1, 0, 0 );
   glRotatef( y_look, 0, 1, 0 );

   glTranslatef( p.x, p.y, p.z );
   glRotatef( x_rotate, 1, 0, 0 );
   glRotatef( y_rotate, 0, 1, 0 );


}

void View3D::setProjection()
{
   glFrustum( -.5 * wpct, .5 * wpct, -.5 * hpct, .5 * hpct, 1, 2500 );
   //gluPerspective(60, 1, .1, 2500);
}


void View3D::initView()
{

   /*Need to fix the lighting here.*/

   GLfloat amb[] = {.5, .5, .5, 1};
   GLfloat lpos[] = {0, 1, 1, 0};

   glLightModelfv( GL_LIGHT_MODEL_AMBIENT, amb );
   glLightModeli( GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE );
   glEnable( GL_LIGHTING );
   glEnable( GL_LIGHT0 );
   glColorMaterial( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
   glEnable( GL_COLOR_MATERIAL );
   glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );


   glLightfv( GL_LIGHT0, GL_POSITION, lpos );


   glEnable( GL_CULL_FACE );
   glCullFace( GL_BACK );



}

void View3D::moveCamera( float x, float y )
{
   //should do along the vector parallel to screen, rather than in object space.
   camera->move( x * 4 * wpct * zoom / width, -y * 4 * hpct * zoom / height, 0 );
}

void View3D::rotateCamera( float x, float y )
{
   x_rotate += y / 3;
   y_rotate += x / 3;

}

void View3D::zoomCamera( float x, float y )
{
   camera->move( 0, 0, x / 20 );
}

void View3D::panCamera( float x, float y )
{
   x_look += y / 3;
   y_look += x / 3;
}

void View3D::truckCamera( float x, float y )
{

}

void View3D::drawBackground()
{
   glPushAttrib( GL_TEXTURE_BIT | GL_LIGHTING_BIT | GL_POLYGON_BIT );
   glEnable( GL_TEXTURE_2D );
   glBindTexture( GL_TEXTURE_2D, background->getID() );


   //Set a 2D projection mode
   glMatrixMode( GL_PROJECTION );
   glPushMatrix();
   glLoadIdentity();
   glOrtho( -2 * zoom * wpct, 2 * zoom * wpct, -2 * zoom * hpct, 2 * zoom * hpct, -500, 500 );
   glMatrixMode( GL_MODELVIEW );
   glPushMatrix();
   glLoadIdentity();

   glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
   glDisable( GL_LIGHTING );
   glColor4f( 1, 1, 1, 1 );
   float wt, ht;


   wt = wpct;
   ht = hpct;
   glBegin( GL_QUADS );
   glTexCoord2f( 0, 0 );
   glVertex3f( -2 * zoom * wt, -2 * zoom * ht, -499 );
   glTexCoord2f( 1, 0 );
   glVertex3f( 2 * zoom * wt, -2 * zoom * ht, -499 );
   glTexCoord2f( 1, 1 );
   glVertex3f( 2 * zoom * wt, 2 * zoom * ht, -499 );
   glTexCoord2f( 0, 1 );
   glVertex3f( -2 * zoom * wt, 2 * zoom * ht, -499 );
   glEnd();
   glPopMatrix();

   glMatrixMode( GL_PROJECTION );
   glPopMatrix();

   glMatrixMode( GL_MODELVIEW );

   glPopAttrib();
}

void View3D::drawGrid()
{
   m_grid -> setSize( (int) grid_size );
   m_grid -> setSpacing( (int) grid_unit );
   m_grid -> draw();

}

/**Translates a screen click into 3D points.
  *
  *For the 3D View, it projects the point onto th XZ plane.
  *
  *The XZ plane is bounded by the Grid.  Any clicked points outside
  *the plane are truncated to within it.
  */
Vector4 &View3D::unProjectPoint( int x, int y )
{

   Vector4 l1;
   Vector4 l2;

   Vector4 in;

   y = height - y;

   in.x = ( x - ( float ) viewport[ 0 ] ) * 2 / ( float ) viewport[ 2 ] - 1.0;
   in.y = ( y - ( float ) viewport[ 1 ] ) * 2 / ( float ) viewport[ 3 ] - 1.0;
   in.z = 1;
   in.w = 1.0;

   Matrix44 m;
   m = *projMatrix * *modMatrix;
   m.Invert();

   /*Find the line corresponding to
    *the point clicked.
    */
   l1 = m * in;
   l1 /= l1.w;
   in.z = -1;
   l2 = m * in;
   l2 /= l2.w;

   intersectPoint = l1.intersectPlane( l2, m_plane );

   //clip the intersectPoint to the grid size;

   if ( intersectPoint.x > grid_size )
      intersectPoint.x = grid_size;

   if ( intersectPoint.y > grid_size )
      intersectPoint.y = grid_size;

   if ( intersectPoint.z > grid_size )
      intersectPoint.z = grid_size;

   if ( intersectPoint.x < -grid_size )
      intersectPoint.x = -grid_size;

   if ( intersectPoint.y < -grid_size )
      intersectPoint.y = -grid_size;

   if ( intersectPoint.z < -grid_size )
      intersectPoint.z = -grid_size;

   return intersectPoint;

}


void View3D::setWireframe3D( bool b )
{
   wireframe_3d = b;
   makeCurrent();

   if ( b )
      glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
   else
      glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );

}

















































































































































































