/***************************************************************************
                       objectselector.cpp  -  description
                          -------------------                                         
 begin                : Thu Jul 26 08:26:09 PDT 2001

 author               : Kevin T. Seghetti (kts@worldfoundry.org)
 copyright            : (C) 2001 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "objectselector.h"
#include <assert.h>
#include <iostream>
#include <algorithm>

#include <qlabel.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qgroupbox.h>

#include <objectdb.h>

//==============================================================================
// class to hold whicn entity each list entry belongs to

class ObjectListEntry : public QListBoxText
{

public:

  ObjectListEntry( Entity* entity );

  Entity* _entity;
};

ObjectListEntry::ObjectListEntry( Entity* entity ) : QListBoxText( QString( QString::fromLatin1( entity->getName().c_str() ) ) )
{
  _entity = entity;
}

//==============================================================================
// kts I started with the QT listbox example, as I finished I realized I should
// have learned how to use the QT dialog editor instead of laying it out manually
// someday maybe I will come back and update this

ObjectListSelector::ObjectListSelector()
    : QDialog( 0, 0, TRUE )
{

  QVBoxLayout * all = new QVBoxLayout( this );
  assert( all );

  QHBoxLayout* body = new QHBoxLayout( all );
  assert( body );

  all->addSpacing( 12 );

  QHBoxLayout* bottom = new QHBoxLayout( all );
  assert( bottom );

  listBox = new QListBox( this );
  body->addWidget( listBox );
  listBox->setFocusPolicy( QWidget::StrongFocus );

  listBox->setVariableHeight( false );
  listBox->setVariableWidth( false );
  listBox->clearSelection();
  listBox->setSelectionMode( QListBox::Extended );

  QVBoxLayout * v = new QVBoxLayout;
  body->addLayout( v );

  bMultipleColumns = false;
  showType = SHOW_ALL;
  sortType = SORT_NONE;

  QGroupBox *grpDisplay = new QGroupBox ( 1, Horizontal, "Display Settings", this, "NoName" );
  v->addWidget( grpDisplay );

  QCheckBox* chk = new QCheckBox( "NoName", grpDisplay );
  assert( chk );
  connect( chk, SIGNAL( clicked() ), this, SLOT( toggleMultipleColumns() ) );
  chk->setText( "Multiple Columns" );
  chk->setChecked( false );

  QGroupBox *grpSort = new QGroupBox ( 1, Horizontal, "Sort", grpDisplay, "NoName" );

  QRadioButton * b;
  sortButtonGroup = new QButtonGroup( 0 );

  b = new QRadioButton( "Order Created", grpSort );
  sortButtonGroup->insert( b );
  b->setChecked( TRUE );
  connect( b, SIGNAL( clicked() ), this, SLOT( sortOrderCreated() ) );

  b = new QRadioButton( "Ascending", grpSort );
  sortButtonGroup->insert( b );
  connect( b, SIGNAL( clicked() ), this, SLOT( sortAscending() ) );

  b = new QRadioButton( "Descending", grpSort );
  sortButtonGroup->insert( b );
  connect( b, SIGNAL( clicked() ), this, SLOT( sortDescending() ) );

  QGroupBox *grpShow = new QGroupBox ( 1, Horizontal, "Show", grpDisplay, "NoName" );

  showButtonGroup = new QButtonGroup( 0 );

  b = new QRadioButton( "Show All", grpShow );
  showButtonGroup->insert( b );
  b->setChecked( TRUE );
  connect( b, SIGNAL( clicked() ), this, SLOT( showAll() ) );

  b = new QRadioButton( "Show Visible", grpShow );
  showButtonGroup->insert( b );
  connect( b, SIGNAL( clicked() ), this, SLOT( showVisible() ) );

  b = new QRadioButton( "Show Hidden", grpShow );
  showButtonGroup->insert( b );
  connect( b, SIGNAL( clicked() ), this, SLOT( showHidden() ) );


  QGroupBox *actionGroup = new QGroupBox ( 1, Horizontal, "Actions", this, "NoName" );
  v->addWidget( actionGroup );

  QPushButton *pb;
  pb = new QPushButton( "Select None", actionGroup );
  connect( pb, SIGNAL( clicked() ), this, SLOT( selectNone() ) );
  //v->addWidget( pb );

  pb = new QPushButton( "Select All", actionGroup );
  connect( pb, SIGNAL( clicked() ), this, SLOT( selectAll() ) );
  //v->addWidget( pb );

  pb = new QPushButton( "Invert Selection", actionGroup );
  connect( pb, SIGNAL( clicked() ), this, SLOT( invertSelection() ) );
  //v->addWidget( pb );

  pb = new QPushButton( "Hide Selected", actionGroup );
  connect( pb, SIGNAL( clicked() ), this, SLOT( hideSelected() ) );
  //v->addWidget( pb );

  pb = new QPushButton( "Unhide Selected", actionGroup );
  connect( pb, SIGNAL( clicked() ), this, SLOT( unhideSelected() ) );
  //v->addWidget( pb );

  v->addStretch( 100 );

  ReloadList( TRUE );
  pb = new QPushButton( "Cancel", this );
  connect( pb, SIGNAL( clicked() ), SLOT( accept() ) );

  bottom->addWidget( pb );

  pb = new QPushButton( "Ok", this );
  connect( pb, SIGNAL( clicked() ), this, SLOT( ok() ) );
  bottom->addWidget( pb );
}


ObjectListSelector::~ObjectListSelector()
{}


void ObjectListSelector::sortAscending()
{
  sortType = SORT_ASCENDING;
  listBox->sort( TRUE );
  listBox->triggerUpdate( false );
}

void ObjectListSelector::sortDescending()
{
  sortType = SORT_DESCENDING;
  listBox->sort( FALSE );
  listBox->triggerUpdate( false );
}


void ObjectListSelector::sortOrderCreated()
{
  sortType = SORT_NONE;
  ReloadList();
  listBox->triggerUpdate( false );
}


void ObjectListSelector::selectNone()
{
  listBox->clearSelection();
}

void ObjectListSelector::selectAll()
{
  listBox->selectAll( true );
}

void ObjectListSelector::invertSelection()
{
  listBox->invertSelection();
}

void ObjectListSelector::toggleMultipleColumns()
{
  bMultipleColumns = !bMultipleColumns;

  if ( bMultipleColumns )
    listBox->setColumnMode( QListBox::FitToWidth );
  else
    listBox->setColumnMode( 1 );
}

//==============================================================================

void ObjectListSelector::ok()
{
  // ok, here we update what is selected
  ObjectDB::getInstance() ->setNoneSelected();

  for ( int index = 0;index < ( int ) listBox->count();index++ )
  {
    if ( listBox->isSelected( index ) )
    {

      ObjectListEntry * ole = dynamic_cast < ObjectListEntry* > ( listBox->item( index ) );

      assert( ole );

      ObjectDB::getInstance() ->setSelected( ole->_entity );
    }

  }

  accept();
}



void
ObjectListSelector::ReloadList( bool getSelection )
{
  // kts I am sure there is a better way to do this
  listBox->clear();

  int listIndex = 0;
  std::vector < Selectable * > *list;

  list = ObjectDB::getInstance() ->getList();
  assert( list );

  std::vector < Selectable * > * selected = ObjectDB::getInstance() ->getSelected();
  string name;

  for ( int i = 0; i < ( int ) list->size(); i++ )
  {

    Entity* m = ( Entity * ) ( *list ) [ i ];

    if ( ( showType == SHOW_ALL ) ||
         ( showType == SHOW_HIDDEN && ( !m->isVisible() ) ) ||
         ( showType == SHOW_VISIBLE && ( m->isVisible() ) )
       )
    {

      ObjectListEntry * ole = new ObjectListEntry( m );

      assert( ole );

      listBox->insertItem( ole, listIndex++ );

      if ( getSelection )
      {
        std::vector < Selectable* > ::iterator result = ::find( selected->begin(), selected->end(), m );

        if ( result != selected->end() )
          listBox->setSelected( ole, TRUE );
      }

    }

  }

  switch ( sortType )
  {

    case SORT_NONE:
      break;

    case SORT_ASCENDING:
      listBox->sort( TRUE );
      break;

    case SORT_DESCENDING:
      listBox->sort( TRUE );
      break;

    default:
      assert( 0 );
      break;
  }

  listBox->triggerUpdate( false );
}


void ObjectListSelector::showAll()
{
  showType = SHOW_ALL;
  ReloadList();
}

void ObjectListSelector::showHidden()
{
  showType = SHOW_HIDDEN;
  ReloadList();
}

void ObjectListSelector::showVisible()
{
  showType = SHOW_VISIBLE;
  ReloadList();
}



void ObjectListSelector::SetVisibility( bool visible )
{
  // loop through all list items and change the visibility of the ones which are selected
  for ( int index = 0;index < ( int ) listBox->count();index++ )
  {
    if ( listBox->isSelected( index ) )
    {

      ObjectListEntry * ole = dynamic_cast < ObjectListEntry* > ( listBox->item( index ) );

      assert( ole );

      ole->_entity->setVisible( visible );
    }

  }

  ReloadList();
}


// kts I don't know how to bind input parameters to slots,
// once I do I can get rid of stubs like these

void ObjectListSelector::hideSelected()
{
  SetVisibility( false );
}


void ObjectListSelector::unhideSelected()
{
  SetVisibility( true );
}

