/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

#pragma once

namespace iOpenCL
{

/*****************************************************************************\
ENUM: RESOURCE_ALLOCATION_TYPE
\*****************************************************************************/
enum RESOURCE_ALLOCATION_TYPE
{
    RESOURCE_ALLOCATION_LINEAR,
    RESOURCE_ALLOCATION_TILED_X,
    RESOURCE_ALLOCATION_TILED_Y,
    NUM_RESOURCE_ALLOCATION_TYPES
};

/*****************************************************************************\
ENUM: RESOURCE_MIPMAP_LAYOUT_MODE
\*****************************************************************************/
enum RESOURCE_MIPMAP_LAYOUT_MODE
{
    RESOURCE_MIPMAP_LAYOUT_BELOW,
    RESOURCE_MIPMAP_LAYOUT_RIGHT,
    NUM_RESOURCE_MIPMAP_LAYOUT_MODES
};

/*****************************************************************************\
ENUM: RESOURCE_SAMPLE_PATTERN
\*****************************************************************************/
enum RESOURCE_SAMPLE_PATTERN
{
    RESOURCE_SAMPLE_PATTERN_STANDARD,
    RESOURCE_SAMPLE_PATTERN_CENTER,
    NUM_RESOURCE_SAMPLE_PATTERNS
};

/*****************************************************************************\
ENUM: SURFACE_TYPE
\*****************************************************************************/
enum SURFACE_TYPE
{
    SURFACE_UNKNOWN        = 0,
    SURFACE_NULL           = 1,
    SURFACE_1D             = 2,
    SURFACE_1D_ARRAY       = 3,
    SURFACE_2D             = 4,
    SURFACE_2D_ARRAY       = 5,
    SURFACE_3D             = 6,
    SURFACE_CUBE           = 7,
    SURFACE_CUBE_ARRAY     = 8,
    SURFACE_CONSTANT       = 9,
    SURFACE_BUFFER         = 10,
    SURFACE_2D_MEDIA       = 11,
    SURFACE_2D_MEDIA_BLOCK = 12,
    NUM_SURFACE_TYPES
};

/*****************************************************************************\
ENUM: SURFACE_CUBE_FACE_ENABLES
\*****************************************************************************/
enum SURFACE_CUBE_FACE_ENABLES
{
    SURFACE_CUBE_FACE_ENABLE_NONE       = 0x00000000,
    SURFACE_CUBE_FACE_ENABLE_NEGATIVE_X = 0x00000001,
    SURFACE_CUBE_FACE_ENABLE_POSITIVE_X = 0x00000002,
    SURFACE_CUBE_FACE_ENABLE_NEGATIVE_Y = 0x00000004,
    SURFACE_CUBE_FACE_ENABLE_POSITIVE_Y = 0x00000008,
    SURFACE_CUBE_FACE_ENABLE_NEGATIVE_Z = 0x00000010,
    SURFACE_CUBE_FACE_ENABLE_POSITIVE_Z = 0x00000020,
    SURFACE_CUBE_FACE_ENABLE_ALL        = 0x0000003F,
};

/*****************************************************************************\
ENUM: SURFACE_FORMAT
\*****************************************************************************/
enum SURFACE_FORMAT
{
    SURFACE_FORMAT_UNKNOWN = 0,

    // RGB Formats
    SURFACE_FORMAT_R64G64B64A64_FLOAT,
    SURFACE_FORMAT_R64G64B64_FLOAT,
    SURFACE_FORMAT_R64G64_FLOAT,
    SURFACE_FORMAT_R64_FLOAT,

    SURFACE_FORMAT_R32G32B32A32_FLOAT,
    SURFACE_FORMAT_R32G32B32A32_SINT,
    SURFACE_FORMAT_R32G32B32A32_UINT,
    SURFACE_FORMAT_R32G32B32A32_UNORM,
    SURFACE_FORMAT_R32G32B32A32_SNORM,
    SURFACE_FORMAT_R32G32B32A32_USCALED,
    SURFACE_FORMAT_R32G32B32A32_SSCALED,

    SURFACE_FORMAT_R32G32B32X32_FLOAT,

    SURFACE_FORMAT_R32G32B32_FLOAT,
    SURFACE_FORMAT_R32G32B32_SINT,
    SURFACE_FORMAT_R32G32B32_UINT,
    SURFACE_FORMAT_R32G32B32_UNORM,
    SURFACE_FORMAT_R32G32B32_SNORM,
    SURFACE_FORMAT_R32G32B32_USCALED,
    SURFACE_FORMAT_R32G32B32_SSCALED,

    SURFACE_FORMAT_R32G32_FLOAT,
    SURFACE_FORMAT_R32G32_SINT,
    SURFACE_FORMAT_R32G32_UINT,
    SURFACE_FORMAT_R32G32_UNORM,
    SURFACE_FORMAT_R32G32_SNORM,
    SURFACE_FORMAT_R32G32_USCALED,
    SURFACE_FORMAT_R32G32_SSCALED,

    SURFACE_FORMAT_R32_FLOAT,
    SURFACE_FORMAT_R32_SINT,
    SURFACE_FORMAT_R32_UINT,
    SURFACE_FORMAT_R32_UNORM,
    SURFACE_FORMAT_R32_SNORM,
    SURFACE_FORMAT_R32_USCALED,
    SURFACE_FORMAT_R32_SSCALED,

    SURFACE_FORMAT_R32_FLOAT_X8X24_TYPELESS,
    SURFACE_FORMAT_X32_TYPELESS_G8X24_UINT,

    SURFACE_FORMAT_R24_UNORM_X8_TYPELESS,
    SURFACE_FORMAT_X24_TYPELESS_G8_UINT,

    SURFACE_FORMAT_R16G16B16A16_FLOAT,
    SURFACE_FORMAT_R16G16B16A16_SINT,
    SURFACE_FORMAT_R16G16B16A16_UINT,
    SURFACE_FORMAT_R16G16B16A16_UNORM,
    SURFACE_FORMAT_R16G16B16A16_SNORM,
    SURFACE_FORMAT_R16G16B16A16_USCALED,
    SURFACE_FORMAT_R16G16B16A16_SSCALED,

    SURFACE_FORMAT_R16G16B16X16_UNORM,
    SURFACE_FORMAT_R16G16B16X16_FLOAT,

    SURFACE_FORMAT_R16G16B16_UNORM,
    SURFACE_FORMAT_R16G16B16_SNORM,
    SURFACE_FORMAT_R16G16B16_USCALED,
    SURFACE_FORMAT_R16G16B16_SSCALED,

    SURFACE_FORMAT_R16G16_FLOAT,
    SURFACE_FORMAT_R16G16_SINT,
    SURFACE_FORMAT_R16G16_UINT,
    SURFACE_FORMAT_R16G16_UNORM,
    SURFACE_FORMAT_R16G16_SNORM,
    SURFACE_FORMAT_R16G16_USCALED,
    SURFACE_FORMAT_R16G16_SSCALED,

    SURFACE_FORMAT_R16_FLOAT,
    SURFACE_FORMAT_R16_SINT,
    SURFACE_FORMAT_R16_UINT,
    SURFACE_FORMAT_R16_UNORM,
    SURFACE_FORMAT_R16_SNORM,
    SURFACE_FORMAT_R16_USCALED,
    SURFACE_FORMAT_R16_SSCALED,

    SURFACE_FORMAT_R11G11B10_FLOAT,

    SURFACE_FORMAT_R10G10B10A2_UNORM,
    SURFACE_FORMAT_R10G10B10A2_UNORM_SRGB,
    SURFACE_FORMAT_R10G10B10A2_UINT,

    SURFACE_FORMAT_R10G10B10_SNORM_A2_UNORM,

    SURFACE_FORMAT_R10G10B10X2_USCALED,

    SURFACE_FORMAT_B10G10R10A2_UNORM,
    SURFACE_FORMAT_B10G10R10A2_UNORM_SRGB,

    SURFACE_FORMAT_B10G10R10X2_UNORM,

    SURFACE_FORMAT_R9G9B9E5_SHAREDEXP,

    SURFACE_FORMAT_R8G8B8A8_SINT,
    SURFACE_FORMAT_R8G8B8A8_UINT,
    SURFACE_FORMAT_R8G8B8A8_UNORM,
    SURFACE_FORMAT_R8G8B8A8_UNORM_SRGB,
    SURFACE_FORMAT_R8G8B8A8_SNORM,
    SURFACE_FORMAT_R8G8B8A8_USCALED,
    SURFACE_FORMAT_R8G8B8A8_SSCALED,

    SURFACE_FORMAT_R8G8B8X8_UNORM,
    SURFACE_FORMAT_R8G8B8X8_UNORM_SRGB,

    SURFACE_FORMAT_R8G8_SNORM_B8X8_UNORM,

    SURFACE_FORMAT_B8G8R8A8_UNORM,
    SURFACE_FORMAT_B8G8R8A8_UNORM_SRGB,

    SURFACE_FORMAT_B8G8R8X8_UNORM,
    SURFACE_FORMAT_B8G8R8X8_UNORM_SRGB,

    SURFACE_FORMAT_R8G8B8_UNORM,
    SURFACE_FORMAT_R8G8B8_SNORM,
    SURFACE_FORMAT_R8G8B8_USCALED,
    SURFACE_FORMAT_R8G8B8_SSCALED,

    SURFACE_FORMAT_R8G8_SINT,
    SURFACE_FORMAT_R8G8_UINT,
    SURFACE_FORMAT_R8G8_UNORM,
    SURFACE_FORMAT_R8G8_SNORM,
    SURFACE_FORMAT_R8G8_USCALED,
    SURFACE_FORMAT_R8G8_SSCALED,

    SURFACE_FORMAT_R8_SINT,
    SURFACE_FORMAT_R8_UINT,
    SURFACE_FORMAT_R8_UNORM,
    SURFACE_FORMAT_R8_SNORM,
    SURFACE_FORMAT_R8_USCALED,
    SURFACE_FORMAT_R8_SSCALED,

    SURFACE_FORMAT_B5G6R5_UNORM,
    SURFACE_FORMAT_B5G6R5_UNORM_SRGB,

    SURFACE_FORMAT_B5G5R5A1_UNORM,
    SURFACE_FORMAT_B5G5R5A1_UNORM_SRGB,

    SURFACE_FORMAT_B5G5R5X1_UNORM,
    SURFACE_FORMAT_B5G5R5X1_UNORM_SRGB,

    SURFACE_FORMAT_R5G5_SNORM_B6_UNORM,

    SURFACE_FORMAT_B4G4R4A4_UNORM,
    SURFACE_FORMAT_B4G4R4A4_UNORM_SRGB,

    SURFACE_FORMAT_R1_UNORM,
    SURFACE_FORMAT_R1_UINT,

    // Luminance Formats
    SURFACE_FORMAT_I32X32_FLOAT,
    SURFACE_FORMAT_L32A32_FLOAT,
    SURFACE_FORMAT_L32X32_FLOAT,
    SURFACE_FORMAT_A32X32_FLOAT,

    SURFACE_FORMAT_I24X8_UNORM,
    SURFACE_FORMAT_L24X8_UNORM,
    SURFACE_FORMAT_A24X8_UNORM,

    SURFACE_FORMAT_I32_FLOAT,
    SURFACE_FORMAT_L32_FLOAT,
    SURFACE_FORMAT_A32_FLOAT,

    SURFACE_FORMAT_L16A16_FLOAT,
    SURFACE_FORMAT_L16A16_UNORM,

    SURFACE_FORMAT_I16_FLOAT,
    SURFACE_FORMAT_I16_UNORM,
    SURFACE_FORMAT_L16_FLOAT,
    SURFACE_FORMAT_L16_UNORM,
    SURFACE_FORMAT_A16_FLOAT,
    SURFACE_FORMAT_A16_UNORM,

    SURFACE_FORMAT_L8A8_UNORM,
    SURFACE_FORMAT_L8A8_UNORM_SRGB,

    SURFACE_FORMAT_I8_UNORM,
    SURFACE_FORMAT_L8_UNORM,
    SURFACE_FORMAT_L8_UNORM_SRGB,
    SURFACE_FORMAT_A8_UNORM,

    // Paletted Formats
    SURFACE_FORMAT_P4A4_UNORM,
    SURFACE_FORMAT_A4P4_UNORM,
    SURFACE_FORMAT_P8_UNORM,
    SURFACE_FORMAT_P2_UNORM,

    // Compressed Formats
    SURFACE_FORMAT_BC1_UNORM,
    SURFACE_FORMAT_BC2_UNORM,
    SURFACE_FORMAT_BC3_UNORM,
    SURFACE_FORMAT_BC4_UNORM,
    SURFACE_FORMAT_BC5_UNORM,
    SURFACE_FORMAT_BC1_UNORM_SRGB,
    SURFACE_FORMAT_BC2_UNORM_SRGB,
    SURFACE_FORMAT_BC3_UNORM_SRGB,
    SURFACE_FORMAT_BC4_SNORM,
    SURFACE_FORMAT_BC5_SNORM,

    SURFACE_FORMAT_DXT1_RGB,
    SURFACE_FORMAT_DXT1_RGB_SRGB,
    SURFACE_FORMAT_FXT1,

    // YUV Formats
    SURFACE_FORMAT_YCRCB_NORMAL,
    SURFACE_FORMAT_YCRCB_SWAPUVY,
    SURFACE_FORMAT_YCRCB_SWAPUV,
    SURFACE_FORMAT_YCRCB_SWAPY,

    SURFACE_FORMAT_PLANAR_Y,
    SURFACE_FORMAT_PLANAR_U,
    SURFACE_FORMAT_PLANAR_V,
    SURFACE_FORMAT_PLANAR_UV,

    // Raw
    SURFACE_FORMAT_RAW,

    NUM_SURFACE_FORMATS
};

} // namespace iCBE