/*  Simple toggle button example.
 *
 *  button.h
 *
 *  Inti Translation of the GtkGLExt toggle button example written
 *  by Naofumi Yasufuku <naofumi@users.sourceforge.net>.
 */

#include <inti/main.h>
#include <inti/core.h>
#include <inti/gtk/togglebutton.h>
#include <inti/gdk/gl/config.h>
#include <inti/gtk/gl/drawingarea.h>

using namespace Inti;

/*  GLDrawingArea
 */

class GLDrawingArea : public Gtk::GL::DrawingArea
{
	bool animate;
	float angle;
	float pos_y;

	Connection timeout_connection;

protected:
	virtual void on_realize();
	virtual bool on_configure_event(const Gdk::EventConfigure& event);
	virtual bool on_expose_event(const Gdk::EventExpose& event);
	virtual bool on_map_event(const Gdk::EventAny& event);
	virtual bool on_unmap_event(const Gdk::EventAny& event);
	virtual bool on_visibility_notify_event(const Gdk::EventVisibility& event);
	virtual void on_unrealize();

	bool on_timeout();

public:
	GLDrawingArea(Gdk::GL::Config *glconfig);
	virtual ~GLDrawingArea();

	void timeout_connect();
	void timeout_disconnect();

	void on_toggle_animation();
};

/*  GLToggleButton
 */

class GLToggleButton : public Gtk::ToggleButton
{
public:
	GLToggleButton(Gdk::GL::Config *glconfig);
	virtual ~GLToggleButton();
};

/* Window
 */

class Window : public Gtk::Window
{
public:
	Window(Gdk::GL::Config *glconfig);
	virtual ~Window();
};

