/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  shapes.h - C++ wrapper implementation for the Open-GL shape functions.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "shapes.h"

using namespace Inti;

/*  Gdk::GL::draw_cube
 */

void
Gdk::GL::draw_cube(bool solid, double   size)
{
	gdk_gl_draw_cube(solid, size);
}

/*  Gdk::GL::draw_sphere
 */

void
Gdk::GL::draw_sphere(bool solid, double radius, int slices, int stacks)
{
	gdk_gl_draw_sphere(solid, radius, slices, stacks);
}

/*  Gdk::GL::draw_cone
 */

void
Gdk::GL::draw_cone(bool solid, double base, double height, int slices, int stacks)
{
	gdk_gl_draw_cone(solid, base, height, slices, stacks);
}

/*  Gdk::GL::draw_torus
 */

void
Gdk::GL::draw_torus(bool solid, double inner_radius, double outer_radius, int nsides, int rings)
{
	gdk_gl_draw_torus(solid, inner_radius, outer_radius, nsides, rings);
}

/*  Gdk::GL::draw_tetrahedron
 */

void
Gdk::GL::draw_tetrahedron(bool solid)
{
	gdk_gl_draw_tetrahedron(solid);
}

/*  Gdk::GL::draw_octahedron
 */

void
Gdk::GL::draw_octahedron(bool solid)
{
	gdk_gl_draw_octahedron(solid);
}

/*  Gdk::GL::draw_dodecahedron
 */

void
Gdk::GL::draw_dodecahedron(bool solid)
{
	gdk_gl_draw_dodecahedron(solid);
}

/*  Gdk::GL::draw_icosahedron
 */

void
Gdk::GL::draw_icosahedron(bool solid)
{
	gdk_gl_draw_icosahedron(solid);
}

/*  Gdk::GL::draw_teapot
 */

void
Gdk::GL::draw_teapot(bool solid, double scale)
{
	gdk_gl_draw_teapot(solid, scale);
}

