#include <inti/main.h>
#include <inti/core.h>
#include <inti/gtk/itemfactory.h>
#include <inti/gtk/label.h>
#include <inti/gtk-sourceview/sourceview.h>
#include <inti/gtk-sourceview/sourceprintjob.h>

using namespace Inti;

/*  SourceView
 */

class SourceView : public Gtk::SourceView
{
protected:
	virtual bool on_button_press_event(const Gdk::EventButton& event);

public:
	SourceView(Gtk::SourceBuffer& buffer);
	virtual ~SourceView();
};

/*  MainWindow
 */

class MainWindow : public Gtk::Window
{
	std::vector<Gtk::SourceView*> views_list;

	Pointer<Gtk::SourceLanguagesManager> manager;
	Pointer<Gtk::SourceBuffer> buffer;
	Pointer<Gtk::ItemFactory> item_factory;

	Gtk::Label *pos_label;
	SourceView *source_view;

	String current_file;

protected:
	bool on_view_delete_event(GdkEventAny *event, SourceView *view);
	void on_move_cursor(const GtkTextIter *cursoriter, GtkTextMark *mark);
	void on_update_cursor_position();

public:
	MainWindow();
	virtual ~MainWindow();

	bool open_file(const String& filename);

	void print_job_begin_page(Gtk::SourcePrintJob *job);
	void print_job_finished(Gtk::SourcePrintJob *job);

	void on_file_open();
	void on_file_print_preview();
	void on_file_quit();
	void on_view_new();
	void on_view_show_line_numbers();
	void on_view_show_markers();
	void on_show_margin();
	void on_view_enable_auto_indent();
	void on_view_insert_spaces();
	void on_view_tabs_width_4();
	void on_view_tabs_width_6();
	void on_view_tabs_width_8();
	void on_view_tabs_width_10();
	void on_view_tabs_width_12();

	DECLARE_ITEM_FACTORY_MAP(MainWindow)
};

