/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _GNU_SOURCE
#include <Elementary.h>
#include <stdio.h>
#include <fcntl.h>
#include <pthread.h>
#include <string.h>
#include "dbus-stuff.h"
#include "gui.h"

//globals
//dynamic Arrays: song_list, pl_data, path_songs - based on no_songs in a playlist
int fd, no_songs = 0, song_index = 0, vol = 80, sys_vol = 0, treble=0, bass=0, priority=0, pid=0, version=0;
int pos_time = 0, seek = 0, song_dur = 0, loop = 0, finger = 0, randomize= 0, *seq, bt = 0, pl_info=0;
int play_state = IDLE, PHONE = 0, next_song_random = 0;
char cur_playlist[255], (*path_songs)[255]=NULL, cur_song[255], cur_artist[255], songs_dir[255], order_by[255];
Elm_Genlist_Item *song_list[10000], *old_song;
Ecore_Timer *timer1 = NULL, *scan_timer = NULL;
pthread_t thread_id, t_id;
FILE *mp_data;
_dir dir_gl_entry[255];
_dir *pl_data;
_str2 name_path[255];

static void
my_win_del(void *data, Evas_Object *obj, void *event_info)
{
	int ret;
	ssize_t read = 0;
	size_t len = 0;
	char *ans = "";

	//free dynamic arrays
	free(path_songs);
	//free(song_list);
	free(pl_data);
	//tell mplayer to quit
	ret = write(fd, "quit 1\n", 7);
	while(strncmp(ans, "Exiting", 7) != 0) {
		read = getline(&ans, &len, mp_data);
	}
	save_state();
	close(fd);
	fclose(mp_data);
	//unlink the fifo files
	unlink("/tmp/intone-mplayer");
	unlink("/tmp/mplayer-intone");	
	sqlite3_close(songs);
	if (bt)bluetooth_off();
	release_cpu ();
	//restore alsa state
	ret = system("alsactl -f /usr/share/shr/scenarii/stereoout.state restore");
	elm_exit();
}

void start_mplayer(void)
{
	int ret;
	char tmpstr[PATH_MAX];

	sprintf(tmpstr, "mplayer -idle -quiet -slave -msglevel global=6 -input file=/tmp/intone-mplayer 1>/tmp/mplayer-intone");
	ret = system(tmpstr);
}

void start_mplayer_bt(void)
{
	int ret;
	char tmpstr[PATH_MAX];
	
	sprintf(tmpstr, "mplayer -ao alsa:device=bluetooth -idle -quiet -slave -msglevel global=6 -input file=/tmp/intone-mplayer 1>/tmp/mplayer-intone 2>&1");
	ret = system(tmpstr);
}

void dbus_stuff(void)
{
	//prevent suspend
	occupy_cpu();
	//set up listener for incoming calls
	incoming_call_listener();
}

EAPI int
elm_main(int argc, char **argv)
{
	int ret;
	char buf[255], line[10], *ans;
	FILE *fp;
	//struct stat sts;

	//check for mplayer and exit if not present
	//if(stat("/usr/bin/mplayer", &sts) == -1 && ENOENT) {
		//printf ("Please install mplayer");
		//exit(1);
	//}
	//restore state
	//printf("restoring state\n");
	restore_state();
	//adjust finger size
	if(finger == SMALL) elm_finger_size_set(60); 
	//load snd-pcm-oss
	ret = system("modprobe snd-pcm-oss");
	//TODO : auto rescan the media directory on changes

	//printf("creating window\n");
	//set up win
	win = elm_win_add(NULL, "intone", ELM_WIN_BASIC);
	if (strcmp(cur_playlist, "ty_playlist") == 0) strcpy(buf, "Selected Songs");
	else if (strcmp(cur_playlist, "0 All Songs") == 0) strcpy(buf, "All Songs");
	else strcpy(buf, cur_playlist);
	elm_win_title_set(win, buf);
	evas_object_smart_callback_add(win, "delete-request", my_win_del, NULL);
	//show the window
	create_gui(win);
	evas_object_show(win);

	//create a fifo file for sending commands to mplayer
	mkfifo("/tmp/intone-mplayer", S_IRUSR| S_IWUSR | O_NONBLOCK);
	//create a fifo file for reading mplayer output
	mkfifo("/tmp/mplayer-intone", S_IRUSR| S_IWUSR | O_NONBLOCK);
	//printf("starting mplayer\n");
	//create mplayer thread
	if (!bt) ret = pthread_create(&thread_id, NULL, (void *)start_mplayer, NULL);
	else ret = pthread_create(&thread_id, NULL, (void *)start_mplayer_bt, NULL);
	//open fifo read only
	mp_data = fopen("/tmp/mplayer-intone", "r");
	//open fifo write only
	fd = open("/tmp/intone-mplayer", O_WRONLY, 0666);
	//get the pid value of mplayer
	fp = popen("pidof mplayer", "r");
	ans = fgets(line, sizeof line, fp);
	pclose(fp);
	pid = atoi(line);
	//renice mplayer
	sprintf(buf, "renice %d %d\n", priority, pid);
	ret = system(buf);
	printf("init dbus\n");
	//start the dbus thread
	ret = pthread_create(&t_id, NULL, (void *)dbus_stuff, NULL);
	
	elm_run();
	ecore_main_loop_quit();
	elm_shutdown();
	return 0;
}
ELM_MAIN()
