-- wsname.lua
--
-- Author: Etan Reisner <deryni@eden.rutgers.edu>
-- Version: 0.5
--
-- Shows the current workspace name in the statusbar, optionally shows all the
-- workspace names with the current one marked off.
--
-- Usage:
-- Add %wsname (or %wsfull) to your statusbar template.
--
-- For multiple head setups with multiple statusbars,
-- use %wsname_{screennum} in your template (%wsname is the same as %wsname_0).
--
-- The %wsfull_all meter shows a combined %wsfull display for all screens.

if not mod_statusbar then
    return
end

local defaults = {
    marker = "*",
    template = "xxxxxxxxx",
    all_marker = " - ",
}

local wsname = table.join(wsname or {}, defaults)

local function get_ws_name(t)
    local reg = t["reg"]

    if obj_is(reg, "WScreen") then
	local ws_names_all = nil
	local scrlist = ioncore.region_list("WScreen")

	for k,v in pairs(scrlist) do
	    if #v:llist(1) == 0 then
		return
	    end

	    local ws_names = nil
	    local ws_names = nil
	    local screennum = v:id()

	    local function compose_ws_names(k1, ws)
		local marker = ""
		if ws == v:lcurrent(1) then
		    marker = wsname.marker
		end
		if not ws_names then
		    ws_names = marker..ws:name()..marker
		else
		    ws_names = ws_names.." "..marker..ws:name()..marker
		end
	    end

	    table.foreach(v:llist(1), compose_ws_names)

	    mod_statusbar.inform("wsname_"..screennum, v:lcurrent(1):name())
	    mod_statusbar.inform("wsfull_"..screennum, ws_names)
	    mod_statusbar.inform("wsfull_"..screennum.."_template",
	                         string.len(ws_names))

	    if screennum == 0 then
	        mod_statusbar.inform("wsname", v:lcurrent(1):name())
	        mod_statusbar.inform("wsfull", ws_names)
	        mod_statusbar.inform("wsfull_template",
	                             string.len(ws_names))
	    end

	    if not ws_names_all then
		ws_names_all = ws_names
	    else
		ws_names_all = ws_names_all..wsname.all_marker..ws_names
	    end
	end

	mod_statusbar.inform("wsfull_all", ws_names_all)
	mod_statusbar.inform("wsfull_all_template", string.len(ws_names_all))

	ioncore.defer(function() mod_statusbar.update() end)
    end
end

local function setup_hooks()
    local hook

    hook = ioncore.get_hook("screen_managed_changed_hook")
    if hook then
	hook:add(get_ws_name)
    end
end

-- Init
setup_hooks()

mod_statusbar.inform("wsname_template", wsname.template)
for k,v in pairs(ioncore.region_list("WScreen")) do
    local template

    if wsname[v:id()] and wsname[v:id()].template then
	template = wsname[v:id()].template
    else
	template = wsname.template
    end

    mod_statusbar.inform("wsname_"..v:id().."_template", template)
end

mod_statusbar.update(true)
