/*
 * libtu/symlist.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2004. 
 *
 * You may distribute and modify this library under the terms of either
 * the Clarified Artistic License or the GNU LGPL, version 2.1 or later.
 */

#ifndef LIBTU_SYMLIST_H
#define LIBTU_SYMLIST_H

#include "types.h"
#include "obj.h"


INTRSTRUCT(Symlist);


DECLSTRUCT(Symlist){
    void *symbol;
    Symlist *next, *prev;
};


#define ITERATE_SYMLIST(TYPE, VAR, LIST)     \
    for((VAR)=(TYPE)symlist_init_iter(LIST); \
        (VAR)!=NULL;                         \
        (VAR)=(TYPE)symlist_iter())


bool symlist_insert(Symlist **symlist, void *symbol);
void symlist_remove(Symlist **symlist, void *symbol);
void symlist_clear(Symlist **symlist);
void *symlist_init_iter(Symlist *symlist);
void *symlist_iter();

#endif /* LIBTU_SYMLIST_H */
