/*
 * libtu/symlist.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2004. 
 *
 * You may distribute and modify this library under the terms of either
 * the Clarified Artistic License or the GNU LGPL, version 2.1 or later.
 */

#include "obj.h"
#include "symlist.h"
#include "types.h"
#include "dlist.h"
#include "misc.h"


static void free_node(Symlist **symlist, Symlist *node)
{
    UNLINK_ITEM(*symlist, node, next, prev);
    free(node);
}


bool symlist_insert(Symlist **symlist, void *symbol)
{
    Symlist *node;
    
    if(symbol==NULL)
        return FALSE;
    
    node=ALLOC(Symlist);
    
    if(node==NULL)
        return FALSE;
        
    node->symbol=symbol;
    
    LINK_ITEM_FIRST(*symlist, node, next, prev);
    
    return TRUE;
}


void symlist_remove(Symlist **symlist, void *symbol)
{
    Symlist *node=*symlist;
    
    while(node!=NULL){
        if(node->symbol==symbol){
            free_node(symlist, node);
            return;
        }
        node=node->next;
    }
}


void symlist_clear(Symlist **symlist)
{
    while(*symlist!=NULL)
        free_node(symlist, *symlist);
}


/* Warning: not thread-safe */


static Symlist *iter_next=NULL;


void *symlist_init_iter(Symlist *symlist)
{
    if(symlist==NULL){
        iter_next=NULL;
        return NULL;
    }
    
    iter_next=symlist->next;
    return symlist->symbol;
}


void *symlist_iter()
{
    Symlist *ret;
    
    if(iter_next==NULL)
        return NULL;
    
    ret=iter_next;
    iter_next=iter_next->next;
    
    return ret->symbol;
}

