
use POSIX qw(strftime);
use POSIX qw(mktime);


sub getMonthFromStamp {
	my $myTimeStamp = shift(@_);	
	return strftime("%Y_%m", localtime($myTimeStamp));
}


sub getTodaysFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 0, 0, 0, $day, $month, $year);
}
sub getTodaysLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 59, 59, 23, $day, $month, $year);
}

sub getYesterdaysFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 0, 0, 0, $day-1, $month, $year);
}
sub getYesterdaysLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 59, 59, 23, $day-1, $month, $year);
}

sub getThisWeeksFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return &getSomeWeeksFirstStamp(mktime( 0, 0, 0, $day, $month, $year));
}
sub getThisWeeksLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return &getSomeWeeksLastStamp(mktime( 0, 0, 0, $day, $month, $year));
}


sub getLastWeeksFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return &getSomeWeeksFirstStamp(mktime( 0, 0, 0, $day - 7, $month, $year));
}
sub getLastWeeksLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return &getSomeWeeksLastStamp(mktime( 0, 0, 0, $day - 7, $month, $year));
}

sub getThisMonthsFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 0, 0, 0, 1, $month, $year);
}
sub getThisMonthsLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 59, 59, 23, -1, $month + 1, $year);
}
	
sub getLastMonthsFirstStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 0, 0, 0, 1, $month - 1, $year);
}
sub getLastMonthsLastStamp {
	my ($sec,$min,$hour,$day,$month,$year,undef,undef,undef) = localtime();
	return mktime( 59, 59, 23, -1, $month, $year);
}


sub getSomeWeeksLastStamp {
	my $myTimeStamp = shift(@_);
	
	my $week = strftime("%V", localtime($myTimeStamp));
	
	
	while($week eq strftime("%V", localtime($myTimeStamp))) {
	        $myTimeStamp += 3600*12;
	}
	
	#  0    1    2     3     4    5     6     7     8
	#($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) 
	my @tmpStamp = localtime($myTimeStamp);
	return mktime(-1,0,0,$tmpStamp[3],$tmpStamp[4],$tmpStamp[5]);
}


sub getSomeWeeksFirstStamp {
	my $myTimeStamp = shift(@_);
	
	my $week = strftime("%V", localtime($myTimeStamp));
	
	
	while($week eq strftime("%V", localtime($myTimeStamp))) {
	        $myTimeStamp -= 3600*12;
	}
	
	#  0    1    2     3     4    5     6     7     8
	#($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) 
	my @tmpStamp = localtime($myTimeStamp);
	return mktime(0,0,0,$tmpStamp[3] + 1,$tmpStamp[4],$tmpStamp[5]);
}

1;