// --------------------------------------------------------------------
// Utilities for clients of Xpdflib
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipepdflib_p.h"

static bool xpdflib_initialized = false;

void InitXpdfLib()
{
  if (!xpdflib_initialized) {
    globalParams = new GlobalParams(0);
  }
  xpdflib_initialized = true;
}

IpeString PdfObject::String()
{
  switch (iObject.getType()) {
  case objInt: {
    IpeString res;
    IpeStringStream stream(res);
    stream << iObject.getInt();
    return res;
  }
  case objReal: {
    IpeString res;
    IpeStringStream stream(res);
    stream << iObject.getReal();
    return res;
  }
  case objName:
    return IpeString("/") + iObject.getName();
  case objString:
    return IpeString("(") + iObject.getString()->getCString() + ")";
  case objArray: {
    IpeString res = "[ ";
    for (int i = 0; i < iObject.arrayGetLength(); i++) {
      PdfObject elem;
      iObject.arrayGet(i, &elem);
      res += elem.String() + " ";
    }
    res += "]";
    return res;
  }
  case objDict: {
    IpeString res = "<< ";
    for (int i = 0; i < iObject.dictGetLength(); i++) {
      res += IpeString("/") + iObject.dictGetKey(i) + " ";
      PdfObject elem;
      iObject.dictGetVal(i, &elem);
      res += elem.String() + " ";
    }
    res += ">>";
    return res;
  }
  default:
    return IpeString();
  }
}

