// -*- C++ -*-
// --------------------------------------------------------------------
// Loading IML stream (and objects) from PDF file
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEPDFLOADER_H
#define IPEPDFLOADER_H

#include "ipebase.h"
#include "ipexml.h"
#include "ipepdflib_p.h"

#include <qstring.h>

class PDFDoc;

// --------------------------------------------------------------------

class IpePdfLoader : public IpeXmlDataSource {
public:
  IpePdfLoader(QString fname);
  virtual ~IpePdfLoader();
  bool IsOk() const;

  //! Has this file been created by Ipe?
  bool IsIpeFile() const { return iIpeStream >= 0; }

  // From MIpeXmlDataSource
  virtual int GetChar();
private:
  PDFDoc *iDoc;
  int iIpeStream;
  PdfObject iStreamObj;

  friend class IpePdfParser;
};

class IpePdfParser : public IpeImlParser {
public:
  explicit IpePdfParser(IpePdfLoader &loader, IpeRepository *rep);
  virtual IpeString PdfStream(int objNum);
private:
  XRef *iXRef;
};

// --------------------------------------------------------------------
#endif
