// -*- C++ -*-
// --------------------------------------------------------------------
// XmlOutputDev.h
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef XMLOUTPUTDEV_H
#define XMLOUTPUTDEV_H

#include <stddef.h>
#include "object.h"
#include "outputdev.h"

class GfxPath;
class GfxFont;

#define PDFTOIPE_VERSION "2004/05/02"

class XmlOutputDev: public OutputDev
{
public:

  // Open an XML output file, and write the prolog.
  XmlOutputDev(char *fileName, XRef *xrefA, Catalog *catalog,
	       int firstPage, int lastPage, GBool isMath);

  // Destructor -- writes the trailer and closes the file.
  virtual ~XmlOutputDev();

  // Check if file was successfully created.
  virtual GBool isOk() { return ok; }

  //---- get info about output device

  // Does this device use upside-down coordinates?
  // (Upside-down means (0,0) is the top left corner of the page.)
  virtual GBool upsideDown() { return gFalse; }

  // Does this device use drawChar() or drawString()?
  virtual GBool useDrawChar() { return gTrue; }

  // Does this device use beginType3Char/endType3Char?  Otherwise,
  // text in Type 3 fonts will be drawn with drawChar/drawString.
  virtual GBool interpretType3Chars() { return gFalse; }

  //----- initialization and control

  // Start a page.
  virtual void startPage(int pageNum, GfxState *state);

  // End a page.
  virtual void endPage();

  //----- update graphics state
  virtual void updateTextPos(GfxState *state);

  //----- path painting
  virtual void stroke(GfxState *state);
  virtual void fill(GfxState *state);
  virtual void eoFill(GfxState *state);

  //----- text drawing
  virtual void drawChar(GfxState *state, double x, double y,
			double dx, double dy,
			double originX, double originY,
			CharCode c, Unicode *u, int uLen);

  //----- image drawing
  virtual void drawImageMask(GfxState *state, Object *ref, Stream *str,
			     int width, int height, GBool invert,
			     GBool inlineImg);
  virtual void drawImage(GfxState *state, Object *ref, Stream *str,
			 int width, int height, GfxImageColorMap *colorMap,
			 int *maskColors, GBool inlineImg);

private:
  void doPath(GfxState *state);
  void finishText();
  void writePSChar(int code);
  void writePS(char *s);
  void writePSFmt(const char *fmt, ...);

 private:
  OCFILE *outputStream;
  int seqPage;			// current sequential page number
  XRef *xref;			// the xref table for this PDF file
  GBool ok;			// set up ok?
  bool iIsMath;                 // make text objects math formulas
  bool inText;                  // inside a text object
};

// --------------------------------------------------------------------
#endif
