// -*- C++ -*-
// --------------------------------------------------------------------
// Overlay for creating IpeText objects
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPECREATETEXT_H
#define IPECREATETEXT_H

#include "ipetext.h"

#include "ipeoverlay.h"
#include "ipedlgtext.h"

// --------------------------------------------------------------------

class IpeDialogCreateText : public IpeDlgCreateText {
  Q_OBJECT
public:
  IpeDialogCreateText(QWidget* parent, QString caption,
		      QString label, QString &data);
public slots:
  virtual void UpdateData();
  virtual void FlushLeft();
private:
  QString &iData;
};

// --------------------------------------------------------------------

class IpeCreateText : public IpeOverlay {
 public:
  enum TMode { ELabel, EMath, EMinipage };

  static void New(QMouseEvent *ev, IpeCanvas *canvas,
		  IpeOverlayServices *services,
		  TMode mode, IpeRect *rect = 0, const char *init = 0);
  static bool Edit(IpeText *obj, const IpeStyleSheet *sheet);

  IpeCreateText(QMouseEvent *ev, IpeCanvas *canvas, IpeOverlayServices *services);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);

 private:
  IpeOverlayServices *iServices;
  IpeVector iV[2];
};

// --------------------------------------------------------------------

class IpeTextWidthChanger : public IpeOverlay {
 public:
  IpeTextWidthChanger(IpeCanvas *canvas, IpeText *text);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseRelease(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);

 private:
  IpeText *iObj;
  IpeVector iV[2];
  bool iDragging;
  IpeVector iMouseDown;
};

// --------------------------------------------------------------------
#endif
