// -*- C++ -*-
//---------------------------------------------------------------------
// Ipe preference settings
//---------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef PREFS_H
#define PREFS_H

#include "ipebase.h"
#include "ipegeo.h"

#include <QObject>
#include <QString>
#include <QStringList>

// --------------------------------------------------------------------

class IpePreferences : public QObject {
  Q_OBJECT
public:

  enum TExportMode { ENoAutoExport, EExportXmlToEps, EExportXmlToPdf,
		     EExportXmlToEpsAndPdf, EExportEpsToPdf,
		     EExportPdfToEps };

  static IpePreferences *Static();

  IpePreferences();
  bool Save();
  IpeBuffer StandardFont(IpeString name);

signals:
  void Changed();

private:
  void FindStandardFonts();
public:
  int iCompressLevel;  //!< PDF file compression level 0..9
  int iSelectDistance; //!< Distance within which objects can be selected
  int iSnapDistance;   //!< Distance within which objects act magnetic
  bool iRightMouseSelects;  //!< Right mouse button should select.
  bool iWhitePaper;    //!< Display paper in white
  bool iTransformable; //!< Text is transformable by default.
  bool iAntiAlias;
  bool iGridVisible;   //!< Is grid visible on startup?
  bool iMaximize;      //!< Maximize window on startup?
  IpeVector iMedia;    //!< Default media size.
  int iGridSize;       //!< Default grid size.
  QString iStyleSheet; //!< Default style sheet (or null if none).
  QString iStyleSheet2; //!< Another style sheet to add.
  TExportMode iAutoExport; //!< The auto-export mode.
  bool iExportExist;    //!< Auto-export only if file exists.
  QString iFont;        //!< Font used in text editor
  int iBitmapSize;     //!< Low-resolution bitmap size for screen
  QString iLatexDir;   //!< Directory where Pdflatex is run
  QString iDocDir;     //!< Ipe manual location
  QString iFontmap;    //!< Fontmap file
  QString iLangDir;    //!< Localization files
  QString iPdfLatex;   //!< Path to Pdflatex executable
  IpeString iTexInputs; //!< TEXINPUTS setting when Ipe is started
  QStringList iIpeletPath; //!< Ipelet search path
  QString iPrefsFileName;  //!< Filename of \c iperc file.
  QString iStdKeysFileName; //!< Filename of default \c ipekeys.xml file.
  QString iKeysFileName;   //!< Filename of personal \c ipekeys.xml file.
  QString iBrowser;    //! Path to HTML browser.
  QString iLanguage;   //! Localization file
  bool iMikTeX;        //! Does this system use MikTeX?
  QString iDialogDir;  //! Directory for loading/saving files
private:
  static IpePreferences *This;
  QString iStandardFont[14];
  IpeBuffer iStandardFontBuffer[14];
};

// --------------------------------------------------------------------
#endif
