// -*- C++ -*-
// --------------------------------------------------------------------
// Overlay for creating IpeArc objects
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPECREATEARC_H
#define IPECREATEARC_H

#include "ipepath.h"
#include "ipeoverlay.h"

// --------------------------------------------------------------------

class IpeCreateCircle : public IpeOverlay {
 public:
  enum TMode { ECenterRadius, EDiameter, E3Points };

  IpeCreateCircle(QMouseEvent *ev, IpeCanvas *canvas,
		  IpeOverlayServices *services,
		  TMode mode);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);

 private:
  IpePath Create() const;
 private:
  IpeOverlayServices *iServices;
  TMode iMode;
  IpeVector iV[3];
  int iCur;
};

// --------------------------------------------------------------------

class IpeCreateArc : public IpeOverlay {
 public:
  enum TMode { ECenterRightLeft, ECenterLeftRight, E3Points };

  IpeCreateArc(QMouseEvent *ev, IpeCanvas *canvas,
	       IpeOverlayServices *services, TMode mode);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);

 private:
  IpePath Create() const;
 private:
  IpeOverlayServices *iServices;
  TMode iMode;
  IpeVector iV[3];
  int iCur;
};

// --------------------------------------------------------------------
#endif
