// -*- C++ -*-
// --------------------------------------------------------------------
// Dialogs
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include "ipedoc.h"
#include "ipeprefs.h"
#include "ipepage.h"

#include "ui_dlgdocprop.h"
#include "ui_dlgpref.h"
#include "ui_dlgdirprefs.h"
#include "ui_dlgeffects.h"
#include "ui_dlgpage.h"
#include "ui_dlglatexerr.h"

#include <QStringList>

// --------------------------------------------------------------------

class DialogDocumentProperties : public QDialog, Ui::DlgDocumentProperties {
  Q_OBJECT
public:
  DialogDocumentProperties(QWidget* parent, IpeDocument::SProperties &data,
			   const IpeStyleSheet *sheet);
public slots:
  void UpdateData();
  void ShowHelp();

private:
  IpeDocument::SProperties &iData;
  const IpeStyleSheet *iSheet;
};

// --------------------------------------------------------------------

class DialogDirPreferences : public QDialog, Ui::DlgDirectories {
  Q_OBJECT

public:
  DialogDirPreferences(QWidget* parent, IpePreferences &data);

public slots:
  void ShowHelp();

private:
  IpePreferences &iData;
};

// --------------------------------------------------------------------

class DialogPreferences : public QDialog, Ui::DlgPreferences {
  Q_OBJECT

public:
  DialogPreferences(QWidget* parent, IpePreferences &data, int gridSize);

public slots:
  void ShowHelp();
  void UpdateData();
  void ShowDirectories();
  void SetFont();
  void SetStyleSheet();
  void ClearStyleSheet();
  void SetDefaultGrid();

private:
  IpePreferences &iData;
  QString iStyleSheetPath;
  int iGridSize;
};

// --------------------------------------------------------------------

class DialogEffects : public QDialog, Ui::DlgEffects {
  Q_OBJECT
public:
  DialogEffects(QWidget* parent, IpeView &data);

public slots:
  void ShowHelp();
  void UpdateData();
  void UpdateFields(int);

private:
  IpeView &iData;
};

// --------------------------------------------------------------------

class DialogPage : public QDialog, Ui::DlgPage {
  Q_OBJECT
public:
  DialogPage(QWidget* parent, QStringList &sections, bool *useTitle);

public slots:
  void ShowHelp();
  void UpdateData();

private slots:
  void useTitleChanged(int);

private:
  QStringList &iSections;
  bool *iUseTitle;
};

// --------------------------------------------------------------------

class DialogLatexError : public QDialog, Ui::DlgLatexErr {
  Q_OBJECT
public:
  DialogLatexError(QWidget* parent, const QString &log);
};

// --------------------------------------------------------------------
#endif
