/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ITUNESDBPLAYLIST_H
#define ITUNESDBPLAYLIST_H

#include <qvaluevector.h>

#include "listitem.h"
#include "playlistitem.h"

#define TRACKLIST_UNDEFINED 0xFFFFFFFF

namespace itunesdb {

/**
 @author Michael Schulze
*/
class Playlist : public ListItem
{
public:
    enum Sortorder {
        SORTORDER_MANUAL = 1,
        SORTORDER_TITLE = 3,
        SORTORDER_ALBUM = 4,
        SORTORDER_ARTIST = 5,
        SORTORDER_BIRATE = 6,
        SORTORDER_GENRE = 7,
        SORTORDER_FILETYPE = 8,
        SORTORDER_TIME_MODIFIED = 9,
        SORTORDER_TRACK_NR = 10,
        SORTORDER_SIZE = 11,
        SORTORDER_TIME = 12,
        SORTORDER_YEAR = 13,
        SORTORDER_SAMPLERATE = 14,
        SORTORDER_COMMENT = 15,
        SORTORDER_TIME_ADDED = 16,
        SORTORDER_EQUALIZER = 17,
        SORTORDER_COMPOSER = 18,
        SORTORDER_PLAYCOUNT = 20,
        SORTORDER_TIME_PLAYED = 21,
        SORTORDER_CD_NR = 22,
        SORTORDER_RATING = 23,
        SORTORDER_RELEASE_DATE = 24,
        SORTORDER_BPM = 25,
        SORTORDER_GROUPING = 26,
        SORTORDER_CATEGORY = 27,
        SORTORDER_DESCRIPTION = 28
    } ItdbPlaylistSortOrder;

    typedef QValueVector<Q_UINT32> TrackList_T;
    class Iterator {
    protected:
        TrackList_T& _list;
        TrackList_T::iterator _iterator;
        friend class itunesdb::Playlist;
    public:
        Iterator(TrackList_T& list)
            : _list(list) {
            _iterator = _list.begin();
        }
        bool hasNext() {
            return _iterator != _list.end();
        }
        const Q_UINT32& next() {
            return *_iterator++;
        }
    };
    
    Playlist();
    virtual ~Playlist();

    const QString& getTitle() const;
    void setTitle( const QString& newtitle);
    void doneAddingData();
    
    virtual uint addPlaylistItem(const PlaylistItem& item);
    virtual uint addPlaylistItem(const Q_UINT32& trackid);
    virtual Q_UINT32 removeTrackAt( Iterator& pos);
    virtual Q_UINT32 setTrackIDAt( uint pos, Q_UINT32 trackid);
    virtual Q_UINT32 getTrackIDAt( uint pos );
    
    Iterator getTrackIDs();
    uint getNumTracks() const;
    
    void clear();

    QDataStream & readFromStream( QDataStream & instream );
    void writeData( QByteArray& data, bool isMainlist);
    QDataStream & writeToStream (QDataStream & outstream, bool isMainlist);
    
    bool isHidden() const { return hidden; }
    void setSortOrderField( Q_UINT32 sortOrder ) { order = sortOrder; }

protected:
    void writeHeader( QDataStream& stream, bool isMainlist ) const;
    void writeTitle( QDataStream& stream ) const;
    void writeLongPlaylist( QDataStream& stream ) const;
    void writeTracks( QDataStream& stream );

    TrackList_T tracklist;
    //bool isLibraryList;         // PL_TYPE_MPL: master play list
    bool isSmartList;      // smart playlist?
    Q_UINT32 hidden;
    Q_UINT32 timeStamp;     // some timestamp
    Q_UINT32 id;            // playlist ID
    Q_UINT32 unk3;
    Q_UINT32 sCount;
    Q_UINT32 lCount;
    Q_UINT32 order;
    //SPLPref splpref;      /* smart playlist prefs          */
    //SPLRules splrules;    /* rules for smart playlists     */
};

}

#endif
