#include <stdio.h>
#include "../../include/irc_string.h"
/*
 * $Id: testattr.c,v 1.1.1.1 2003/07/22 18:07:01 jpinto Exp $
 */


/*
 * CharAttrs table
 *
 * NOTE: RFC 1459 sez: anything but a ^G, comma, or space is allowed
 * for channel names
 */
const unsigned int CharAttrs[] = {
/* 0  */     CNTRL_C, 
/* 1  */     CNTRL_C|CHAN_C,
/* 2  */     CNTRL_C|CHAN_C,
/* 3  */     CNTRL_C|CHAN_C,
/* 4  */     CNTRL_C|CHAN_C,
/* 5  */     CNTRL_C|CHAN_C,
/* 6  */     CNTRL_C|CHAN_C,
/* 7 BEL */  CNTRL_C,
/* 8  \b */  CNTRL_C|CHAN_C,
/* 9  \t */  CNTRL_C|SPACE_C|CHAN_C,
/* 10 \n */  CNTRL_C|SPACE_C|CHAN_C,
/* 11 \v */  CNTRL_C|SPACE_C|CHAN_C,
/* 12 \f */  CNTRL_C|SPACE_C|CHAN_C,
/* 13 \r */  CNTRL_C|SPACE_C|CHAN_C,
/* 14 */     CNTRL_C|CHAN_C,
/* 15 */     CNTRL_C|CHAN_C,
/* 16 */     CNTRL_C|CHAN_C,
/* 17 */     CNTRL_C|CHAN_C,
/* 18 */     CNTRL_C|CHAN_C,
/* 19 */     CNTRL_C|CHAN_C,
/* 20 */     CNTRL_C|CHAN_C,
/* 21 */     CNTRL_C|CHAN_C,
/* 22 */     CNTRL_C|CHAN_C,
/* 23 */     CNTRL_C|CHAN_C,
/* 24 */     CNTRL_C|CHAN_C,
/* 25 */     CNTRL_C|CHAN_C,
/* 26 */     CNTRL_C|CHAN_C,
/* 27 */     CNTRL_C|CHAN_C,
/* 28 */     CNTRL_C|CHAN_C,
/* 29 */     CNTRL_C|CHAN_C,
/* 30 */     CNTRL_C|CHAN_C,
/* 31 */     CNTRL_C|CHAN_C,
/* SP */     PRINT_C|SPACE_C,
/* ! */      PRINT_C|KWILD_C|CHAN_C,
/* " */      PRINT_C|CHAN_C,
/* # */      PRINT_C|CHANPFX_C|CHAN_C,
/* $ */      PRINT_C|CHAN_C,
/* % */      PRINT_C|CHAN_C,
/* & */      PRINT_C|CHANPFX_C|CHAN_C,
/* ' */      PRINT_C|CHAN_C,
/* ( */      PRINT_C|CHAN_C,
/* ) */      PRINT_C|CHAN_C,
/* * */      PRINT_C|KWILD_C|CHAN_C,
/* + */      PRINT_C|CHAN_C,
/* , */      PRINT_C,
/* - */      PRINT_C|NICK_C|CHAN_C,
/* . */      PRINT_C|KWILD_C|CHAN_C,
/* / */      PRINT_C|CHAN_C,
/* 0 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 1 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 2 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 3 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 4 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 5 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 6 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 7 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 8 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* 9 */      PRINT_C|DIGIT_C|NICK_C|CHAN_C,
/* : */      PRINT_C|CHAN_C,
/* ; */      PRINT_C|CHAN_C,
/* < */      PRINT_C|CHAN_C,
/* = */      PRINT_C|CHAN_C,
/* > */      PRINT_C|CHAN_C,
/* ? */      PRINT_C|KWILD_C|CHAN_C,
/* @ */      PRINT_C|KWILD_C|CHAN_C,
/* A */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* B */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* C */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* D */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* E */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* F */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* G */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* H */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* I */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* J */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* K */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* L */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* M */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* N */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* O */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* P */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* Q */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* R */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* S */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* T */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* U */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* V */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* W */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* X */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* Y */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* Z */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* [ */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* \ */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* ] */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* ^ */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* _ */      PRINT_C|NICK_C|CHAN_C,
/* a */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* b */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* c */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* d */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* e */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* f */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* g */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* h */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* i */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* j */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* k */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* l */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* m */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* n */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* o */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* p */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* q */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* r */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* s */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* t */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* u */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* v */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* w */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* x */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* y */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* z */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* { */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* | */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* } */      PRINT_C|ALPHA_C|NICK_C|CHAN_C,
/* ~ */      PRINT_C|ALPHA_C|CHAN_C,
/* del  */   CHAN_C,
/* 0x80 */   CHAN_C,
/* 0x81 */   CHAN_C,
/* 0x82 */   CHAN_C,
/* 0x83 */   CHAN_C,
/* 0x84 */   CHAN_C,
/* 0x85 */   CHAN_C,
/* 0x86 */   CHAN_C,
/* 0x87 */   CHAN_C,
/* 0x88 */   CHAN_C,
/* 0x89 */   CHAN_C,
/* 0x8A */   CHAN_C,
/* 0x8B */   CHAN_C,
/* 0x8C */   CHAN_C,
/* 0x8D */   CHAN_C,
/* 0x8E */   CHAN_C,
/* 0x8F */   CHAN_C,
/* 0x90 */   CHAN_C,
/* 0x91 */   CHAN_C,
/* 0x92 */   CHAN_C,
/* 0x93 */   CHAN_C,
/* 0x94 */   CHAN_C,
/* 0x95 */   CHAN_C,
/* 0x96 */   CHAN_C,
/* 0x97 */   CHAN_C,
/* 0x98 */   CHAN_C,
/* 0x99 */   CHAN_C,
/* 0x9A */   CHAN_C,
/* 0x9B */   CHAN_C,
/* 0x9C */   CHAN_C,
/* 0x9D */   CHAN_C,
/* 0x9E */   CHAN_C,
/* 0x9F */   CHAN_C,
/* 0xA0 */   CHAN_C,
/* 0xA1 */   CHAN_C,
/* 0xA2 */   CHAN_C,
/* 0xA3 */   CHAN_C,
/* 0xA4 */   CHAN_C,
/* 0xA5 */   CHAN_C,
/* 0xA6 */   CHAN_C,
/* 0xA7 */   CHAN_C,
/* 0xA8 */   CHAN_C,
/* 0xA9 */   CHAN_C,
/* 0xAA */   CHAN_C,
/* 0xAB */   CHAN_C,
/* 0xAC */   CHAN_C,
/* 0xAD */   CHAN_C,
/* 0xAE */   CHAN_C,
/* 0xAF */   CHAN_C,
/* 0xB0 */   CHAN_C,
/* 0xB1 */   CHAN_C,
/* 0xB2 */   CHAN_C,
/* 0xB3 */   CHAN_C,
/* 0xB4 */   CHAN_C,
/* 0xB5 */   CHAN_C,
/* 0xB6 */   CHAN_C,
/* 0xB7 */   CHAN_C,
/* 0xB8 */   CHAN_C,
/* 0xB9 */   CHAN_C,
/* 0xBA */   CHAN_C,
/* 0xBB */   CHAN_C,
/* 0xBC */   CHAN_C,
/* 0xBD */   CHAN_C,
/* 0xBE */   CHAN_C,
/* 0xBF */   CHAN_C,
/* 0xC0 */   CHAN_C,
/* 0xC1 */   CHAN_C,
/* 0xC2 */   CHAN_C,
/* 0xC3 */   CHAN_C,
/* 0xC4 */   CHAN_C,
/* 0xC5 */   CHAN_C,
/* 0xC6 */   CHAN_C,
/* 0xC7 */   CHAN_C,
/* 0xC8 */   CHAN_C,
/* 0xC9 */   CHAN_C,
/* 0xCA */   CHAN_C,
/* 0xCB */   CHAN_C,
/* 0xCC */   CHAN_C,
/* 0xCD */   CHAN_C,
/* 0xCE */   CHAN_C,
/* 0xCF */   CHAN_C,
/* 0xD0 */   CHAN_C,
/* 0xD1 */   CHAN_C,
/* 0xD2 */   CHAN_C,
/* 0xD3 */   CHAN_C,
/* 0xD4 */   CHAN_C,
/* 0xD5 */   CHAN_C,
/* 0xD6 */   CHAN_C,
/* 0xD7 */   CHAN_C,
/* 0xD8 */   CHAN_C,
/* 0xD9 */   CHAN_C,
/* 0xDA */   CHAN_C,
/* 0xDB */   CHAN_C,
/* 0xDC */   CHAN_C,
/* 0xDD */   CHAN_C,
/* 0xDE */   CHAN_C,
/* 0xDF */   CHAN_C,
/* 0xE0 */   CHAN_C,
/* 0xE1 */   CHAN_C,
/* 0xE2 */   CHAN_C,
/* 0xE3 */   CHAN_C,
/* 0xE4 */   CHAN_C,
/* 0xE5 */   CHAN_C,
/* 0xE6 */   CHAN_C,
/* 0xE7 */   CHAN_C,
/* 0xE8 */   CHAN_C,
/* 0xE9 */   CHAN_C,
/* 0xEA */   CHAN_C,
/* 0xEB */   CHAN_C,
/* 0xEC */   CHAN_C,
/* 0xED */   CHAN_C,
/* 0xEE */   CHAN_C,
/* 0xEF */   CHAN_C,
/* 0xF0 */   CHAN_C,
/* 0xF1 */   CHAN_C,
/* 0xF2 */   CHAN_C,
/* 0xF3 */   CHAN_C,
/* 0xF4 */   CHAN_C,
/* 0xF5 */   CHAN_C,
/* 0xF6 */   CHAN_C,
/* 0xF7 */   CHAN_C,
/* 0xF8 */   CHAN_C,
/* 0xF9 */   CHAN_C,
/* 0xFA */   CHAN_C,
/* 0xFB */   CHAN_C,
/* 0xFC */   CHAN_C,
/* 0xFD */   CHAN_C,
/* 0xFE */   CHAN_C,
/* 0xFF */   CHAN_C
};

main()
{
  int i;
  for(i=0;i<255;i++)
    printf("%i:%c %X\n", i, i, CharAttrs[i]);
}
