/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_headers.h 1.74@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_headers.h|20030913195021|64422
 * 
 */

#if !defined _IROFFER_HEADERS
#define _IROFFER_HEADERS

/*------------ includes ------------- */

#ifndef _OS_HPUX
#include <stdio.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <pwd.h>
#include <regex.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <errno.h>
#include <dirent.h>
#include <stdarg.h>
#include <sys/utsname.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <grp.h>


#ifdef CRYPT_H
#include <crypt.h>
#endif

#if defined(_OS_SunOS) \
 || defined(_OS_HPUX) \
 || defined(_OS_CYGWIN)
#include <sys/termios.h>
#endif

#if defined(_OS_SunOS) \
 || defined(_OS_HPUX) \
 || defined(_OS_IRIX) \
 || defined(_OS_IRIX64)
#include <strings.h>
#endif


/*------------ structures ------------- */

typedef struct {
   char *file, *desc, *note;
   int gets;
   float minspeed,
         maxspeed;
   off_t st_size;
   dev_t st_dev;
   ino_t st_ino;
   time_t mtime;
   } xdcc;

typedef struct {
   xdcc *xpack;
   char nick[maxtextlengthshort],
        hostname[maxtextlength];
   time_t queuedtime;
   } pqueue;

typedef struct {
   char hostmask[maxtextlength];
   short flags;
   long bucket;
   time_t lastcontact;
   regex_t *regexp;
   } igninfo;

typedef struct {
   char hostmask[maxtextlength];
   short flags;
   long bucket;
   time_t lastcontact;
   } igninfo_file;

typedef enum
{
  TRANSFER_STATUS_UNUSED,
  TRANSFER_STATUS_LISTENING,
  TRANSFER_STATUS_SENDING,
  TRANSFER_STATUS_WAITING,
  TRANSFER_STATUS_DONE
} transfer_status_e;

typedef struct {
   int listensocket,
       clientsocket,
       filedescriptor,
       id;
   off_t bytessent,
         bytesgot,
         lastack,
         startresume,
         lastspeedamt;
   unsigned long xdccsent[4];
   time_t lastcontact, connecttime;
   unsigned short listenport, remoteport;
   unsigned long localip, remoteip;
   float lastspeed;
   xdcc *xpack;
   struct sockaddr_in serveraddress;
   char nick[maxtextlengthshort],
        caps_nick[maxtextlengthshort],
        hostname[maxtextlength],
        nomin,nomax,reminded,overlimit;
   transfer_status_e tr_status;
   } transfer;

typedef enum
{
  UPLOAD_STATUS_UNUSED,
  UPLOAD_STATUS_CONNECTING,
  UPLOAD_STATUS_GETTING,
  UPLOAD_STATUS_WAITING,
  UPLOAD_STATUS_DONE
} upload_status_e;

typedef struct {
   int clientsocket,
       filedescriptor;
   off_t bytesgot,
         totalsize,
         lastspeedamt,
         resumesize;
   time_t lastcontact, connecttime;
   unsigned short localport, remoteport;
   unsigned long localip, remoteip;
   float lastspeed;
   char nick[maxtextlengthshort],
        hostname[maxtextlength],
        file[maxtextlength];
   upload_status_e ul_status;
   int resumed;
   } upload;

typedef enum
{
  method_stdin           = (1 << 0),
  method_dcc             = (1 << 1),
  method_msg             = (1 << 2),
  method_out_all         = (1 << 3),
  method_fd              = (1 << 4),
  method_allow_all       =    0x01F, /* first 5 */
  
  method_xdl_channel     = (1 << 5),
  method_xdl_user        = (1 << 6),
  method_xdl_channel_min = (1 << 7),
  method_xdl_channel_sum = (1 << 8),
  
  method_allow_all_xdl   =    0x1FF /* everything */
} userinput_method_e;

typedef enum
{
  CALLTYPE_NORMAL,
  CALLTYPE_MULTI_FIRST,
  CALLTYPE_MULTI_MIDDLE,
  CALLTYPE_MULTI_END
} calltype_e;

typedef enum
{
  OUTERROR_TYPE_CRASH,
  OUTERROR_TYPE_WARN_LOUD,
  OUTERROR_TYPE_WARN,
  OUTERROR_TYPE_NOLOG = 0x80
} outerror_type_e;

typedef struct {
   userinput_method_e method;
   char *snick, *cmd, *arg1e, *arg2e, *arg1, *arg2, *arg3;
   int fd;
   } userinput;

typedef struct {
   const short help_section;
   const userinput_method_e methods_allowed;
   void (*handler)(const userinput * const);
   const char *command;
   const char *args;
   const char *desc;
   } userinput_parse_t;

typedef struct {
   void *ptr;
   const char *src_func;
   const char *src_file;
   int src_line;
   time_t alloctime;
   int size;
   } meminfo_t;

typedef struct channel_member_t2
{
  struct channel_member_t2 *next;
  char nick[1]; /* actual space is allocated with the struct */
} channel_member_t;

typedef struct {
   char name[maxtextlength];
   char key[maxtextlengthshort];
   short flags, plisttime, plistoffset;
   channel_member_t *members;
} channel_t;

typedef enum {
   how_direct = 1,
   how_bnc,
   how_wingate,
   how_custom
   } how_e;

typedef struct {
   how_e how;
   char host[maxtextlengthshort];
   unsigned short port;
   char password[maxtextlengthshort];
   char vhost[maxtextlength];
   } connectionmethod_t;

typedef struct {
  const char *file;
  const char *func;
  int line;
  struct timeval tv;
} context_t;

/*------------ function declerations ------------- */

/* iroffer.c */
void sendxdccfile(char* nick, const char* hostname, int pack, char* msg);
void sendaqueue(int type);

/* display.c */
void initscreen(void);
void checktermsize(void);
void gototop(void);
void clearbot(void);
void gotobot(void);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 1, 2)))
#endif
tostdout(const char *format, ...);

void vtostdout(const char *format, va_list ap);
void tostdout_write(void);
void tostdout_disable_buffering(int flush);

/* utilities.c */
const char* strstrnocase (const char *str1, const char *match1);
#define getpart(x,y) getpart2(x,y,__FUNCTION__,__FILE__,__LINE__)
char* getpart2(const char *line, int howmany, const char *src_function, const char *src_file, int src_line);
char* caps(char *text);
char* nocaps(char *text);
char* sizestr(int spaces, char* str, off_t num);
int highestsock (void);
void getos(void);
void floodchk(void);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
outerror (outerror_type_e type, const char *format, ...);

char* getdatestr(char* str, time_t Tp);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
mylog(calltype_e type, const char *format, ...);

void logstat(void);
unsigned long atoul (const char *str);
unsigned long long atoull (const char *str);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 4, 5)))
#endif
ioutput(calltype_e type, int dest, unsigned int color_flags, const char *format, ...);

void vioutput(calltype_e type, int dest, unsigned int color_flags, const char *format, va_list ap);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
privmsg(const char *nick, const char *format, ...);

void vprivmsg(const char *nick, const char *format, va_list ap);

void
#ifdef __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
notice(const char *nick, const char *format, ...);

void vnotice(const char *nick, const char *format, va_list ap);
char* hostmasktoregex(char *str);
int verifyadmin(const char *hmask);
int verifypass(const char *testpass);
int packnumtonum(char *a);
int sstrlen (const char *p);
char dayofweektomask(const char a);
void msglog_add(char* hostmask, char* line);
char* msglog_howmany(char *str);
char *strrev(char *str);
int isprintable(char a);
char onlyprintable(char a);
char* removenonprintable(char *str1);
char* removenonprintablectrl(char *str1);
char* removenonprintablefile(char *str);
int doesfileexist(const char *f);
void joinchannel(channel_t *c);
void checkadminpass(void);
void updatecontext_f(const char *file, const char *func, int line);
void dumpcontext(void);
void dumpgdata(void);
void clearmemberlist(channel_t *c);
int isinmemberlist(const char *nick);
void addtomemberlist(channel_t *c, const char *nick);
void removefrommemberlist(channel_t *c, char *nick);
void changeinmemberlist(channel_t *c, char *oldnick, char *newnick);
int set_socket_nonblocking (int s, int nonblock);
void set_loginname(void);
int is_fd_readable(int fd);
int is_fd_writeable(int fd);
char* convert_to_unix_slash(char *ss);

void* mycalloc2(int a, const char *src_function, const char *src_file, int src_line);
void mydelete2(void *t);

#ifdef NO_SNPRINTF
int
#ifdef __GNUC__
__attribute__ ((format(printf, 3, 4)))
#endif
snprintf(char *str, size_t n, const char *format, ... );

int vsnprintf(char *str, size_t n, const char *format, va_list ap );
#endif

#ifdef NO_STRSIGNAL
const char *strsignal(int sig);
#endif

/* misc.c */
void getconfig (void);
void getconfig_set (const char *line, int rehash);
int connectirc (const char *tserver);
void initirc(void);
#define writeserver(x) writeserver2(x,0)
void writeserver2 (char *msg, int sendt);
void sendserver(void);
void getxdccconfig(const char *filename);
void getsendname(char * const full, char * copy);
char* getfilename(char * const full);
void pingserver(void);
void xdccsave(int autosave);
void writepidfile (const char *filename);
char* getfline(char* str, int descr, int ret);
void gobackground(void);
char* getuptime(char *str, int type, time_t fromwhen);
void parsestdin(void);
void shutdowniroffer(void);
void switchserver(int which);
char* getstatusline(char *str);
char* getstatuslinenums(char *str);
void sendxdlqueue(void);
int isthisforme (const char *dest, char *msg1);
void initvars(void);
void startupiroffer(void);
void isrotatelog(void);
void createpassword(void);
char inttosaltchar (int n);
void notifyqueued(void);
void notifybandwidth(void);
void notifybandwidthtrans(void);
void write_ignorefile(void);
void read_ignorefile(void);
void look_for_file_changes(xdcc *xpack);

/* dccchat.c */
int setupdccchatout(const char *nick);
void setupdccchataccept(void);
int setupdccchat(const char *line);
void parsedccchat(char* line);
void writedccchat(const char *str);
void writestatus(void);

/* plugins.c */
void plugin_initialize (void);
void plugin_everyloop (void);
void plugin_every1sec (void);
void plugin_every20sec (void);
void plugin_ircprivmsg (const char *fullline, const char *nick, const char *hostname,
			const char *dest, const char *msg1, const char *msg2, const char *msg3,
			const char *msg4, const char *msg5);
void plugin_ircinput (const char *fullline, const char *part2, const char *part3, const char *part4);

/* transfer.c */
void t_initvalues (transfer * const t);
void t_setuplisten (transfer * const t);
void t_establishcon (transfer * const t);
void t_transfersome (transfer * const t);
void t_readjunk (transfer * const t);
void t_istimeout (transfer * const t);
void t_flushed(transfer * const t);
void t_closeconn(transfer * const t, const char *msg, int include_errno);
void t_setresume(transfer * const t, const char *amt);
void t_remind(transfer * const t);
void t_checkminspeed(transfer * const t);

/* upload.c */
void l_initvalues (upload * const l);
void l_establishcon (upload * const l);
void l_transfersome (upload * const l);
void l_istimeout (upload * const l);
void l_closeconn(upload * const l, const char *msg, int include_errno);

/* admin.c */
void u_fillwith_stdin(userinput * const u, char *line);
void u_fillwith_dcc(userinput * const u, char *line);
void u_fillwith_msg(userinput * const u, char *n, const char *line);
void u_fillwith_clean(userinput * const u);

void u_parseit(userinput * const u);

#endif

/* End of File */
