/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_misc.c 1.126@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_misc.c|20030914201947|35946
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


void getconfig (void) {
   char *tempbuf = mycalloc(maxtextlength);
   char *templine = mycalloc(maxtextlength);
   int h, i, j, len, filedescriptor;
   
   updatecontext();

   for (h=0; h<MAXCONFIG && gdata.configfile[h]; h++)
     {
       convert_to_unix_slash(gdata.configfile[h]);
       
       printf("*** Loading %s ... \n",gdata.configfile[h]);
       
       filedescriptor=open(gdata.configfile[h], O_RDONLY | ADDED_OPEN_FLAGS);
       if (filedescriptor < 0)
         {
           outerror(OUTERROR_TYPE_CRASH,"Cant Access Config File '%s': %s",gdata.configfile[h],strerror(errno));
         }
       
       i = 0;
       while((len = read(filedescriptor,tempbuf,maxtextlength)) > 0)
         {
           for (j=0; j<len; j++)
             {
               if (tempbuf[j] == '\n' || tempbuf[j] == 13) /* 13 is ^M */
                 {
                   templine[i] = '\0';
                   if ( templine[0] != '#' && strlen(templine) != 0 )
                     {
                       for (i=strlen(templine)-1; i>2 && templine[i] == ' '; i--)
                         {
                           templine[i] = '\0';
                         }
                       getconfig_set (templine,0);
                     }
                   i = 0;
                 }
               else
                 {
                   templine[i] = tempbuf[j];
                   i++;
                 }
             }
         }
       
       close(filedescriptor);
     }
   
   printf("*** Checking for completeness of config file ...\n");
   
   if ( gdata.server[0] == NULL
        || gdata.config_nick == NULL || gdata.user_realname == NULL
        || gdata.channels[0] == NULL || gdata.slotsmax == 0 
        || gdata.xdccautosavetime == 0 || gdata.xdccfile == 0)
      outerror(OUTERROR_TYPE_CRASH,"Config File Missing Necessary Information");

   if ( gdata.autosend && ( gdata.autoword == NULL || gdata.automsg == NULL || !gdata.autopack ) )
      outerror(OUTERROR_TYPE_CRASH,"Config File Missing Autosend Information");

   if ( gdata.uploadallowed && ( gdata.uploaddir == NULL || strlen(gdata.uploaddir) < 2 ) )
      outerror(OUTERROR_TYPE_CRASH,"Config File Missing Upload Information");
      
   if (gdata.background) gdata.debug = 0;
   
   gdata.user_nick = mycalloc(maxtextlengthshort);
   strncpy(gdata.user_nick,gdata.config_nick,maxtextlengthshort-1);
   
   if ( !gdata.noscreen && !gdata.background) {
      printf("\x1b[%i;12H%s) >",gdata.termlines,gdata.user_nick);
      printf("\x1b[%i;%iH",gdata.termlines, (int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
      gototop();
      }
   
   gdata.caps_nick = mycalloc(maxtextlengthshort);
   strncpy(gdata.caps_nick,gdata.user_nick,maxtextlengthshort-1);
   caps(gdata.caps_nick);
   
   mydelete(tempbuf);
   mydelete(templine);
   }

void getconfig_set (const char *line, int rehash) {
   char *type = mycalloc(maxtextlength);
   char *var2 = mycalloc(maxtextlength);
   char *var;
   char *a,*b;
   struct hostent *thost;
   struct sockaddr_in tsocka;
   int i,j;
   
   updatecontext();

   for (i=0; i<maxtextlength; i++) {
      if (line[i] == ' ' || line[i] == '\0')
         break;
      type[i] = line[i];
      }
   type[i] = '\0';
   
   for (j=i+1; j<maxtextlength; j++) {
      if (line[j] == '\0')
         break;
      var2[j-i-1] = line[j];
      }
   var2[j-i-1] = '\0';
   
   var = mycalloc(strlen(var2)+2);
   strncpy(var,var2,strlen(var2)+1);
   
   /* parse it */
   if (!strcmp(type,"debug")) {
      if (!strcmp(var,"yes")) {
         gdata.debug = 1;
         }
      else if (!strcmp(var,"no")){
         gdata.debug = 0;
         }
      else {
         gdata.debug = atoi(var);
         }
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && !rehash) {
      if (!strcmp(var,"yes")) gdata.virthost = 1;
      else gdata.virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && rehash) {
      if (!strcmp(var,"yes")) gdata.r_virthost = 1;
      else gdata.r_virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"autosend")) {
      if (!strcmp(var,"yes")) gdata.autosend = 1;
      else gdata.autosend = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"logstats")) {
      if (!strcmp(var,"yes")) gdata.logstats = 1;
      else gdata.logstats = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"hideos")) {
      gdata.hideos = 1;
      mydelete(var);
      }
   else if (!strcmp(type,"lognotices")) {
      gdata.lognotices = 1;
      mydelete(var);
      }
   else if (!strcmp(type,"notifytime")) {
      gdata.notifytime = between(1,atoi(var),1000000);
      mydelete(var);
      }
   else if (!strcmp(type,"respondtochannelxdcc")) {
      gdata.respondtochannelxdcc = 1;
      mydelete(var);
      }
   else if (!strcmp(type,"respondtochannellist")) {
      gdata.respondtochannellist = 1;
      mydelete(var);
      }
   else if (!strcmp(type,"smallfilebypass")) {
      gdata.smallfilebypass = 1024 * between(0,atoi(var),1024*1024);
      mydelete(var);
      }
   else if (!strcmp(type,"slowlink")) {
      /* no longer used */
      mydelete(var);
      }
   else if (!strcmp(type,"firewall")) {
      if (!strcmp(var,"yes")) gdata.firewall = 1;
      else gdata.firewall = 0;
      mydelete(var);
      }
   else if ( ! strcmp(type,"dccrangestart")) {
      gdata.dccrangestart = atoi(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"server")) {
      for (i=0; gdata.server[i] && i<MAXSRVS; i++) ;
      gdata.server[i] = var;
      }
   else if ( ! strcmp(type,"channel")) {
      char *tptr = NULL, *tptr2 = NULL, *tname;
      int ok=1;
      channel_t *cptr = NULL;
      
      if (!rehash) {
         for (i=0; gdata.channels[i] && i<MAXCHNLS; i++) ;
         cptr = gdata.channels[i] = mycalloc(sizeof(channel_t));
         }
      else {
         for (i=0; gdata.r_channel[i] && i<MAXCHNLS; i++) ;
         cptr = gdata.r_channel[i] = mycalloc(sizeof(channel_t));
         }
      
      tname = getpart(var,1);
      strncpy(cptr->name,caps(tname),maxtextlength-1);
      
      for (i=2; i<20 && ok && (tptr = getpart(var,i)); i++) {
         if (!strcmp(tptr,"-plist")) {
            i++;
            if ((tptr2 = getpart(var,i)))
               cptr->plisttime = atoi(tptr2);
            else ok=0;
            }
         else if (!strcmp(tptr,"-pformat")) {
            i++;
            if ((tptr2 = getpart(var,i))) {
               if (!strcmp(tptr2,"full"))
                  ;
               else if (!strcmp(tptr2,"minimal"))
                  cptr->flags |= CHAN_MINIMAL;
               else if (!strcmp(tptr2,"summary"))
                  cptr->flags |= CHAN_SUMMARY;
               else ok=0;
               }
            else ok=0;
            }
          else if (!strcmp(tptr, "-plistoffset")) {
            i++;
            if ((tptr2 = getpart(var, i)))
              cptr->plistoffset = atoi(tptr2);
            else
              cptr->plistoffset = 0;
            }
         else if (!strcmp(tptr,"-key")) {
            i++;
            if ((tptr2 = getpart(var,i)))
               strncpy(cptr->key,tptr2,maxtextlengthshort-1);
            else ok=0;
            }
         else ok=0;
         
         mydelete(tptr);
         mydelete(tptr2);
         }
      
      if (!ok) ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR," !!! Bad syntax for channel %s in config file !!!",tname);
      
      mydelete(tptr);
      mydelete(tptr2);
      mydelete(tname);
      mydelete(var);
      }
   else if ( ! strcmp(type,"adminhost")) {
      for (i=0; gdata.adminhost[i] && i<MAXAHOST; i++) ;
      hostmasktoregex(caps(var2));
      gdata.adminhost[i] = mycalloc(sizeof(regex_t));
      if (regcomp(gdata.adminhost[i],var2,REG_ICASE|REG_NOSUB))
         gdata.adminhost[i] = NULL;
      mydelete(var);
      }
   else if ( ! strcmp(type,"user_nick") && !rehash) {
      mydelete(gdata.config_nick);
      gdata.config_nick = var;
      }
   else if ( ! strcmp(type,"user_nick") && rehash) {
      mydelete(gdata.r_config_nick);
      gdata.r_config_nick = var;
      }
   else if ( ! strcmp(type,"user_realname")) {
      mydelete(gdata.user_realname);
      gdata.user_realname = var;
      }
   else if ( ! strcmp(type,"user_modes")) {
      mydelete(gdata.user_modes);
      gdata.user_modes = var;
      }
   else if ( ! strcmp(type,"slotsmax")) {
      gdata.slotsmax = between(1,atoi(var),min2(MAX_FDS_TO_MAXTRANS(gdata.max_fds_from_rlimit),MAXTRANS));
      if (gdata.slotsmax != atoi(var))
        {
          outerror(OUTERROR_TYPE_WARN,"unable to have slotsmax of %d, using %d instead",atoi(var),min2(MAX_FDS_TO_MAXTRANS(gdata.max_fds_from_rlimit),MAXTRANS));
        }
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxpack")) {
      gdata.slotsmaxpack = between(0,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxslots")) {
      gdata.slotsmaxslots = between(1,atoi(var),MAXTRANS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"vhost_ip") && !rehash) {
      mydelete(gdata.vhost_ip);
      gdata.vhost_ip = var;
      }
   else if ( ! strcmp(type,"vhost_ip") && rehash) {
      mydelete(gdata.r_vhost_ip);
      gdata.r_vhost_ip = var;
      }
   else if ( ! strcmp(type,"autoword")){
      mydelete(gdata.autoword);
      gdata.autoword = var;
      }
   else if ( ! strcmp(type,"automsg")){
      mydelete(gdata.automsg);
      gdata.automsg = var;
      }
   else if ( ! strcmp(type,"autopack")) {
      gdata.autopack = between(1,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallminspeed")) {
      gdata.overallminspeed = atof(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"transfermaxspeed")) {
      gdata.transfermaxspeed = max2(0,atof(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeed")) {
      gdata.overallmaxspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddayspeed")) {
      gdata.overallmaxspeeddayspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaytime")) {
      a = getpart(var,1); b = getpart(var,2);
      if (a && b) {
         gdata.overallmaxspeeddaytimestart = between(0,atoi(a),23);
         gdata.overallmaxspeeddaytimeend   = between(0,atoi(b),23);
         }
      mydelete(a); mydelete(b);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaydays")) {
      gdata.overallmaxspeeddaydays = 0;
      for (i=0; (i<sstrlen(var) && i<8); i++)
         gdata.overallmaxspeeddaydays |= dayofweektomask(var[i]);
      mydelete(var);
      }
   else if ( ! strcmp(type,"logrotate")) {
      gdata.logrotate = 0;
      if (!strcmp(var,"daily")) gdata.logrotate = 1;
      if (!strcmp(var,"weekly")) gdata.logrotate = 2;
      if (!strcmp(var,"monthly")) gdata.logrotate = 3;
      mydelete(var);
      }
   else if ( ! strcmp(type,"xdccautosavetime")) {
      gdata.xdccautosavetime = max2(5,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxqueue")) {
      gdata.slotsmaxqueue = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"queuesize")) {
      gdata.queuesize = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"adminpass")) {
      mydelete(gdata.adminpass);
      gdata.adminpass = var;
      checkadminpass();
      }
   else if ( ! strcmp(type,"pidfile") && !rehash) {
      mydelete(gdata.pidfile);
      gdata.pidfile = var;
      convert_to_unix_slash(gdata.pidfile);
      }
   else if ( ! strcmp(type,"pidfile") && rehash) {
      mydelete(gdata.r_pidfile);
      gdata.r_pidfile = var;
      convert_to_unix_slash(gdata.r_pidfile);
      }
   else if ( ! strcmp(type,"lowbdwth")) {
      gdata.lowbdwth = max2(0,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"filedir")) {
      mydelete(gdata.filedir);
      gdata.filedir = var;
      convert_to_unix_slash(gdata.filedir);
      }
   else if ( ! strcmp(type,"messagefile")) {
      mydelete(gdata.messagefile);
      gdata.messagefile = var;
      convert_to_unix_slash(gdata.messagefile);
      i = open(gdata.messagefile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
      if (i > 2) close(i);
      }
   else if ( ! strcmp(type,"ignorefile")) {
      mydelete(gdata.ignorefile);
      gdata.ignorefile = var;
      convert_to_unix_slash(gdata.ignorefile);
      i = open(gdata.ignorefile, O_RDWR | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
      if (i > 2) close(i);
      }
   else if ( ! strcmp(type,"logfile")) {
      mydelete(gdata.logfile);
      gdata.logfile = var;
      convert_to_unix_slash(gdata.logfile);
      }
   else if ( ! strcmp(type,"xdccfile") && !rehash) {
      mydelete(gdata.xdccfile);
      gdata.xdccfile = var;
      convert_to_unix_slash(gdata.xdccfile);
      }
   else if ( ! strcmp(type,"xdccfile") && rehash) {
      mydelete(gdata.r_xdccfile);
      gdata.r_xdccfile = var;
      convert_to_unix_slash(gdata.r_xdccfile);
      }
   else if ( ! strcmp(type,"headline")) {
      mydelete(gdata.headline);
      gdata.headline = var;
      }
   else if ( ! strcmp(type,"creditline")) {
      mydelete(gdata.creditline);
      gdata.creditline = var;
      }
   else if ( ! strcmp(type,"loginname")) {
      mydelete(gdata.loginname);
      gdata.loginname = var;
      }
   else if ( ! strcmp(type,"proxyinfo")) {
      mydelete(gdata.proxyinfo);
      gdata.proxyinfo = var;
      }
   else if ( ! strcmp(type,"proxyinfo2")) {
      mydelete(gdata.proxyinfo2);
      gdata.proxyinfo2 = var;
      }
   else if ( ! strcmp(type,"nickserv_pass")) {
      mydelete(gdata.nickserv_pass);
      gdata.nickserv_pass = var;
      }
   else if ( ! strcmp(type,"periodicmsg")) {
      char *tnum;
      int offset;
      mydelete(gdata.periodicmsg_nick);
      mydelete(gdata.periodicmsg_msg);
      
      gdata.periodicmsg_nick = getpart(var,1);
      tnum = getpart(var,2);
      gdata.periodicmsg_msg = getpart(var,3);
      
      if (!gdata.periodicmsg_nick || !tnum || !gdata.periodicmsg_msg) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Syntax Error In periodicmsg, Ignoring");
         mydelete(gdata.periodicmsg_nick);
         mydelete(gdata.periodicmsg_msg);
         mydelete(var);
         }
      else {
         gdata.periodicmsg_time = max2(1,atoi(tnum));
         
         offset = strlen(gdata.periodicmsg_nick) + strlen(tnum) + 2;
         for (i=offset; i<=strlen(var); i++)
            var[i-offset] = var[i];
         
         mydelete(gdata.periodicmsg_msg);
         gdata.periodicmsg_msg = var;
         
         }
      
      mydelete(tnum);
      }
   else if ( ! strcmp(type,"maxqueueditemsperperson")) {
     gdata.maxqueueditemsperperson = max2(1,atoi(var));
     mydelete(var);
   }
   else if ( ! strcmp(type,"maxtransfersperperson")) {
     gdata.maxtransfersperperson = max2(1,atoi(var));
     mydelete(var);
   }
   else if ( ! strcmp(type,"usenatip")) {
      gdata.usenatip = 1;
      if (( thost = gethostbyname(var)) == NULL) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Can't Resolve NAT Host, Ignoring");
         gdata.usenatip = 0;
         }
      else {
         memcpy(&tsocka.sin_addr, *((struct in_addr **)thost->h_addr_list), sizeof(struct in_addr));
         gdata.ourip = ntohl(tsocka.sin_addr.s_addr);
         if (gdata.debug > 0) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"ip=0x%8.8lX\n",gdata.ourip);
         }
      mydelete(var);
      }
   else if (!strcmp(type,"uploadallowed")) {
      if (!strcmp(var,"yes")) gdata.uploadallowed = 1;
      else gdata.uploadallowed = 0;
      mydelete(var);
      }
   else if ( ! strcmp(type,"uploaddir")) {
      mydelete(gdata.uploaddir);
      gdata.uploaddir = var;
      }
   else if ( ! strcmp(type,"uploadmaxsize")) {
      gdata.uploadmaxsize = (off_t)(max2(0,atoull(var)*1024*1024));
      mydelete(var);
      }
   else if ( ! strcmp(type,"connectionmethod")) {
      char *thow = getpart(var,1);
      char *targ1 = getpart(var,2);
      char *targ2 = getpart(var,3);
      char *targ3 = getpart(var,4);
      char *targ4 = getpart(var,5);
      
      bzero((char *) &gdata.connectionmethod,sizeof(connectionmethod_t));
      
      if (thow && !strcmp(thow,"direct")) {
         gdata.connectionmethod.how = how_direct;
         }
      else if (thow && targ1 && targ2 && targ3 && !strcmp(thow,"bnc")) {
         gdata.connectionmethod.how = how_bnc;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         strncpy(gdata.connectionmethod.password,targ3,maxtextlengthshort);
         if (targ4)
            strncpy(gdata.connectionmethod.vhost,targ4,maxtextlength);
         }
      else if (thow && targ1 && targ2 && !strcmp(thow,"wingate")) {
         gdata.connectionmethod.how = how_wingate;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         }
      else if (thow && targ1 && targ2 && !strcmp(thow,"custom")) {
         gdata.connectionmethod.how = how_custom;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         }
      else {
         gdata.connectionmethod.how = how_direct;
         outerror(OUTERROR_TYPE_WARN_LOUD,"Invalid connectionmethod in config file, defaulting to direct");
         }
      
      mydelete(thow);
      mydelete(targ1);
      mydelete(targ2);
      mydelete(targ3);
      mydelete(targ4);
      mydelete(var);
      }
   else if (!strcmp(type,"restrictlist")) {
      if (!strcmp(var,"yes")) gdata.restrictlist = 1;
      else gdata.restrictlist = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"restrictprivlist")) {
      if (!strcmp(var,"yes")) gdata.restrictprivlist = 1;
      else gdata.restrictprivlist = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"restrictsend")) {
      if (!strcmp(var,"yes")) gdata.restrictsend = 1;
      else gdata.restrictsend = 0;
      mydelete(var);
      }
   /* on join patch start */
   else if ( ! strcmp(type,"server_join_raw")) {
      mydelete(gdata.server_join_raw);
      gdata.server_join_raw = var;
      }
   else if ( ! strcmp(type,"channel_join_raw1")) {
      mydelete(gdata.channel_join_raw1);
      gdata.channel_join_raw1 = var;
      }
   else if ( ! strcmp(type,"channel_join_raw2")) {
      mydelete(gdata.channel_join_raw2);
      gdata.channel_join_raw2 = var;
      }
   else if ( ! strcmp(type,"channel_join_raw3")) {
      mydelete(gdata.channel_join_raw3);
      gdata.channel_join_raw3 = var;
      }
   /* end patch */
   else {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Ignored invalid line in config file: %s",type);
      mydelete(var);
      }

   mydelete(type);
   mydelete(var2);
   }

int connectirc (const char *tserver) {
   struct sockaddr_in ircserverip;
   struct sockaddr_in localaddr;
   struct hostent *remotehost, *localhost;
   int i, retval;
   char tempstr[maxtextlength], *to_ip, *to_port;
   
   SIGNEDSOCK int addrlen;
   
   updatecontext();

   for (i=0; i<30; i++)
      gdata.serversent[i]=0;
   
   if (!tserver) return 1;
   
   gdata.lastservercontact=gdata.curtime;
   
   gdata.nocon++;
   
   mydelete(gdata.curserverip);
   mydelete(gdata.curserverport);
   mydelete(gdata.curserveractualname);
   gdata.curserverip = getpart(tserver,1);
   gdata.curserverport = getpart(tserver,2);
   to_ip = getpart(tserver,1);
   to_port = getpart(tserver,2);
   
   if (!gdata.curserverport) {
      gdata.curserverport = mycalloc(7);
      strncpy(gdata.curserverport,"6667",6);
      to_port = mycalloc(7);
      strncpy(to_port,"6667",6);
      }
   
   switch (gdata.connectionmethod.how) {
    case how_direct:
       snprintf(tempstr,maxtextlength-1," (direct)");
       break;
    case how_bnc:
       if (gdata.connectionmethod.vhost[0])
          snprintf(tempstr,maxtextlength-1," (bnc at %s:%i with %s)",gdata.connectionmethod.host,gdata.connectionmethod.port,gdata.connectionmethod.vhost);
       else
          snprintf(tempstr,maxtextlength-1," (bnc at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       snprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    case how_wingate:
       snprintf(tempstr,maxtextlength-1," (wingate at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       snprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    case how_custom:
       snprintf(tempstr,maxtextlength-1," (custom at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       snprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    default:
       mydelete(to_ip);
       mydelete(to_port);
       return 1; /* error */
    }
      
   if (gdata.virthost && gdata.vhost_ip)
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Attempting Connection to %s from %s%s",tserver,gdata.vhost_ip,tempstr);
   else
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Attempting Connection to %s%s",tserver,tempstr);
   
   if (gdata.attop) gotobot();
   
   bzero ((char *) &ircserverip, sizeof (ircserverip));
   
   gdata.ircserver = socket( AF_INET, SOCK_STREAM, 0);
   if (gdata.ircserver < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Socket Error");
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   ircserverip.sin_family = AF_INET;
   ircserverip.sin_port = htons(atoi(to_port));
   
   if (( remotehost = gethostbyname(to_ip)) == NULL) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Can't Resolve Server Host");
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   memcpy(&ircserverip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr));
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(OUTERROR_TYPE_CRASH,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Can't Resolve Virtual Host");
         close(gdata.ircserver);
         mydelete(to_ip);
         mydelete(to_port);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(gdata.ircserver, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Bind To Virtual Host");
         close(gdata.ircserver);
         mydelete(to_ip);
         mydelete(to_port);
         return 1;
         }
      }
   
   if (set_socket_nonblocking(gdata.ircserver,1) < 0 )
      outerror(OUTERROR_TYPE_WARN,"Couldn't Set Non-Blocking");
   
   alarm(CTIMEOUT);
   retval = connect(gdata.ircserver, (struct sockaddr *) &ircserverip, sizeof(ircserverip));
   if ( (retval < 0) && !((errno == EINPROGRESS) || (errno == EAGAIN)) ) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Connection to Server Failed");
      alarm(0);
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (ircserverip);
   if (getsockname(gdata.ircserver,(struct sockaddr *) &ircserverip, &addrlen) < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't get sock name");
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   if (!gdata.usenatip)
      gdata.ourip = ntohl(ircserverip.sin_addr.s_addr);
   
   if (gdata.debug > 0) {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"ircserver socket = %d",gdata.ircserver);
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"ourip = %lu.%lu.%lu.%lu",
	      (gdata.ourip >> 24) & 0xFF,
	      (gdata.ourip >> 16) & 0xFF,
	      (gdata.ourip >>  8) & 0xFF,
	      (gdata.ourip      ) & 0xFF
	      );
      }

   highestsock();
   
   gdata.lastservercontact=gdata.curtime;
   
   mydelete(to_ip);
   mydelete(to_port);
   return 0;
   }

void initirc(void) {
   char *tempstr = mycalloc(maxtextlength);
   int i,j,k;
   
   updatecontext();

   highestsock();
   
   if (gdata.connectionmethod.how == how_custom && gdata.proxyinfo) {
      for (i=j=0; j<maxtextlength && i<strlen(gdata.proxyinfo); i++,j++) {
         tempstr[j] = gdata.proxyinfo[i];
         if (gdata.proxyinfo[i] == '$' && gdata.proxyinfo[i+1] == 's') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverip); k++,j++)
               tempstr[j] = gdata.curserverip[k];
            j--;
            }
         if (gdata.proxyinfo[i] == '$' && gdata.proxyinfo[i+1] == 'p') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverport); k++,j++)
               tempstr[j] = gdata.curserverport[k];
            j--;
            }
         }
      tempstr[j] = '\0';
      writeserver2(tempstr,1);
      }
      
   if (gdata.connectionmethod.how == how_custom && gdata.proxyinfo2) {
      for (i=j=0; j<maxtextlength && i<strlen(gdata.proxyinfo2); i++,j++) {
         tempstr[j] = gdata.proxyinfo2[i];
         if (gdata.proxyinfo2[i] == '$' && gdata.proxyinfo2[i+1] == 's') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverip); k++,j++)
               tempstr[j] = gdata.curserverip[k];
            j--;
            }
         if (gdata.proxyinfo2[i] == '$' && gdata.proxyinfo2[i+1] == 'p') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverport); k++,j++)
               tempstr[j] = gdata.curserverport[k];
            j--;
            }
         }
      tempstr[j] = '\0';
      writeserver2(tempstr,1);
      }
      
   if (gdata.connectionmethod.how == how_wingate) {
      snprintf(tempstr,maxtextlength-2,"%s %s",gdata.curserverip,gdata.curserverport);
      writeserver2(tempstr,1);
      }
   
   snprintf(tempstr,maxtextlength-2,"NICK %s",gdata.user_nick);
   writeserver2(tempstr,1);
   snprintf(tempstr,maxtextlength-2,"USER %s 32 . :%s",gdata.loginname,gdata.user_realname);
   writeserver2(tempstr,1);
   
   if (gdata.connectionmethod.how == how_bnc) {
      snprintf(tempstr,maxtextlength-2,"PASS %s",gdata.connectionmethod.password);
      writeserver2(tempstr,1);
      if (gdata.connectionmethod.vhost[0]) {
         snprintf(tempstr,maxtextlength-2,"VIP %s",gdata.connectionmethod.vhost);
         writeserver2(tempstr,1);
         }
      snprintf(tempstr,maxtextlength-2,"CONN %s %s",gdata.curserverip,gdata.curserverport);
      writeserver2(tempstr,1);
      }
   
   /* server join raw command */
   if (gdata.server_join_raw) {
      snprintf(tempstr,maxtextlength-2,"%s",gdata.server_join_raw);
      writeserver2(tempstr,1);
      }
   
   for (i=0; i<MAXCHNLS; i++)
      if (gdata.channels[i]) {
         gdata.channels[i]->flags &= ~CHAN_ONCHAN;
         }
   
   gdata.recentsent = 0;
   
   mydelete(tempstr);
   
   }

void writeserver2 (char *msg, int sendt) {
   int i, found;
   found = 0;
   
   if ( ( sendt || ! SND_FPROT ) && gdata.serverstatus == SERVERSTATUS_CONNECTED) {
      if (gdata.debug > 0)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_MAGENTA,"<SND<: %s",msg);
      strncat(msg,"\n",maxtextlength-strlen(msg)-1);
      write(gdata.ircserver, msg, strlen(msg));
      }
   else if (gdata.exiting)
     return;
   else {
      if (gdata.debug > 0)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_MAGENTA,"<QUE<: %s",msg);
      found=0;
      for (i=0; (!found && i<MAXSENDQ); i++)
         if (gdata.serverq[i] == NULL) {
            found=1;
            gdata.serverq[i] = mycalloc(strlen(msg)+2);
            strncpy(gdata.serverq[i],msg,strlen(msg)+1);
            }
      if (!found) {
         if (!gdata.attop) gototop();
         outerror(OUTERROR_TYPE_WARN,"Server Queue Is Full!! Are We Being Flooded??");
         }
      }
   }

void sendserver(void) {
   int i,j,count,curnum,howmany,temp1,sendmsg1;
   char *tempstr;
   
   sendmsg1 = gdata.curtime%3;
   curnum = gdata.curtime%30;
   
   if (gdata.serverq[0] == NULL && gdata.exiting && !gdata.recentsent) {
      FD_CLR(gdata.ircserver, &gdata.readset);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.ircserver, SHUT_RDWR);
      close(gdata.ircserver);
      gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
      highestsock();
      ioutput(CALLTYPE_NORMAL, OUT_S|OUT_D, COLOR_NO_COLOR,
              "Connection to %s (%s) Closed",
              gdata.curserverip,
              gdata.curserveractualname ? gdata.curserveractualname : "<unknown>");
      return;
      }
   
   if (gdata.serverq[0] == NULL || gdata.serverstatus != SERVERSTATUS_CONNECTED) {
      gdata.serversent[curnum] = 0;
      return;
      }
   
   temp1 = -gdata.serversent[curnum];
   for (i=0; i<30; i++)
     {
       temp1 += gdata.serversent[i];
     }
   
   if (temp1 > EXCESS_LEVEL_0) howmany = 0;
   else if (temp1 > EXCESS_LEVEL_1) howmany = 1;
   else if (temp1 > EXCESS_LEVEL_2) howmany = 2;
   else if (temp1 > EXCESS_LEVEL_3) howmany = 3;
   else howmany = 4;
   
   count=0;
   for (i=0; i<howmany; i++)
      if (gdata.serverq[0] != NULL) {
         if (!gdata.attop) gototop();
         if (gdata.debug > 0)
            ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_MAGENTA,"<IRC<: %s",gdata.serverq[0]);
         write(gdata.ircserver, gdata.serverq[0], strlen(gdata.serverq[0]));
         write(gdata.ircserver, "\n", 1);
         
         mydelete(gdata.serverq[0]);
         for (j=1; j<MAXSENDQ && gdata.serverq[j]; j++)
            gdata.serverq[j-1] = gdata.serverq[j];
         gdata.serverq[j-1] = NULL;
         
         if (j>srvqnotify && !sendmsg1) {
            tempstr = mycalloc(maxtextlength);
            outerror(OUTERROR_TYPE_WARN,"Server Queue Is Getting Big (%i Lines)",j);
            mydelete(tempstr);
            }
         count++;
         if (gdata.serverq[0] == NULL)
            gdata.recentsent = 6;
         else
            gdata.recentsent = 0;
         }

   gdata.serversent[curnum] = count;
   }

void getxdccconfig(const char *filename) {
   char *templine1 = mycalloc(maxtextlength);
   char *templine2 = mycalloc(maxtextlength);
   char *templine3 = mycalloc(maxtextlength);
   char *templine4 = mycalloc(maxtextlength);
   char *templine5 = mycalloc(maxtextlength);
   char *templine6 = mycalloc(maxtextlength);
   char *msg;
   int ok,i,count;
   int filedescriptor,xfiledescriptor;
   struct stat st;
   
   updatecontext();

   printf("*** Loading %s ... \n",filename);
   
   filedescriptor=open(filename, O_RDONLY | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS);
   if (filedescriptor < 0)
      outerror(OUTERROR_TYPE_CRASH,"Cant Access XDCC File '%s': %s",filename,strerror(errno));
   
   if (getfline(templine1,filedescriptor,0) != NULL) {            
      ok = 0;
      
      msg = getpart(templine1,6);
      if (msg) {
         gdata.record=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
         
      msg = getpart(templine1,7);
      if (msg) {
         gdata.sentrecord=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      gdata.totalsent=0;
      msg = getpart(templine1,8);
      if (msg) {
         gdata.totalsent=atoull(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      gdata.totaluptime=0;
      msg = getpart(templine1,9);
      if (msg) {
         gdata.totaluptime=atol(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      
      if (ok) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Invalid First Line, Reverting Values to 0");
         gdata.record = gdata.sentrecord = 0.0;
         gdata.totalsent = 0;
	 gdata.totaluptime = 0;
         }
      
      /* old format */
      msg = getpart(templine1,10);
      if (msg) {
         gdata.totaluptime=atol(msg);
         mydelete(msg);
         
         msg = getpart(templine1,9);
         if (msg) {
            gdata.totalsent=atoull(msg);
            mydelete(msg);
            }
      
         }
      
      }
   else {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Empty XDCC File, Starting With No Packs Offered");
      gdata.numpacks=0;
   
      gdata.slotsfull=0;
      close(filedescriptor);

      mydelete(templine1);
      mydelete(templine2);
      mydelete(templine3);
      mydelete(templine4);
      mydelete(templine5);
      mydelete(templine6);
      return;
      }

   ok=0;
   count=0;
   
   while (getfline(templine1,filedescriptor,1) != NULL) {
   
      if (getfline(templine1,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine2,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine3,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine4,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine5,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine6,filedescriptor,0) == NULL)  ok++;
      
      if (ok)
         outerror(OUTERROR_TYPE_CRASH,"XDCC file syntax error (missing/extra line)");
      
      if (count >= MAXXDCCS)
        {
          outerror(OUTERROR_TYPE_CRASH,"XDCC file has too many packs");
        }
      
      for (i=strlen(templine1)-1; i>2 && templine1[i] == ' '; i--)
         templine1[i] = '\0';
      for (i=strlen(templine2)-1; i>2 && templine2[i] == ' '; i--)
         templine2[i] = '\0';
      for (i=strlen(templine3)-1; i>2 && templine3[i] == ' '; i--)
         templine3[i] = '\0';
      for (i=strlen(templine4)-1; i>2 && templine4[i] == ' '; i--)
         templine4[i] = '\0';
      for (i=strlen(templine5)-1; i>2 && templine5[i] == ' '; i--)
         templine5[i] = '\0';
      for (i=strlen(templine6)-1; i>2 && templine6[i] == ' '; i--)
         templine6[i] = '\0';

      if ( templine1[3] != 'f' || templine1[4] != 'i' || templine1[5] != 'l' || templine1[6] != 'e' ) ok++;
      if ( templine2[3] != 'd' || templine2[4] != 'e' || templine2[5] != 's' || templine2[6] != 'c' ) ok++;
      if ( templine3[3] != 'n' || templine3[4] != 'o' || templine3[5] != 't' || templine3[6] != 'e' ) ok++;
      if ( templine4[3] != 'g' || templine4[4] != 'e' || templine4[5] != 't' || templine4[6] != 's' ) ok++;
      if ( templine5[3] != 'm' || templine5[4] != 'i' || templine5[5] != 'n' || templine5[6] != 's' ) ok++;
      if ( templine6[3] != 'm' || templine6[4] != 'a' || templine6[5] != 'x' || templine6[6] != 's' ) ok++;
      
      if (ok)
         outerror(OUTERROR_TYPE_CRASH,"XDCC file syntax error (incorrect order?)");
      
      for (i=8; i<sstrlen(templine1); i++)
         templine1[i-8] = templine1[i];
      templine1[i-8]='\0';
      for (i=8; i<sstrlen(templine2); i++)
         templine2[i-8] = templine2[i];
      templine2[i-8]='\0';
      for (i=8; i<sstrlen(templine3); i++)
         templine3[i-8] = templine3[i];
      templine3[i-8]='\0';
      for (i=8; i<sstrlen(templine4); i++)
         templine4[i-8] = templine4[i];
      templine4[i-8]='\0';
      for (i=8; i<sstrlen(templine5); i++)
         templine5[i-8] = templine5[i];
      templine5[i-8]='\0';
      for (i=8; i<sstrlen(templine6); i++)
         templine6[i-8] = templine6[i];
      templine6[i-8]='\0';
      
      gdata.xdccs[count] = mycalloc(sizeof(xdcc));
      
      gdata.xdccs[count]->file = mycalloc(strlen(templine1)+1);
      strcpy(gdata.xdccs[count]->file,templine1);
      convert_to_unix_slash(gdata.xdccs[count]->file);

      gdata.xdccs[count]->desc = mycalloc(strlen(templine2)+1);
      strcpy(gdata.xdccs[count]->desc,templine2);
      
      gdata.xdccs[count]->note = mycalloc(strlen(templine3)+1);
      strcpy(gdata.xdccs[count]->note,templine3);
      
      gdata.xdccs[count]->gets     = atoi(templine4);
      
      gdata.xdccs[count]->minspeed = gdata.overallminspeed;
      if ( atof(templine5) > 0)
         gdata.xdccs[count]->minspeed = atof(templine5);
            
      gdata.xdccs[count]->maxspeed = gdata.transfermaxspeed;
      if ( atof(templine6) )
         gdata.xdccs[count]->maxspeed = atof(templine6);
      
      xfiledescriptor=open(gdata.xdccs[count]->file, O_RDONLY | ADDED_OPEN_FLAGS);
      if (xfiledescriptor < 0)
        {
          outerror(OUTERROR_TYPE_WARN,"Cant Access Offered File '%s': %s",
                   gdata.xdccs[count]->file,strerror(errno));
          memset(&st,0,sizeof(st));
        }
      else if (fstat(xfiledescriptor,&st) < 0)
        {
          outerror(OUTERROR_TYPE_WARN,"Cant Access Offered File Details '%s': %s",
                   gdata.xdccs[count]->file,strerror(errno));
          memset(&st,0,sizeof(st));
        }
      
      gdata.xdccs[count]->st_size  = st.st_size;
      gdata.xdccs[count]->st_dev   = st.st_dev;
      gdata.xdccs[count]->st_ino   = st.st_ino;
      gdata.xdccs[count]->mtime    = st.st_mtime;
      
      if ( gdata.xdccs[count]->st_size == 0 )
        {
          outerror(OUTERROR_TYPE_WARN,"The file \"%s\" has size of 0 bytes!",
                   gdata.xdccs[count]->file);
        }

      if ( gdata.xdccs[count]->st_size > gdata.max_file_size )
        {
          outerror(OUTERROR_TYPE_CRASH,"The file \"%s\" is too large!",
                   gdata.xdccs[count]->file);
        }

      if (xfiledescriptor >= 0)
        {
          close(xfiledescriptor);
        }
      
      count++;
      }
   
   gdata.numpacks=count;
   
   gdata.slotsfull=0;
   
   if (!gdata.totalsent)
      for (i=0; i<MAXXDCCS; i++)
         if (gdata.xdccs[i])
            gdata.totalsent += ((unsigned long long)gdata.xdccs[i]->gets)*((unsigned long long)gdata.xdccs[i]->st_size);

   close(filedescriptor);
   
   mydelete(templine1);
   mydelete(templine2);
   mydelete(templine3);
   mydelete(templine4);
   mydelete(templine5);
   mydelete(templine6);

   }


/* 'Sanitize' the filename in full, putting the sanitized copy into copy. */
void getsendname(char * const full, char * copy)
{
  int i, lastslash;
  
  updatecontext();
  
  lastslash = -1;
  for (i = 0 ; i < sstrlen(full) ; i++)
    {
      if (full[i] == '/' || full[i] == '\\')
        {
          lastslash = i;
        }
    }
  
  strncpy(copy, full+lastslash+1, maxtextlength - 1);
  
  /* replace any evil characters in the filename with underscores */
  for (i = 0; i < sstrlen(copy); i++)
    {
      if (copy[i] == ' ' || copy[i] == '|' || copy[i] == ':' || copy[i] == '*' ||
          copy[i] == '?' || copy[i] == '<' || copy[i] == '>')
        {
          copy[i] = '_';
        }
    }
}

char* getfilename(char * const full) {
   int i,lastslash;
   
   updatecontext();

   lastslash = -1;
   for (i=0; i<sstrlen(full); i++)
      if (full[i] == '/' || full[i] == '\\')
         lastslash=i;
   
   return full+lastslash+1;
   }

void pingserver(void) {
   char *tempstr = mycalloc(maxtextlength);

   updatecontext();

   snprintf(tempstr, maxtextlength-2, "PING %s",
            gdata.curserveractualname ? gdata.curserveractualname : gdata.curserverip);
   writeserver2(tempstr, 1);
   mydelete(tempstr);
   }

static void xdccsavetext(void)
{
  char *filename, *tmpfilename;
  int filedescriptor;
  userinput *uxdl;
  
  updatecontext();
  
  filename = mycalloc(strlen(gdata.xdccfile)+5);
  tmpfilename = mycalloc(strlen(gdata.xdccfile)+9);
  
  snprintf(filename,maxtextlength-1,"%s.txt",gdata.xdccfile);
  snprintf(tmpfilename,maxtextlength-1,"%s.txt.tmp",gdata.xdccfile);
  
  filedescriptor = open(tmpfilename,
                        O_WRONLY | O_CREAT | O_TRUNC | ADDED_OPEN_FLAGS,
                        CREAT_PERMISSIONS);
  if (filedescriptor < 0)
    {
      outerror(OUTERROR_TYPE_CRASH,
               "Cant Create XDCC Text File '%s': %s",
               tmpfilename, strerror(errno));
    }
  
  uxdl = mycalloc(sizeof(userinput));
  
  u_fillwith_msg(uxdl,NULL,"A A A A A xdl");
  uxdl->method = method_fd; 
  uxdl->fd = filedescriptor;
  
  u_parseit(uxdl);
  
  mydelete(uxdl);
  
  close(filedescriptor);
  
  /* rename new -> current */
  rename(tmpfilename,filename);
  
  mydelete(filename);
  mydelete(tmpfilename);
}
  
void xdccsave(int autosave) {
   char *tempstr, *tmpfilename, *bkupfilename;
   int i, filedescriptor, p;

   updatecontext();

   if (autosave && gdata.noautosave > gdata.curtime ) return;
   
   tempstr = mycalloc(maxtextlength);
   tmpfilename = mycalloc(strlen(gdata.xdccfile)+5);
   bkupfilename = mycalloc(strlen(gdata.xdccfile)+6);
   
   snprintf(tmpfilename,maxtextlength-1,"%s.tmp",gdata.xdccfile);
   snprintf(bkupfilename,maxtextlength-1,"%s.bkup",gdata.xdccfile);
   
   if (autosave)
      ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_D,COLOR_NO_COLOR,"XDCC Autosave: Saving... ");
   else
      ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_D,COLOR_NO_COLOR,"XDCC Save: Saving... ");
   
   filedescriptor=open(tmpfilename, O_WRONLY | O_CREAT | O_TRUNC | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS);
   if (filedescriptor < 0) outerror(OUTERROR_TYPE_CRASH,"Cant Create XDCC File '%s': %s",tmpfilename,strerror(errno));
   
   snprintf(tempstr,(maxtextlength*2)-2,"Do Not Edit This File: %1.2f %1.2f %lu%09lu %li\n",
	     gdata.record,
	     gdata.sentrecord,
	     (unsigned long)(gdata.totalsent/1000000000),
	     (unsigned long)(gdata.totalsent%1000000000),
	     gdata.totaluptime);
   write(filedescriptor,tempstr,strlen(tempstr));
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
      
      snprintf(tempstr,maxtextlength-2,"\n"
              "xx_file %s\n" "xx_desc %s\n"
              "xx_note %s\n" "xx_gets %i\n",
              gdata.xdccs[p]->file, gdata.xdccs[p]->desc,
              gdata.xdccs[p]->note, gdata.xdccs[p]->gets );
      write(filedescriptor,tempstr,strlen(tempstr));
              
      if ( gdata.xdccs[p]->minspeed > 0 && gdata.overallminspeed != gdata.xdccs[p]->minspeed)
         snprintf(tempstr,maxtextlength-2,"xx_mins %1.1f\n",gdata.xdccs[p]->minspeed );
      else
         snprintf(tempstr,maxtextlength-2,"xx_mins \n" );
      write(filedescriptor,tempstr,strlen(tempstr));
      
      if ( gdata.xdccs[p]->maxspeed > 0 && gdata.transfermaxspeed != gdata.xdccs[p]->maxspeed)
         snprintf(tempstr,maxtextlength-2,"xx_maxs %1.1f\n",gdata.xdccs[p]->maxspeed );
      else
         snprintf(tempstr,maxtextlength-2,"xx_maxs \n" );
      write(filedescriptor,tempstr,strlen(tempstr));
      
      }
   close(filedescriptor);

   /* remove old bkup */
   unlink(bkupfilename);
   /* backup old -> bkup */
   link(gdata.xdccfile, bkupfilename);
   /* rename new -> current */
   rename(tmpfilename,gdata.xdccfile);
   
   xdccsavetext();
   
   ioutput(CALLTYPE_MULTI_END,OUT_S|OUT_D,COLOR_NO_COLOR,"Done");
   
   mydelete(tempstr);
   mydelete(tmpfilename);
   mydelete(bkupfilename);
   }

void writepidfile (const char *filename) {
   char *tempstr2 = mycalloc(maxtextlengthshort);
   int filedescriptor;
   
   updatecontext();

   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Writing pid file...");
   
   filedescriptor=open(filename, O_WRONLY | O_TRUNC | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS);
   if (filedescriptor < 0) outerror(OUTERROR_TYPE_CRASH,"Cant Create PID File '%s': %s",filename,strerror(errno));
   
   snprintf(tempstr2,maxtextlengthshort,"%i\n",getpid());
   write(filedescriptor,tempstr2,strlen(tempstr2));
   
   close(filedescriptor);
   
   mydelete(tempstr2);
   }

char* getfline(char* str, int descr, int ret)
{
  char tempbuf[maxtextlength];
  int i, j, len;
  
  updatecontext();
  
  j = 0;
  strncpy(str,"",2);
  
  while((len = read(descr,tempbuf,maxtextlength)) > 0)
    {
      for (i=0; i<len; i++)
        {
          if (tempbuf[i] == '\n' || tempbuf[i] == 13) /* 13 is ^M */
            {
              lseek(descr, (off_t)(1-(len-i)), SEEK_CUR);
              str[j] = '\0';
              j = 0;
              if (strlen(str) != 0 )
                {
                  return str;
                }
              else if ( ret )
                {
                  return str;
                }
              else
                {
                  return NULL;
                }
            }
          else
            {
              str[j] = tempbuf[i];
              j++;
            }
        }
    }
  return NULL;
}

void gobackground(void) {
   int s,i;

   updatecontext();

   printf("\n*** Entering Background Mode\n"
          "*** All Commands must be issued by remote administration\n");
   fflush(stdout);
   fflush(stderr);
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(OUTERROR_TYPE_CRASH,"Unable to Fork");
   else if (s > 0) {
      /* parent exits */
      exit(0);
      }

/*   struct rlimit r = { 0 }; */
/*   r.rlim_max = 0; */
/*   s = getrlimit(RLIMIT_NOFILE, &r); */
/*   if ( r.rlim_max < 1 || s < 0) */
/*      outerror(OUTERROR_TYPE_CRASH,"Couldn't get rlimit"); */
   
   for (i=0; i<3; i++) close(i);
/*   for (i=0; i< r.rlim_max; i++) close(i); */
   
   s = setsid();
   if (s < 0)
      outerror(OUTERROR_TYPE_CRASH,"Couldn't setsid");
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(OUTERROR_TYPE_CRASH,"Unable to Fork");
   else if (s > 0)
      /* parent exits */
      exit(0);
   
   
   /* background continues... */
   
/*   umask(0); */
   s = open("/dev/null", O_RDWR); /* stdin */
   dup(s);                        /* stdout */
   dup(s);                        /* stderr */
   
   mylog(CALLTYPE_NORMAL,"Entered Background Mode");
   gdata.background = 2;
   
/*   execlp(program,"iroffer","--background-mode--",config,NULL); */
/*   exit(0); */
   
   }

#if !defined(NO_SIGINFO)
static void iroffer_signal_handler(int signo, siginfo_t *sinfo, void *unused)
#else
static void iroffer_signal_handler(int signo)
#endif
{
  switch (signo)
    {
    case SIGTERM:
    case SIGINT:
      if (gdata.needsshutdown)
        {
          /* must be stuck in a loop somewhere, force exit here */
          
          if (!gdata.background)
            {
              printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
            }
          
          mylog(CALLTYPE_NORMAL,"iroffer exited (signal forced!)\n\n");
          printf("iroffer exited (signal forced!)\n");
          
          if (gdata.pidfile)
            {
              unlink(gdata.pidfile);
            }
          
          exit(0);
        }
      else
        {
          gdata.needsshutdown++;
        }
      break;
      
    case SIGUSR1:
      gdata.needsswitch++;
      break;
      
    case SIGUSR2:
      gdata.needsrehash++;
      break;
      
    case SIGABRT:
    case SIGBUS:
    case SIGILL:
    case SIGFPE:
    case SIGSEGV:
    default:
      {
        sigset_t ss;
#if !defined(NO_SIGINFO)
#if !defined(NO_SIGCODES)
        const char *code;
#endif
#endif
        
        ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                "!!! iroffer has received a fatal signal. !!!");
        ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                "Signal %d (%s)", signo, strsignal(signo));
        
#if !defined(NO_SIGINFO)
        switch (signo)
          {
          case SIGBUS:
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Faulting Address: 0x%.8lX", (unsigned long)sinfo->si_addr);
#if !defined(NO_SIGCODES)
            switch (sinfo->si_code)
              {
              case BUS_ADRALN:
                code = "invalid address alignment";
                break;
                
              case BUS_ADRERR:
                code = "non-existant physical address";
                break;
                
              case BUS_OBJERR:
                code = "object specific hardware error";
                break;
                
              default:
                code = "Unknown";
                break;
                
              }
            
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                    "Code: %s",code);
#endif
            break;
            
          case SIGILL:
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Faulting Address: 0x%.8lX", (unsigned long)sinfo->si_addr);
#if !defined(NO_SIGCODES)
            switch (sinfo->si_code)
              {
              case ILL_ILLOPC:
                code = "illegal opcode";
                break;
                
              case ILL_ILLOPN:
                code = "illegal operand";
                break;
                
              case ILL_ILLADR:
                code = "illegal addressing mode";
                break;
                
              case ILL_ILLTRP:
                code = "illegal trap";
                break;
                
              case ILL_PRVOPC:
                code = "privileged opcode";
                break;
                
              case ILL_PRVREG:
                code = "privileged register";
                break;
                
              case ILL_COPROC:
                code = "coprocessor error";
                break;
                
              case ILL_BADSTK:
                code = "internal stack error";
                break;
                
              default:
                code = "Unknown";
                break;
                
              }
            
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                    "Code: %s",code);
#endif
            break;
            
          case SIGFPE:
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Faulting Address: 0x%.8lX", (unsigned long)sinfo->si_addr);
#if !defined(NO_SIGCODES)
            switch (sinfo->si_code)
              {
              case FPE_INTDIV:
                code = "integer divide by zero";
                break;
                
              case FPE_INTOVF:
                code = "integer overflow";
                break;
                
              case FPE_FLTDIV:
                code = "floating point divide by zero";
                break;
                
              case FPE_FLTOVF:
                code = "floating point overflow";
                break;
                
              case FPE_FLTUND:
                code = "floating point underflow";
                break;
                
              case FPE_FLTRES:
                code = "floating point inexact result";
                break;
                
              case FPE_FLTINV:
                code = "floating point invalid operation";
                break;
                
              case FPE_FLTSUB:
                code = "subscript out of range";
                break;
                
              default:
                code = "Unknown";
                break;
                
              }
            
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                    "Code: %s",code);
#endif
            break;
            
          case SIGSEGV:
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Faulting Address: 0x%.8lX", (unsigned long)sinfo->si_addr);
#if !defined(NO_SIGCODES)
            switch (sinfo->si_code)
              {
              case SEGV_MAPERR:
                code = "address not mapped to object";
                break;
                
              case SEGV_ACCERR:
                code = "invalid permissions for mapped object";
                break;
                
              default:
                code = "Unknown";
                break;
                
              }
            
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                    "Code: %s",code);
#endif
            break;
            
          case SIGABRT:
          default:
            break;
            
          }
#endif
        
        ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Context Trace:");
        
        dumpcontext();
        dumpgdata();
        
        ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Crashing... Please report this problem to PMG");
        
        tostdout_disable_buffering(1);
        
        if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
        
        signal(signo, SIG_DFL);
        sigemptyset(&ss);
        sigaddset(&ss, signo);
        sigprocmask(SIG_UNBLOCK, &ss, NULL);
        raise(signo);
        /* shouldn't get here */
        exit(1);
      }
    }
  return;
}


char* getuptime(char *str, int type, time_t fromwhen) {
   int days, hours, mins;
   long temp;
   
   updatecontext();

   temp  = (gdata.curtime-fromwhen)/60;
   days  = temp/60/24;
   hours = temp/60 - (24*days);
   mins  = temp - (60*hours) - (24*60*days);
   
   if (type)
      snprintf(str,maxtextlengthshort-2,"%dD %dH %dM",days,hours,mins);
   else
      snprintf(str,maxtextlengthshort-2,"%d Days %d Hrs and %d Min",days,hours,mins);
      
   return str;
   }


void parsestdin(void) {
   int length;
   char* tempbuff1 = mycalloc(maxtextlength);
   userinput ui;
   
   updatecontext();
   
   if (is_fd_readable(fileno(stdin)))
     {
       length = read (fileno(stdin), tempbuff1, maxtextlength-1);
       if (length < 1)
         {
           outerror(OUTERROR_TYPE_CRASH,"read from stdin failed: %s",strerror(errno));
         }
       else
         {
           tempbuff1[length] = '\0';
           
           if (!gdata.attop) gototop();
           gdata.needsclear = strlen(tempbuff1);
           
           u_fillwith_stdin(&ui,tempbuff1);
           u_parseit(&ui);
         }
     }
   
   mydelete(tempbuff1);
   }

void shutdowniroffer(void) {
   int i;
   char *tempstr2;
   char *tempstr = mycalloc(maxtextlength);
   
   updatecontext();

   if (!gdata.attop) gototop();
   
   if ( SAVEQUIT )
      xdccsave(0);
   if ( SAVEQUIT )
      write_ignorefile();
   
   if (gdata.exiting || gdata.serverstatus != SERVERSTATUS_CONNECTED) {
      if (gdata.exiting)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Shutting Down (FORCED)");
      else
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Shutting Down");
      
      mylog(CALLTYPE_NORMAL,"iroffer exited (shutdown)\n\n");

      tostdout_disable_buffering(1);
      if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
      if (gdata.pidfile) unlink(gdata.pidfile);
      exit(0);
      }
   
   
   ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Shutting Down... (Issue \"SHUTDOWN\" again to force quit)");
   
   /* empty queue */
   for (i=0; i<MAXSENDQ; i++)
      gdata.serverq[i] = NULL;
   
   /* close connections */
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
         notice(gdata.trans[i]->nick,"*** Shutting Down. Closing Connection. (Resume Supported)");
      
         FD_CLR(gdata.trans[i]->clientsocket, &gdata.writeset);
         FD_CLR(gdata.trans[i]->clientsocket, &gdata.readset);
         if (gdata.trans[i]->listensocket != FD_UNUSED)
           {
             close(gdata.trans[i]->listensocket);
           }
         if (gdata.trans[i]->clientsocket != FD_UNUSED)
           {
             /*
              * cygwin close() is broke, if outstanding data is present
              * it will block until the TCP connection is dead, sometimes
              * upto 10-20 minutes, calling shutdown() first seems to help
              */
             shutdown(gdata.trans[i]->clientsocket, SHUT_RDWR);
             close(gdata.trans[i]->clientsocket);
           }
         if (gdata.trans[i]->filedescriptor != FD_UNUSED)
           {
             close(gdata.trans[i]->filedescriptor);
           }
         gdata.trans[i]->tr_status = TRANSFER_STATUS_DONE;
         gdata.trans[i]->xpack->gets++;
         
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_YELLOW,"XDCC Transfer to %s Closed",gdata.trans[i]->nick);
         }
   
   /* close upload connections */
   for (i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) {
         notice(gdata.uploads[i]->nick,"*** Shutting Down. Closing Upload Connection. (Resume Supported)");
      
         FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
         FD_CLR(gdata.uploads[i]->clientsocket, &gdata.readset);
         if (gdata.uploads[i]->clientsocket != FD_UNUSED)
           {
             /*
              * cygwin close() is broke, if outstanding data is present
              * it will block until the TCP connection is dead, sometimes
              * upto 10-20 minutes, calling shutdown() first seems to help
              */
             shutdown(gdata.uploads[i]->clientsocket, SHUT_RDWR);
             close(gdata.uploads[i]->clientsocket);
           }
         if (gdata.uploads[i]->filedescriptor != FD_UNUSED)
           {
             close(gdata.uploads[i]->filedescriptor);
           }
         gdata.uploads[i]->ul_status = UPLOAD_STATUS_DONE;
         
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_YELLOW,"Upload Transfer from %s Closed",gdata.uploads[i]->nick);
         }
   
   /* quit */
   tempstr2 = mycalloc(maxtextlengthshort);
   tempstr2 = getuptime(tempstr2,1,gdata.startuptime);
   snprintf(tempstr,maxtextlength-2,
            "QUIT :iroffer v" VERSIONLONG "%s%s - running %s",
            gdata.hideos ? "" : " - ",
            gdata.hideos ? "" : gdata.osstring,
            tempstr2);
   mydelete(tempstr2);
   if (gdata.serverstatus == SERVERSTATUS_CONNECTED)
      writeserver(tempstr);
   
   gdata.exiting = 1;
   
   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_NO_COLOR,"Waiting for Server Queue To Flush...");
   
   if (gdata.dccchat != FD_UNUSED)
     {
       write(gdata.dccchat,"Shutdown Recieved, Closing DCC Chat\n",36);
       FD_CLR(gdata.dccchat, &gdata.readset);
       usleep(100*1000);
       /*
        * cygwin close() is broke, if outstanding data is present
        * it will block until the TCP connection is dead, sometimes
        * upto 10-20 minutes, calling shutdown() first seems to help
        */
       shutdown(gdata.dccchat, SHUT_RDWR);
       close(gdata.dccchat);
       gdata.dccchat = FD_UNUSED;
     }
   
   highestsock();

   mydelete(tempstr);
   }

void switchserver(int which)
{
  char *tempstr = mycalloc(maxtextlength);
  int i, snum;
  float j;
  int retry;
  
  updatecontext();
  
  /* quit */
  if (gdata.serverstatus == SERVERSTATUS_CONNECTED)
    {
      strncpy(tempstr,"QUIT :Changing Servers",maxtextlength-1);
      writeserver2(tempstr,1);
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_RED,"Changing Servers");
      
      FD_CLR(gdata.ircserver, &gdata.readset);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.ircserver, SHUT_RDWR);
      close(gdata.ircserver);
    }
  
  if (gdata.serverstatus == SERVERSTATUS_TRYING)
    {
      FD_CLR(gdata.ircserver, &gdata.readset);
      close(gdata.ircserver);
    }
  
  gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
  highestsock();
   
  if ( which >= 0 && which < MAXSRVS && gdata.server[which] )
    {
      /* manual jump */
      if (!connectirc(gdata.server[which]))
        {
          gdata.serverconnectbackoff++;
          gdata.serverstatus = SERVERSTATUS_TRYING;
        }
    }
  
  for (i=0; gdata.server[i] && i<MAXSRVS; i++);
  j = (float)i;
  retry = i;
  
  snum = (int) (j*rand()/(RAND_MAX+0.0));
  
  /* weird problem? */
  if (snum > i || snum < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"rand() returned out of range value, it broke!?!?");
    }
  
  while (snum > i || snum < 0)
    {
      if (snum < 0) snum += i;
      if (snum > i) snum -= i;
    }
  
  gdata.serverconnectbackoff++;
  
  while ((gdata.serverstatus == SERVERSTATUS_NEED_TO_CONNECT) && retry--)
    {
      if (!connectirc(gdata.server[snum]))
        {
          /* good */
          gdata.serverstatus = SERVERSTATUS_TRYING;
          highestsock();
        }
      else
        {
          /* fail */
          snum++;
          snum %= i;
        }
    }
  
  gdata.servertime = 0;
  mydelete(tempstr);
}

char* getstatusline(char *str) {
   int i,count,srvq;
   
   updatecontext();

   count = 0;
   for (i=0; i<120; i++)
      count += gdata.xdccsent[i];
   
   for (srvq=0; gdata.serverq[srvq] && srvq<MAXSENDQ; srvq++);
   
   snprintf(str,maxtextlength-2,"Stat: %i/%i Sls, %i/%i,%i/%i Q, %1.1fK/s Rcd, %i SrQ (Bdw: %iK, %1.1fK/s, %1.1fK/s Rcd)",
      gdata.slotsfull,gdata.slotsmax,gdata.inqueue,gdata.queuesize,gdata.inslotsmaxqueue,gdata.slotsmaxqueue,
      gdata.record,srvq,count/1024,((float)count)/120.0/1024.0,gdata.sentrecord);
   
   return str;
   
   }

char* getstatuslinenums(char *str) {
   int i,count,gcount,srvq;
   float scount,ocount;
   
   updatecontext();

   count = 0;
   for (i=0; i<120; i++)
      count += gdata.xdccsent[i];
   
   for (srvq=0; gdata.serverq[srvq]; srvq++);
   
   gcount = 0;
   scount = ocount = 0;
   for (i=0; i<MAXXDCCS; i++)
      if (gdata.xdccs[i]) {
         gcount += gdata.xdccs[i]->gets;
         ocount += (float)gdata.xdccs[i]->st_size;
         scount += ((float)gdata.xdccs[i]->gets)*((float)gdata.xdccs[i]->st_size);
         }
   
   snprintf(str,maxtextlength-2,"stat %i %1.0f %i %1.0f %i %i %i %i %i %i %1.1f %i %i %1.1f %1.1f",
      gdata.numpacks,ocount/1024/1024,gcount,scount/1024/1024,
      gdata.slotsfull,gdata.slotsmax,gdata.inqueue,gdata.queuesize,gdata.inslotsmaxqueue,gdata.slotsmaxqueue,
      gdata.record,srvq,count/1024,((float)count)/120.0/1024.0,gdata.sentrecord);
   
   return str;
   
   }

void sendxdlqueue (void) {
   int i;
   char *tempstr;
   userinput ui;
   
   updatecontext();

   if (!(gdata.xlistqueue[0])) return;
   
   tempstr = mycalloc(maxtextlength);
   
   tempstr[0] = '\0';
   strncat(tempstr,gdata.xlistqueue[0],maxtextlength-strlen(tempstr)-1);
   for (i=1; i<MAXXLQUE && gdata.xlistqueue[i]; i++) {
      strncat(tempstr,",",maxtextlength-strlen(tempstr)-1);
      strncat(tempstr,gdata.xlistqueue[i],maxtextlength-strlen(tempstr)-1);
      }
   
   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_YELLOW,"Sending XDCC LIST to: %s",tempstr);
   
   u_fillwith_msg(&ui,tempstr,"A A A A A xdl");
   ui.method = method_xdl_user;
   u_parseit(&ui);
   
   for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++)
      mydelete(gdata.xlistqueue[i]);
   
   mydelete(tempstr);
   }

int isthisforme (const char *dest, char *msg1) {
   if (!msg1 || !dest) { outerror(OUTERROR_TYPE_WARN_LOUD,"isthisforme() got NULL value"); return 1; }
   
   
   if (
         !strcmp(msg1,"\1CLIENTINFO") || !strcmp(msg1,"\1CLIENTINFO\1")
      || !strcmp(msg1,"\1PING") || !strcmp(msg1,"\1PING\1") 
      || !strcmp(msg1,"\1VERSION") || !strcmp(msg1,"\1VERSION\1")
      || !strcmp(msg1,"\1UPTIME") || !strcmp(msg1,"\1UPTIME\1") 
      || !strcmp(msg1,"\1STATUS") || !strcmp(msg1,"\1STATUS\1")
      || (!strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"\1DCC"))
      || (!strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"ADMIN"))
      || (!strcmp(gdata.caps_nick,dest) && (!strcmp(caps(msg1),"XDCC") || !strcmp(msg1,"\1XDCC") || !strcmp(caps(msg1),"CDCC") || !strcmp(msg1,"\1CDCC")))
      || !strcmp(dest,gdata.caps_nick)
      ) return 1;
   
   return 0;
   
   }

void initvars(void)
{
  memset(&gdata, 0, sizeof(gdata_t));

  gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
  gdata.dccchat = FD_UNUSED;
  gdata.dccchatlisten = FD_UNUSED;
  gdata.logfd = FD_UNUSED;
  gdata.logstats = 1;
  gdata.dccrangestart = 4000;
  gdata.overallmaxspeeddaydays = 0x7F; /* all days */
  gdata.maxtransfersperperson = 1;
  gdata.connectionmethod.how = how_direct;
  gdata.notifytime = 5;
  gdata.termcols = 80;
  gdata.termlines = 24;
  
#if defined(_FILE_OFFSET_BITS) && (_FILE_OFFSET_BITS == 64)
  /* 4GB max size */
  /* NOTE: DCC protocol can't handle more than 32bit file size, 4GB is it, sorry */
  gdata.max_file_size = (4*1024*1024*1024UL)-1;
#else
  /* 2GB max size */
  gdata.max_file_size = (2*1024*1024*1024UL)-1;
#endif
  
  gdata.startuptime = gdata.curtime = time(NULL);
  
  gdata.sendbuff = mycalloc(BUFFERSIZE);
  
  return;
}
   
void startupiroffer(void) {
   char *tempstr23, *tempstr;
#if !defined(NO_SETUID)
   uid_t runasuid = 0;
   gid_t runasgid = 0;
   gid_t *groups = NULL;
   int ngroups = 0;
   int ii;
#endif
   struct sigaction sa;
   struct rlimit rlim;
   int callval;
   
   updatecontext();
   
   srand((unsigned int)( (getpid()*5000) + (gdata.curtime%5000) ));
   
   if (!gdata.background) {
      initscreen();
      gotobot();
      gototop();
      }
   
   printf("\n");
   if (!gdata.background && !gdata.nocolor) printf("\x1b[1;33m");
   printf("Welcome to iroffer by PMG - http://iroffer.org/\n"
          "Version " VERSIONLONG "\n");
   if (!gdata.background && !gdata.nocolor) printf("\x1b[0m");
   printf("\n");
   
   /* signal handling */
   memset(&sa, 0, sizeof(sa));
   
#if !defined(NO_SIGINFO)
   sa.sa_sigaction = iroffer_signal_handler;
   sa.sa_flags = SA_SIGINFO;
#else
   sa.sa_handler = iroffer_signal_handler;
#endif
   sigfillset(&sa.sa_mask);
   
   sigaction(SIGBUS, &sa, NULL);
   sigaction(SIGABRT, &sa, NULL);
   sigaction(SIGILL, &sa, NULL);
   sigaction(SIGFPE, &sa, NULL);
   sigaction(SIGSEGV, &sa, NULL);
   
   sigaction(SIGTERM, &sa, NULL);
   sigaction(SIGINT, &sa, NULL);
   sigaction(SIGUSR1, &sa, NULL);
   sigaction(SIGUSR2, &sa, NULL);

   signal(SIGPIPE,SIG_IGN);
   signal(SIGALRM,SIG_IGN);
   signal(SIGHUP,SIG_IGN);
   signal(SIGTSTP,SIG_IGN);
   
   printf("*** iroffer is distributed under the GNU General Public License.\n"
          "***    please see the README for more information.\n");

   printf("\n*** Starting up...\n");
   
#if !defined(NO_SETUID)
   if (gdata.dosetuid) {
      struct passwd *pw_ent = NULL;
      if( (pw_ent = getpwnam( gdata.runasuser )) == NULL)
         if( (pw_ent = getpwuid( atoi( gdata.runasuser ) )) == NULL)
            outerror( OUTERROR_TYPE_CRASH, "Can't lookup user: %s", strerror(errno) );
      runasuid = pw_ent->pw_uid;
      runasgid = pw_ent->pw_gid;

#if defined(NO_GETGROUPLIST)
      ngroups = 1;
      groups = mycalloc(sizeof (gid_t));
      groups[0] = runasgid;
#else
      ngroups = 16;
      groups = mycalloc(ngroups * sizeof (gid_t));
      
      if (getgrouplist (pw_ent->pw_name, pw_ent->pw_gid, groups, &ngroups) < 0)
        {
          mydelete(groups);
          groups = mycalloc(ngroups * sizeof (gid_t));
          if (getgrouplist(pw_ent->pw_name, pw_ent->pw_gid, groups, &ngroups) < 0)
            {
              outerror( OUTERROR_TYPE_CRASH, "Can't lookup group list: %s", strerror(errno) );
            }
        }
#endif

   }
#endif

#if !defined(NO_CHROOT)
   if (gdata.dochroot) {
      printf( "*** Changing root filesystem to '%s'\n", gdata.chrootdir );
      if( chroot( gdata.chrootdir ) < 0 ) {
		   outerror( OUTERROR_TYPE_CRASH, "Can't chroot: %s", strerror(errno));
      }
      if( chdir("/") < 0 ) {
        outerror( OUTERROR_TYPE_CRASH, "Can't chdir: %s", strerror(errno) );
      }
   }
#endif
#if !defined(NO_SETUID)
   if (gdata.dosetuid) {
      
      printf( "*** Dropping root privileges to user %s (%u/%u, groups:",
              gdata.runasuser, (unsigned int)runasuid, (unsigned int)runasgid );
      for (ii=0; ii<ngroups; ii++)
        {
          printf(" %d", (int)groups[ii]);
        }
      printf( ").\n");
      
      if (setgid(runasgid) < 0)
        {
          outerror(OUTERROR_TYPE_CRASH,"Can't change group: %s", strerror(errno));
        }
      if (setgroups(ngroups,groups) < 0)
        {
          outerror(OUTERROR_TYPE_CRASH,"Can't set group list: %s", strerror(errno));
        }
      if (setuid(runasuid) < 0)
        {
          outerror(OUTERROR_TYPE_CRASH,"Can't change to user: %s", strerror(errno));
        }
      mydelete(groups);
   }
#endif

   if (geteuid() == 0)
     {
       outerror(
#if BLOCKROOT
		OUTERROR_TYPE_CRASH,
#else
		OUTERROR_TYPE_WARN_LOUD,
#endif
		"iroffer should not be run as root!"
		);
     }
   
   if (!gdata.background)
      printf("*** Window Size: %ix%i\n",gdata.termcols,gdata.termlines);
   
   tempstr23 = mycalloc(maxtextlength);
   printf("*** Started on: %s\n",getdatestr(tempstr23,0));
   mydelete(tempstr23);
   
   set_loginname();
   
   /* we can't work with fds higher than FD_SETSIZE so set rlimit to force it */
   
   gdata.max_fds_from_rlimit = FD_SETSIZE;

#ifdef USE_OFILE
   callval = getrlimit(RLIMIT_OFILE, &rlim);
#else
   callval = getrlimit(RLIMIT_NOFILE, &rlim);
#endif
   if (callval >= 0)
     {
       rlim.rlim_cur = min2(rlim.rlim_max, FD_SETSIZE);
       gdata.max_fds_from_rlimit = rlim.rlim_cur;
#ifdef USE_OFILE
       callval = setrlimit(RLIMIT_OFILE, &rlim);
#else
       callval = setrlimit(RLIMIT_NOFILE, &rlim);
#endif
       if (callval < 0)
         {
           outerror(OUTERROR_TYPE_WARN, "Unable to adjust fd limit to %u: %s",
                    (unsigned int)gdata.max_fds_from_rlimit, strerror(errno));
         }
     }
   else
     {
       outerror(OUTERROR_TYPE_WARN, "Unable to read fd limit: %s", strerror(errno));
     }
   
   if (MAX_FDS_TO_MAXTRANS((int)gdata.max_fds_from_rlimit) < 1)
     {
       outerror(OUTERROR_TYPE_CRASH, "fd limit of %u is too small",
                (unsigned int)gdata.max_fds_from_rlimit);
     }
   
   getconfig();
   
   mylog(CALLTYPE_NORMAL,"iroffer started v" VERSIONLONG);

   getxdccconfig(gdata.xdccfile);
   
   getos();
   
   if (gdata.messagefile) {
      tempstr = mycalloc(maxtextlength);
      msglog_howmany(tempstr);
      printf("%s\n",tempstr);
      mydelete(tempstr);
      }

   if (gdata.ignorefile)
      read_ignorefile();

   /* fork to background if in background mode */
   if (gdata.background) gobackground();
   
   if (gdata.pidfile)
      writepidfile(gdata.pidfile);
   
   /* start stdout buffered I/O */
   if (set_socket_nonblocking(fileno(stdout),1) < 0)
     {
       outerror(OUTERROR_TYPE_WARN_LOUD,"Cant set stdout non-blocking!: %s",strerror(errno));
     }
   else
     {
       fflush(stdout);
       gdata.stdout_buffer = mycalloc(STDOUT_BUFFER_SIZE);
       gdata.stdout_buffer_init = 1;
     }
   
   gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
   switchserver(-1);
   highestsock();
   
   }


void isrotatelog(void) {
   time_t then;
   struct tm *lnow = NULL, *lthen = NULL;
   char *newname;
   
   updatecontext();

   lnow = localtime(&gdata.curtime);
   
   if (lnow == NULL || lnow->tm_hour != 0)
      return;
   
   newname = mycalloc(maxtextlength-2);
   if (gdata.logrotate == 1) {
      then = gdata.curtime - 60*60*24;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-%02i-%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_mon+1,lthen->tm_mday);
      if (!doesfileexist(newname)) {
         mylog(CALLTYPE_NORMAL,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Logfile moved (daily) to %s",newname);
         }
      }
   if (gdata.logrotate == 2 && lnow->tm_wday == 0) {
      then = gdata.curtime - 60*60*24*7;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-w%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_yday/7);
      if (!doesfileexist(newname)) {
         mylog(CALLTYPE_NORMAL,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Logfile moved (weekly) to %s",newname);
         }
      }
   if (gdata.logrotate == 3 && lnow->tm_mday == 1) {
      then = gdata.curtime - 60*60*24*2;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_mon+1);
      if (!doesfileexist(newname)) {
         mylog(CALLTYPE_NORMAL,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Logfile moved (monthly) to %s",newname);
         }
      }
   
   
   mydelete(newname);
   }


void createpassword(void) {
#if ENCRYPTPASS
   char pw1[maxtextlengthshort], pw2[maxtextlengthshort];
   int len, ok, saltnum;
   char salt[3], *pwout;
   
   printf("\niroffer v" VERSIONLONG " by PMG\n"
          "  Configuration File Password Generator\n"
          "\n"
          "This will take a password of your choosing and encrypt it.\n"
          "You should place the output this program generates in your config file.\n"
          "You can then use your password you enter here over irc.\n"
          "\n"
          "NOTE: if iroffer crashes after you enter your passowrd, you may need to\n"
          "      disable password encryption.  there are some systems that have a\n"
          "      non-standard crypt() that iroffer doesn't know how to use.\n"
          "      To disable password encryption change ENCRYPTPASS to 0 in defines.h\n"
          "\n"
          "Your password must be between 5 and 8 characters\n");
   
   
   ok = 0;
   while ( !ok ) {
      printf("Please Enter Your Password: "); fflush(stdout);
      
      if ( (len = read(0,pw1,maxtextlengthshort-1)) < 0 )
         { fprintf(stderr,"Couldn't Read Your Password, Try Again\n"); exit(1); }
      if (pw1[len-1] == '\n') { pw1[len-1] = '\0'; len--;}
      
      if ( len < 5 || len > 8 )
         printf("Wrong Length, Try Again\n");
      else
         ok = 1;
   }
   
   printf("And Again for Verification: ");
   fflush(stdout);

   if ( (len = read(0,pw2,maxtextlengthshort-1)) < 0 )
      { fprintf(stderr,"Couldn't Read Your Password, Try Again\n"); exit(1); }
   if (pw2[len-1] == '\n') { pw2[len-1] = '\0'; len--;}
   
   if ( strcmp(pw1,pw2) )
      { fprintf(stderr,"The Password Didn't Match, Try Again\n"); exit(1); }
   
   
   srand((unsigned int)( (getpid()*5000) + (time(NULL)%5000) ));
   saltnum = (int)(4096.0*rand()/(RAND_MAX+0.0));
   salt[0] = inttosaltchar((saltnum>>6) %64);
   salt[1] = inttosaltchar( saltnum     %64);
   salt[2] = '\0';
   
   pwout = crypt(pw1,salt);
   
   if (pwout && strlen(pwout) == 13)
      printf("\n"
             "To use \"%s\" as your password use the following in your config file:\n"
             "adminpass %s\n"
             "\n"
             ,pw1,pwout);
   else
      printf("\n"
             "The crypt() function does not appear to be working correctly\n"
             "You might need to disable password encryption in defines.h and recompile\n"
             "\n");
   
#else
   printf("This binary of iroffer was compiled without encrypted password support. See defines.h\n");
#endif
   }

/* 0 .. 63 */
char inttosaltchar (int n) {
   
   if ( n < 26 )
      return  n + 'a';
   else if ( n < 26*2 )
      return  n - 26 + 'A';
   else if ( n < 26*2+10 )
      return  n - 26 - 26 + '0';
   else if ( n < 26*2+10+1 )
      return  '.';
   else if ( n < 26*2+10+2 )
      return  '/';
   
   return 0; /* error */
   
   }

void notifyqueued(void) {
   int i,j,count;
   unsigned long rtime, lastrtime;
   
   updatecontext();

   if ( !gdata.exiting && (gdata.inqueue || gdata.inslotsmaxqueue)) {
      count = 0;
      for (i=0; i<120; i++)
         count += gdata.xdccsent[i];
      
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_YELLOW,"Notifying %d Queued People (%dK/sec used, %dK/sec limit)",
         gdata.inqueue+gdata.inslotsmaxqueue,count/120/1024,gdata.lowbdwth);

      }
   
   lastrtime=0;
   
   /* if we are sending more than allowed, we need to skip the difference */
   for (i=0; i<gdata.slotsfull-gdata.slotsmax; i++)
     {
       rtime=-1;
       for (j=0; j<MAXTRANS; j++)
	 if (gdata.trans[j]) {
	   int left = min2(359999,(gdata.trans[j]->xpack->st_size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	   if (left > lastrtime && left < rtime)
	     rtime = left;
	 }
       if (rtime < 359999)
	 lastrtime=rtime;
     }
   
   for (i=0; i<gdata.inqueue; i++) {
     
     rtime=-1;
     for (j=0; j<MAXTRANS; j++)
       if (gdata.trans[j]) {
	 int left = min2(359999,(gdata.trans[j]->xpack->st_size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	 if (left > lastrtime && left < rtime)
	   rtime = left;
       }
     if (rtime < 359999)
       lastrtime=rtime;
     
   notice(gdata.mainqueue[i]->nick,"You have been queued for %li hr %li min for \"%s\", currently in main queue position %i of %i. Estimated remaining time is %li hr %li min or %s.  To remove yourself type \"/msg %s xdcc remove\".",
            (long)(gdata.curtime-gdata.mainqueue[i]->queuedtime)/60/60,
            (long)((gdata.curtime-gdata.mainqueue[i]->queuedtime)/60)%60,
            gdata.mainqueue[i]->xpack->desc,
            i+1,
            gdata.inqueue,
	    lastrtime/60/60,
	    (lastrtime/60)%60,
	    (rtime >= 359999) ? "more" : "less",
            gdata.user_nick);
      }
   for (i=0; i<gdata.inslotsmaxqueue; i++) {
   notice(gdata.packqueue[i]->nick,"You have been queued for %li hr %li min for \"%s\", currently in pack queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            (long)(gdata.curtime-gdata.packqueue[i]->queuedtime)/60/60,
            (long)((gdata.curtime-gdata.packqueue[i]->queuedtime)/60)%60,
            gdata.packqueue[i]->xpack->desc,
            i+1,
            gdata.inslotsmaxqueue,
            gdata.user_nick);
      }
   
   
   }

void notifybandwidth(void) {
   int i,j;
   
   updatecontext();

   if (gdata.exiting) return;
   if (!gdata.maxb) return;
   
   
   j = 0;
   for (i=0; i<120; i++)
      j += gdata.xdccsent[i];
   j /= 1024;
   
   /* send if over 90% */
   if ( (j*10) > (gdata.maxb*30*9) ) {
      for (i=0; i<MAXTRANS; i++)
         if (gdata.trans[i] != NULL) {
         notice(gdata.trans[i]->nick,"%s has an overall bandwidth limit. %2.1fKB/sec of %2.1fKB/sec is in use right now. "
           "%s can only send you %2.1fKB/sec even though you are requesting more than that.",
           gdata.user_nick,
           ((float)j)/120.0,
           ((float)gdata.maxb)/4.0,
           gdata.user_nick,
           gdata.trans[i]->lastspeed
           );
         }
      }
   
   }

void notifybandwidthtrans(void) {
   int i;
   
   updatecontext();

   if (gdata.exiting) return;
   
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL
      && !gdata.trans[i]->nomax
      && (gdata.trans[i]->xpack->maxspeed > 0)
      && gdata.curtime-gdata.trans[i]->connecttime > MIN_TL
      && gdata.trans[i]->lastspeed*10 > gdata.trans[i]->xpack->maxspeed*9) {
         /* send if over 90% */
         notice(gdata.trans[i]->nick,"Your pack has a transfer bandwidth limit. "
           "You are using %2.1fKB/sec of %2.1fKB/sec right now.",
           gdata.trans[i]->lastspeed,
           gdata.trans[i]->xpack->maxspeed
           );
         }
   
   }

void write_ignorefile(void) {
   char *tmpfilename, *bkupfilename;
   int fd,i;
   igninfo_file ign_file;
   
   updatecontext();

   if (gdata.ignorefile == NULL)
      return;
   
   tmpfilename = mycalloc(strlen(gdata.ignorefile)+5);
   bkupfilename = mycalloc(strlen(gdata.ignorefile)+6);
   
   snprintf(tmpfilename,maxtextlength-1,"%s.tmp",gdata.ignorefile);
   snprintf(bkupfilename,maxtextlength-1,"%s.bkup",gdata.ignorefile);
   
   ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_D,COLOR_NO_COLOR,"Saving Ignore List... ");
   
   fd=open(tmpfilename, O_WRONLY | O_CREAT | O_TRUNC | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
   if (fd < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Create Ignore File '%s': %s",tmpfilename,strerror(errno));
      mydelete(tmpfilename);
      mydelete(bkupfilename);
      return;
      }
   
   write(fd,&gdata.curtime,sizeof(time_t));
   
   for (i=0; i<MAXIGNL; i++)
     {
       if (gdata.ignorelist[i] && (gdata.ignorelist[i]->flags & IGN_IGNORING))
         {
           memset(&ign_file,0,sizeof(ign_file));
           strncpy(ign_file.hostmask,gdata.ignorelist[i]->hostmask,maxtextlength-1);
           ign_file.flags       = gdata.ignorelist[i]->flags;
           ign_file.bucket      = gdata.ignorelist[i]->bucket;
           ign_file.lastcontact = gdata.ignorelist[i]->lastcontact;
           write(fd,&ign_file,sizeof(igninfo_file));
         }
     }
   
   close(fd);
   
   /* remove old bkup */
   unlink(bkupfilename);
   /* backup old -> bkup */
   link(gdata.ignorefile, bkupfilename);
   /* rename new -> current */
   rename(tmpfilename,gdata.ignorefile);
   
   ioutput(CALLTYPE_MULTI_END,OUT_S|OUT_D,COLOR_NO_COLOR,"Done");
   
   mydelete(tmpfilename);
   mydelete(bkupfilename);
   }

void read_ignorefile(void) {
   int fd,i,end=0;
   time_t whenwritten = 0;
   struct stat st;
   igninfo_file ign_file;
   char *tempstr;
   
   updatecontext();

   if (gdata.ignorefile == NULL)
      return;
   
   ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_D,COLOR_NO_COLOR,"Loading Ignore List... ");
   
   fd=open(gdata.ignorefile, O_RDONLY | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
   if (fd < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Access Ignore File '%s': %s",gdata.ignorefile,strerror(errno));
      return;
      }
   
   if (fstat(fd,&st) < 0 || st.st_size == 0) {
      ioutput(CALLTYPE_MULTI_END,OUT_S|OUT_D,COLOR_NO_COLOR,"Empty, Skipping");
      return;
      }
   
   if (read(fd,&whenwritten,sizeof(time_t)) != sizeof(time_t)) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Read Ignore File Timestamp!: %s",strerror(errno));
      return;
      }
   
   if (whenwritten > gdata.curtime) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Ignore File Timestamp Is In The Future?!@?");
      return;
      }
   
   tempstr = mycalloc(maxtextlength);
   
   for (i=0; i<MAXIGNL && !end; i++)
     {
       if (read(fd,&ign_file,sizeof(igninfo_file)) == sizeof(igninfo_file))
         {
           gdata.ignorelist[i] = mycalloc(sizeof(igninfo));
           gdata.ignorelist[i]->regexp = mycalloc(sizeof(regex_t));
           
           strncpy(gdata.ignorelist[i]->hostmask,ign_file.hostmask,maxtextlength-1);
           gdata.ignorelist[i]->flags       = ign_file.flags;
           gdata.ignorelist[i]->bucket      = ign_file.bucket;
           gdata.ignorelist[i]->lastcontact = ign_file.lastcontact;
           
           gdata.ignorelist[i]->bucket -= (gdata.curtime-whenwritten)/IGN_TL;
           
           strncpy(tempstr,gdata.ignorelist[i]->hostmask,maxtextlength-1);
           hostmasktoregex(tempstr);
           if (regcomp(gdata.ignorelist[i]->regexp,tempstr,REG_ICASE|REG_NOSUB))
             {
               gdata.ignorelist[i]->regexp = NULL;
             }
         }
       else
         {
           end=1;
         }
     }
   
   mydelete(tempstr);
   
   close(fd);
   
   ioutput(CALLTYPE_MULTI_END,OUT_S|OUT_D,COLOR_NO_COLOR,"Done");
   }


void look_for_file_changes(xdcc *xpack)
{
  struct stat st;
  int t;
  
  if (stat(xpack->file,&st) < 0)
    {
      outerror(OUTERROR_TYPE_WARN,
               "File '%s' can no longer be accessed: %s",
               xpack->file, strerror(errno));
      return;
    }
  
  if (st.st_size == 0)
    {
      outerror(OUTERROR_TYPE_WARN,
               "File '%s' has size of 0 bytes", xpack->file);
    }
  
  if ((st.st_size > gdata.max_file_size) || (st.st_size < 0))
    {
      outerror(OUTERROR_TYPE_WARN,
               "File '%s' is too large", xpack->file);
    }
  
  if ((xpack->st_dev != st.st_dev) ||
      (xpack->st_ino != st.st_ino) ||
      (xpack->mtime  != st.st_mtime) ||
      (xpack->st_size  != st.st_size))
    {
      outerror(OUTERROR_TYPE_WARN,
               "File '%s' has changed", xpack->file);
      
      xpack->st_dev   = st.st_dev;
      xpack->st_ino   = st.st_ino;
      xpack->mtime    = st.st_mtime;
      xpack->st_size  = st.st_size;
      
      for (t=0; t<MAXTRANS; t++)
        {
          if ((gdata.trans[t] != NULL) &&
              (gdata.trans[t]->tr_status != TRANSFER_STATUS_DONE) &&
              (gdata.trans[t]->xpack == xpack))
            {
              t_closeconn(gdata.trans[t],"Pack file changed",0);
            }
        }
    }
  
  return;
}


/* End of File */
