#include <stdlib.h>
#include <string.h>


#include "prototypes.h"

/*
   Copyright (C) 2003 Red Hat, Inc. All rights reserved.
                                                                                                             
   Usage and distribution of this file are subject to the Open Software License version 1.1
   that can be found at http://www.opensource.org/licenses/osl-1.1.txt and the COPYING file as
   distributed together with this file is included herein by reference.
                                                                                                                      
   Author: Arjan van de Ven   <arjanv@redhat.com>

*/

/*
 Code to classify the type of irq source based on the strings modules register.
 Evil. Yuck. Ugly. Separated out to a separate file for that reason. Needs rewriting.
 Should probably read a file from disk instead of hardcoded arrays.
 /boot/module-info ?
 */
 

char *legacy_modules[] = {
 	"PS/2",
 	"serial",
 	"i8042",
 	"acpi",
 	"keyboard",
 	"usb-ohci",
	"usb-uhci",
	"uhci_hcd",
	"ohci_hcd",
	"ehci_hcd",
	"EMU10K1",
	0
};

char *timer_modules[] = {
 	"rtc",
 	"timer",
	0
};

char *storage_modules[] = {
	"aic7xxx",
	"ide",
	"cciss",
	"cpqarray",
	"qla2",
	"megaraid",
	"fusion",
	"oic",
	"libata",
	"ohci1394",
	0
};

char *ethernet_modules[] = {
	"eth",
	"e100",
	"eepro100",
	"orinico_cs",
	"wvlan_cs",
	"3c5",	
	"HiSax",
	0
};

char *gige_modules[] = {
	"e1000",
	"tg3",
	0
};

unsigned int class_policy[16];


void classify_type(int irqnumber, char *moduletext)
{
	int guess = IRQ_OTHER;
	int i;
	
	if (moduletext == NULL)
		return;
		
	for (i=0; legacy_modules[i]; i++)
		if (strstr(moduletext, legacy_modules[i]))
			guess = IRQ_LEGACY;

	for (i=0; storage_modules[i]; i++)
		if (strstr(moduletext, storage_modules[i]))
			guess = IRQ_SCSI;

	for (i=0; timer_modules[i]; i++)
		if (strstr(moduletext, timer_modules[i]))
			guess = IRQ_TIMER;
			
	for (i=0; ethernet_modules[i]; i++)
		if (strstr(moduletext, ethernet_modules[i]))
			guess = IRQ_ETH;


	for (i=0; gige_modules[i]; i++)
		if (strstr(moduletext, gige_modules[i]))
			guess = IRQ_GIGE;
	
	if (guess >  interrupts[irqnumber].type)	
		interrupts[irqnumber].type = guess;

}
