'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) checkbox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS checkbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
checkbox \- Create and manipulate a checkbox widget
.SH SYNOPSIS
\fBcheckbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- labeledframe <- checkbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBdisabledForeground\fR
\fBforeground\fR	\fBrelief\fR	\fBselectColor\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
.fi
.LP
See the "labeledframe" class manual entry for details on the 
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:   \fBcommand\fR
Class:  \fBCommand\fR
Command-Line Switch:    \fB-command\fR
.fi
.IP
Specifies a Tcl command procedure to be evaluated following a  change in 
the current check box selection.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBcheckbox\fR command creates a check button box widget 
capable of adding, inserting, deleting, selecting, and configuring 
checkbuttons as well as obtaining the currently selected button.

.SH "METHODS"
.PP
The \fBcheckbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  
.PP
Many of the widget commands for the \fBcheckbox\fR take as one argument an
indicator of which checkbutton of the checkbox to operate on.  These indicators
are called \fIindexes\fR and allow reference and manipulation of checkbuttons.
Checkbox indexes may be specified in any of the following forms:
.TP 12
\fInumber\fR
Specifies the checkbutton numerically, where 0 corresponds to the top 
checkbutton of the checkbox.
.TP 12
\fBend\fR
Indicates the last checkbutton of the checkbox.
.TP 12
\fIpattern\fR
If the index doesn't satisfy one of the above forms then this
form is used.  \fIPattern\fR is pattern-matched against the tag of
each checkbutton in the checkbox, in order from top to bottom,
until a matching entry is found.  The rules of \fBTcl_StringMatch\fR
are used.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBadd\fR \fItag\fR ?\fIoption value option value\fR?
Adds a new checkbutton to the checkbuttond window on the bottom.  The command
takes additional options which are passed on to the checkbutton as construction
arguments.  These include the standard Tk checkbutton options.  The tag is
returned.
.TP
\fIpathName \fBbuttonconfigure\fR \fIindex\fR ?\fIoptions\fR?
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual checkbutton, 
whereas \fBconfigure\fRapplies to the options for the checkbox as a whole.
\fIOptions\fR may have any of the values accepted by the \fBadd\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcheckbox\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcheckbox\fR
command.
.TP
\fIpathName \fBdelete\fR \fIindex\fR
Deletes a specified checkbutton given an \fIindex\fR.
.TP
\fIpathName \fBdeselect\fR \fIindex\fR
Deselects a specified checkbutton given an \fIindex\fR.
.TP
\fIpathName \fBflash\fR \fIindex\fR
Flashes a specified checkbutton given an \fIindex\fR.
.TP
\fIpathName \fBget\fR ?\fIindex\fR?
Returns the tags of the currently selected checkbuttons or the 
selection status of specific checkbutton when given an index.
.TP
\fIpathName \fBindex\fR \fIindex\fR
Returns the numerical index corresponding to index.
.TP
\fIpathName \fBinsert \fIindex\fR \fItag\fR ?\fIoption value option value ...\fR?
Same as the \fBadd\fR command except that it inserts the new
checkbutton just before the one given by \fIindex\fR, instead of appending
to the end of the checkbox.  The \fIoption\fR, and \fIvalue\fR
arguments have the same interpretation as for the \fBadd\fR widget
command.  
.TP
\fIpathName \fBselect\fR \fIindex\fR
Selects a specified checkbutton given an \fIindex\fR.

.SH EXAMPLE
.DS
 checkbox .cb -labeltext Styles
 .cb add bold -text Bold
 .cb add italic -text Italic
 .cb add underline -text Underline
 .cb select underline

 pack .cb -padx 10 -pady 10 -fill both -expand yes
.DE

.SH AUTHOR
John A. Tucker
.SH KEYWORDS
checkbox, widget
