/****************************************************************************
 *                           RemoteAppConnection.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements an interface to the connection between processes.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_REMOTE_APP_CONNECTION_H
#define INCLUDED_REMOTE_APP_CONNECTION_H
#include "types.h"
#include <tcl.h>

#define REMOTE_POLL_FOREVER (~((Uint32)0))

class RemoteAppConnectionListener;
class RemoteAppConnection {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * RemoteAppConnection()
         ************************************************************/
        RemoteAppConnection();

        /************************************************************
         * ~RemoteAppConnection()
         ************************************************************/
        virtual ~RemoteAppConnection();

        /************************************************************
         * HandleDisconnect()
         ************************************************************/
        virtual void HandleDisconnect();

        /************************************************************
         * isConnected()
         ************************************************************/
        virtual bool isConnected() { return d_connected; }

        /************************************************************
         * AddListener()
         ************************************************************/
        void AddListener(RemoteAppConnectionListener   *listener);

        /************************************************************
         * DeleteListener()
         *
         * Generally only used internally... Users just delete the
         * listener.
         ************************************************************/
        void DeleteListener(RemoteAppConnectionListener *listener);

        /************************************************************
         * DataRecv()
         ************************************************************/
        void DataRecv(Uint32 len, Uchar *buf);

        /************************************************************
         * DispatchPacket()
         ************************************************************/
        virtual void DispatchPacket(Uint32 idx, Uint32 len, Uchar *data);

        /************************************************************
         * Send()
         ************************************************************/
        virtual int Send(Uint32 idx, Uint32 len, Uchar *data);

        /************************************************************
         * Wait()
         *
         * Waits for data on a specific channel
         ************************************************************/
        virtual int Wait(Uint32 idx, Uint32 *len, Uchar **data);

        /************************************************************
         * Poll()
         ************************************************************/
        virtual int Poll(Uint32 timeout);

        /************************************************************
         * Connect()
         ************************************************************/
        virtual int Connect() { ; }

        /************************************************************
         * WriteUint32()
         ************************************************************/
        static void WriteUint32(Uint32 val, Uchar *buf, Uint32 &idx);

        /************************************************************
         * ReadUint32()
         ************************************************************/
        static Uint32 ReadUint32(Uchar *buf, Uint32 &idx);

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        /************************************************************
         * EventProc()
         ************************************************************/
        static void EventProc(ClientData clientData, int mask);

        /************************************************************
         * EventProc()
         ************************************************************/
        void EventProc(int mask);

    /****************************************************************
     * Protected Data
     ****************************************************************/
    protected:
        Tcl_Channel      d_channel;
        Int32            d_skt;
        Int32            d_connected;
        Int32            d_connectComplete;

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        enum {
            Rcv_ScanHdr,
            Rcv_ScanLen,
            Rcv_ScanIdx,
            Rcv_ScanData
        };

        RemoteAppConnectionListener        **d_connListeners;
        Uint32                               d_numConnListeners;
        Uint32                               d_maxConnListeners;

        Uchar                                d_hdrBuf[4];
        Uint32                               d_hdrBufIdx;

        Uchar                                d_idxBuf[4];
        Uint32                               d_idxBufIdx;
        Uint32                               d_idx;

        Uchar                                d_lenBuf[4];
        Uint32                               d_lenBufIdx;
        Uint32                               d_len;

        Uchar                               *d_dataBuf;
        Uint32                               d_dataBufIdx;
        Uint32                               d_dataBufMax;

        Uint32                               d_state;

        Uchar                               *d_xmitBuf;
        Uint32                               d_xmitBufLen;

        RemoteAppConnectionListener         *d_listeners[32];
};

#endif /* INCLUDED_REMOTE_APP_CONNECTION_H */
