#****************************************************************************
#*                             DialogMgr.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Manager for the dialog description
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************
namespace eval DialogMgr {
    namespace export DialogMgr load create

    variable d_mgr 
}


#********************************************************************
#* DialogMgr
#********************************************************************
proc DialogMgr::DialogMgr args {
    variable d_mgr 
    set d_mgr [dialog_mgr ::DialogMgr::dialog_mgr]
}


#********************************************************************
#* load
#********************************************************************
proc DialogMgr::load {file args} {
    variable d_mgr 
    $d_mgr load $file
}

#********************************************************************
#* create
#********************************************************************
proc DialogMgr::create {args} {
    variable d_mgr 
    return [eval $d_mgr create $args]
}



