.\"                                      Hey, EMACS: -*- nroff -*-
.\" First parameter, NAME, should be all caps
.\" Second parameter, SECTION, should be 1-8, maybe w/ subsection
.\" other parameters are allowed: see man(7), man(1)
.\"TH JACK 1 "#SHORTDATE#"
.TH JACK 1
.\" Please adjust this date whenever revising the manpage.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
Jack \- rip and encode CDs with one command
.SH SYNOPSIS
.B jack
.RI [ options ]
.SH DESCRIPTION
.B Jack 
transforms your audio-CDs to MP3 or Ogg Vorbis files. It uses several helper programs
in order to achieve things like ripping, encoding and ID3-tagging. 
Ripping is either done via
.B cdparanoia
(in which case the ripping status is displayed by Jack as well) or
.B cdda2wav.
Jack works with several encoders, namely 
.B oggenc, lame, gogo, bladeenc, l3enc, mp3enc
and
.B xing.
Any time during operation (and even when everything is finished and
the original CD lost) you can let Jack lookup the tracknames at 
.B freedb.org
and rename the tracks accordingly. ID3-tagging of MP3s is performed
as well. 
.br
If no freedb-lookup has been performed, Jack drops all files in a
.B jack-xxxxxxxx
directory, 
.B xxxxxxxx
representing the CDs ID. This directory is renamed by Jack when the
appropriate information is known.
.br 
Most options like ripper, encoder, preferred freedb-Server, directory
and MP3-filename format, etc. can be user defined by changing the
defaults in 
.B ~/.jackrc.
.PP
.\" TeX users may be more comfortable with the \fB<whatever>\fP and
.\" \fI<whatever>\fP escape sequences to invode bold face and italics, 
.\" respectively.

.SH OPTIONS
Jack understands the following options:
.TP
.B \-a, \-\-read-ahead <read_ahead>
read how many WAVs in advance. At most read_ahead + num_encoders
WAVs are ripped before a track has completely been encoded.
Default is 99 which will read the whole CD, provided there is
enough disk space.
.TP
.B \-b, \-\-bitrate <bitrate>
target bitrate (in kbit/s, default is 160).
.TP
.B \-c, \-\-check-toc 
compare toc-file and cd-toc, then exit. Jack caches the TOC of a
CD in a file ("jack.toc"). If you want to know if the inserted CD
matches the toc-file in the current directory, use this option.
.TP
.B \-C, \-\-claim-dir
rename directories even if they were was not created by Jack.
.TP
.B \-d, \-\-dont-work
don't do DAE or encoding. This may be useful if you only want to
do a freedb query.
.TP
.B \-D, \-\-create-dirs 
tells Jack to create sub-directories in which Jack puts all the
files for the current CD. If no freedb data is available, i.e.
when not using 
.B -Q
, these directorys will be named "jack-xxxxxxxx"
where "xxxxxxxx" stands for the CD's freedb-id. Otherwise
dir_template (see above) will be used. This option is turned on
by default.
.TP
.B \-\-device <device_name>
The device-name of your cdrom-drive. The default is 
.B /dev/cdrom
.TP
.B \-\-edit-cddb
open an editor to change the CDDB information which has been obtained
previously (only useful with -Q).
.TP
.B \-e, \-\-encoders <num_encoders>
encode how many files in parallel. If you have a SMP machine or
simply want to stress your system, you can have Jack encode
several files at once.
.TP
.B \-\-extt-is-artist
the artist is contained in the EXTT fields. The EXTT fields are lines in the
freedb file which contain additional data for each track. As it's the
submitting user's choice what to use them for, Jack can't determine by itself
what they were intended for. You have to provide this information.
.TP
.B \-\-extt-is-title
the track title is contained in the EXTT fields.
.TP
.B \-\-extt-is-comment
a track comment is contained in the EXTT fields.
.TP
.B \-f, \-\-from-tocfile <tocfile>
rip from a cdrdao created CD image on hd. The specified toc-file 
contains the name of the image file. Use
.B \-F
if jack can't find the image file.
.TP
.B \-F, \-\-from-image <image_file>
read audio data from image file. Like
.B \-\-from-tocfile
, but the
image itself is specified instead of the tocfile. If you
do not have a toc-file (or don't specify a toc-file),
the TOC is read from the CD itself.
.TP
.B \-\-force
do not ask. Like when deleting incomplete files.
.TP
.B \-g, \-\-guess-toc <mp3_files>
make up a TOC from the MP3 file given in mp3_files. Format is 
.B track_01.mp3 ... track_nn.mp3 ;
Note that the trailing "
.B ;
" is only necessary if you want to
append more options to your command line.
You can use it to do a freedb query based on
MP3s alone - no need for the CD. Very useful if you have no idea
which CD the MP3s are from. The MP3s must be given in the same
order as they were on their CD. The generated TOC file is
similar, but not identical to the TOC of the CD - do not submit
these!
.TP
.B \-G, \-\-id3-genre <id_genre>
set ID3 genre. Use 'help' to get a list of all known genres.
.TP
.B \-h, \-\-help
Show summary of options.
.TP
.B \-k, \-\-keep-wavs
do not delete WAVs after encoding them.
.TP
.B \-l, \-\-max-load <max_load>
only start new encoders if your system's load is below (max_load
+ num_encoders). If the load is too high, encoding operation is
suspended until above criterium is satisfied.
.TP
.B \-m, \-\-mail-submit
submit freedb entry via e-mail. HTTP submission is preferred. 
You will have to enter the category of the CD.
.TP
.B \-n, \-\-nice <nice_lvl>
nice-level with which the encoders are started. Default is 12
which shouldn't hurt your system much.
.TP
.B \-\-no-various
use this if freedb data says it's "Various Artists" but you want
the normal renaming scheme, e.g. if Jack can't seperate artist
and track title.
.TP
.B \-o, \-\-overwrite
overwrite existing files, i.e. do not check if already
ripped WAVs or an already encoded file seem to be ok. Use this if
you
.B know
something went wrong last time. This is off by default.
.TP
.B \-O, \-\-only-dae
only produce WAVs, implies 
.B \-\-keep-wavs.
This is off by default.
.TP
.B \-\-otf
On-the-fly operation. Only on some encoders/rippers. Do not
create WAVs, pipe ripper output through the encoder. Default is
no as it's a torture for the CDROM drive.
.TP
.B \-q, \-\-query
do freedb query when all is done. This is useful if Jack was prior
run without a freedb query. If all tracks are done you don't even
have to have a CD inserted as the TOC is cached by Jack. After
having finished ripping and encoding, Jack will rename the MP3s
and tag them using Ben Gertzfield's ID3.py module
.TP
.B \-Q, \-\-query-now
do freedb query when starting. Use this if you are connected to
the internet when starting Jack. Know that the query may need
user-interaction. After having finished ripping and encoding, Jack
will rename the files and tag them using Ben Gertzfield's ID3.py
module.
.TP
.B \-r, \-\-reorder
optimize track-order for disk space. This can save you some peak
disk space during the encoding process; this may make it possible
to do a CD which would otherwise fail to be encoded.
.TP
.B \-R, \-\-rename
rename and tag files according to freedb file. On startup, Jack
creates a blank freedb entry file (except if 
.B \-\-query-now
is used, 
then the file is queried from your freedb server). If you have
changed its contents (e.g. because the CD was unknown to freedb)
and want to rename and tag your MP3s accordingly, use this option.
Give all other needed options too, like
.B \-t
, 
.B \-E
, ...
.TP
.B \-\-remove
have Jack remove it's temp jack*-files.
Be careful - don't delete them too early!
.TP
.B \-s, \-\-space <free_space>
forcably set usable diskspace, in bytes. This option lets you
limit the disk space Jack uses, maybe you need it for something
else? Be careful: if set too high, ripping and encoding will
probably fail. The default is to look how much is free and to use
this value.
.TP
.B \-S, \-\-swab
swap byteorder from image file. As cdrdao momentarily only
outputs "raw" .cdr files, you quite likely want to swap the
byteorder. Try this option if your WAVs and encoded files contain 
only noise.
This is on by default as cdrdao currently generates .cdr files
that are "wrong".
.TP
.B \-\-scan-dirs <recurse_dirs>
Scan 
.B <recurse_dirs>
levels from the current working directory for a matching toc-file.
.TP
.B \-\-search <search_dir>
add <search_dir> to the list of directories searched when looking for the
workdir.
.TP
.B \-\-server <freedb_server> 
which freedb server to use. Don't forget to set your proxy.
Default server is freedb.freedb.org.
.TP
.B \-\-silent-mode
be quiet (no screen output).
.TP
.B \-\-submit
submit freedb entry via HTTP. You will have to enter the category
of the CD.
.TP
.B \-t, \-\-tracks <tracks>
limit ripping and encoding to the specified tracks, use comma to
seperate tracks. Ranges are also possible; 5-9 is equivalent to
5,6,7,8,9; 12- is like specifying track 12,...,last_track. The
default is to process the whole CD.
.TP
.B \-\-todo
print what would be done and exit.
.TP
.B \-u, \-\-undo-rename
undo file renaming and exit. If you don't like how Jack renamed
your files, use this option to restore the previous state.
Several levels of undo are possible. Note
that ID3 tags are not restored.
.TP
.B \-\-upd-progress
have Jack re-create it's temp files. Use this if you deleted them
too early.
.TP
.B \-v, \-\-vbr
Generate variable bitrate files, only on encoders which support
this. Default is no.
.TP
.B \-\-various
when parsing freedb data, Jack assumes that if the disc\'s artist
is set to "Various Artists" the track titles have the format
"[artist] - [title]". If the disc title is set to something else
and you still want above behaviour, use 
.B \-\-various.
.TP
.B \-\-various-swap
exchange artist and title, many freedb entries have them wrong.
.TP
.B \-\-wait
wait for key press before quitting.
.TP
.B \-x, \-\-exec
run predefined command when finished.
.TP
.B \-Y, \-\-id3-year <id3_year>
set ID3 year.
.br
.br
.SH EXAMPLES
Insert a CD, fire up jack:
.RS
jack
.RE
.PP
Now watch it work. It's fun for a while. After having finished, you have
the follwing files on your HD: track_01.mp3, track_02.mp3, ...,
track_nn.mp3 plus jack.toc, jack.freedb, jack.progress. The last three are
used to store the state jack is in so it can resume work when interrupted.
.br
Jack will create a directory called jack-xxxxxxxx for you, there it
stores all the file for the CD whose id is xxxxxxxx. After a freedb query
this directory is renamed to something human readable, like "Artist -
Title".
.br
When jack is interrupted, call it again using the same commandline as
before to resume work, in this case
.RS
jack
.RE
.PP
Now let's try a freedb query:
.RS
jack -q
.RE
.PP
when succesful the files are now renamed to something more readable and 
have been ID3 tagged accordingly. jack.freedb contains the queried freedb
entry, the original file has been backed up to jack.freedb.bak.
.br
All in one: query, rip, encode, cleanup:
.RS
jack -Q --remove
.RE
.PP
.br
Editing / normalizing / stripping the WAV files before encoding:
.RS
jack -O --remove ; gnoise *wav ; jack -g *wav ; jack
.RE
.PP
Just replace gnoise by the operation you'd like to perform.
.br
.SH AUTHOR
Arne Zellentin <zarne@users.sf.net> is the author of Jack.
.SH SEE ALSO
.BR cdparanoia (1)
,
.BR cdda2wav (1)
,
.BR oggenc (1)
and
.BR lame (1)
