/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2008 Olivier Guilyardi <olivier {at} samalyse {dot} com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   SVN:$Id: common.h 124 2008-01-10 19:10:45Z olivier $
 */

#ifndef JACKBEAT_GUI_COMMON_H
#define JACKBEAT_GUI_COMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <libgen.h>
#include <config.h>
#include <assert.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <dirent.h>

#include "song.h"
#include "sequence.h"
#include "sample.h"
#include "gui.h"
#include "jab.h"
#include "error.h"
#include "grid.h"
#include "gui/track.h"
#include "gui/file.h"

#ifdef MEMDEBUG
#include "memdebug.h"
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#undef USE_KNOB 
#ifdef USE_PHAT
#include "phat/phat.h"
#endif

/* GUI object type */
struct gui_t
{
  /* nested objects */
  song_t *              song;
  sequence_t *          sequence;
  rc_t *                rc;
  arg_t *               arg;
  /* flags & info */
  char                  filename[256];
  int                   sequence_is_modified;
  int                   refreshing;
  int                   filename_is_set;
  int                   transpose_volumes_round;
  int                   instance_index;
  char                  name_prefix[256];
  int                   last_export_framerate;
  int                   last_export_sustain_type;
  char                  last_export_wdir[512];
  /* widgets */
  GtkWidget *           window;
  GtkWidget *           tracks_box;
  GtkWidget *           main_vbox;
  GtkWidget *           tracks_num;
  GtkWidget *           beats_num;
  GtkWidget *           measure_len;
  GtkWidget *           bpm;
  GtkWidget *           loop;
  GtkWidget *           rewind;
  GtkWidget *           progress_window;
  GtkWidget *           progress_bar;
  GtkTooltips *         tooltips;
  GtkWidget **          volume_spinners;
  GtkWidget *           file_selection;
  grid_t *              grid;
  /* callback helpers */
  gui_track_button_t *  tracks_buttons;
  gui_track_sample_t *  track_samples;
  gint                  timeout_tag;
};

void      gui_new_child (rc_t *rc, arg_t *arg, gui_t *parent, song_t *song, 
                         sequence_t *sequence, char *filename);
void      gui_set_modified (gui_t * gui, int status);
gboolean  gui_no_delete (GtkWidget *widget, GdkEvent  *event, gpointer data);
void      gui_show_progress (gui_t *gui, char *title, char *text);
void      gui_hide_progress (gui_t * gui);
void      gui_refresh (gui_t * gui);
void      gui_progress_callback (char * status, double fraction, void * data);
void      gui_display_error (gui_t * gui, char *text);
int       gui_ask_confirmation (gui_t * gui, char *text);
char *    gui_get_next_sequence_name (gui_t *);

#define DEBUG(M, ...) { printf("GUI %.2d  %s(): ",gui->instance_index, __func__); printf(M, ## __VA_ARGS__); printf("\n"); }

#endif
